package com.elitesland.fin.repo.writeoff;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.fin.application.facade.dto.writeoff.PayOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.payorder.FinPayOrderDetailQuery;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDO;
import com.elitesland.fin.domain.entity.payorder.QPayOrderDtlDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * 收款单.
 *
 * @author shihao.ma
 * @since 2023/9/14
 */
@Repository
public class PayOrderDetailRepoProc extends BaseRepoProc<PayOrderDtlDO> {
    private static final QPayOrderDO QMas = QPayOrderDO.payOrderDO;
    private static final QPayOrderDtlDO QDetail = QPayOrderDtlDO.payOrderDtlDO;

    protected PayOrderDetailRepoProc() {
        super(QDetail);
    }
    public PayOrderDtlDO getPayOrderDetailAmt(Long payDId) {
        JPAQuery<PayOrderDtlDO> select = jpaQueryFactory.select(Projections.fields(PayOrderDtlDO.class,
                        QDetail.id,
                        QDetail.totalAmt,
                        QDetail.verAmt,
                        QDetail.applyVerAmTing,
                        QDetail.auditDataVersion,
                        QDetail.unVerAmt
                ))
                .from(QDetail)
                .where(QDetail.id.eq(payDId));
        return select.fetchOne();
    }

    /**
     * 更新核销金额.
     *
     * @param update 更新结果
     * @return 更新条数
     */
    public long updateVerAmt(PayOrderAmtUpdateDTO update) {
        return jpaQueryFactory.update(QDetail)
                .set(QDetail.verAmt, update.getVerAmt())
                .set(QDetail.applyVerAmTing, update.getVerAmting())
                .set(QDetail.unVerAmt, update.getUnVerAmt())
                .set(QDetail.auditDataVersion, update.getVersion() + 1)
                .where(QDetail.id.eq(update.getPayDId()).and(QDetail.auditDataVersion.eq(update.getVersion())))
                .execute();
    }
    public long updateExtVerAmt(PayOrderAmtUpdateDTO update) {
        return jpaQueryFactory.update(QDetail)
                .set(QDetail.verAmt, update.getVerAmt())
                .set(QDetail.applyVerAmTing, update.getVerAmting())
                .set(QDetail.unVerAmt, update.getUnVerAmt())
                .set(QDetail.auditDataVersion, update.getVersion() + 1)
                .where(QDetail.id.eq(update.getPayDId()).and(QDetail.auditDataVersion.eq(update.getVersion())))
                .execute();
    }
    /**
     * 查询应收单明细、明细扩展集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    public List<PayOrderDtlVO> listRecOrderDetail(FinPayOrderDetailQuery query) {

        JPAQuery<PayOrderDtlVO> select = jpaQueryFactory.select(Projections.bean(PayOrderDtlVO.class,
                        QDetail.id,
                        QDetail.masId,
                        QDetail.recBank,
                        QDetail.recAccount,
                        QDetail.sourceNo,
                        QDetail.sourceId,
                        QDetail.sourceLine,
                        QDetail.sourceLineId,
                        QDetail.totalAmt,
                        QDetail.totalCurAmt,
                        QDetail.expensesType,
                        QDetail.unVerAmt,
                        QDetail.verAmt,
                        QDetail.applyVerAmTing,
                        QDetail.auditDataVersion
                ));

        List<Predicate> predicates = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(query.getPayDIds())) {
            predicates.add(QDetail.id.in(query.getPayDIds()));
        }

        if (CollectionUtils.isNotEmpty(query.getMasIds())) {
            predicates.add(QDetail.masId.in(query.getMasIds()));
        }

        select.where(ExpressionUtils.allOf(predicates));
        return select.fetch();
    }
}
