package com.elitesland.fin.application.service.artype;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.artype.ArTypeConvert;
import com.elitesland.fin.application.convert.artype.ArTypeDtlConvert;
import com.elitesland.fin.application.facade.param.artype.ArTypeParam;
import com.elitesland.fin.application.facade.vo.artype.ArTypeDtlVO;
import com.elitesland.fin.application.facade.vo.artype.ArTypeVO;
import com.elitesland.fin.domain.entity.artype.ArType;
import com.elitesland.fin.domain.entity.artype.ArTypeDtl;
import com.elitesland.fin.domain.param.artype.ArTypeDtlPageParam;
import com.elitesland.fin.domain.param.artype.ArTypePageParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeDtlDomainService;
import com.elitesland.fin.domain.service.artype.ArTypeOuDomainService;
import com.elitesland.fin.infr.dto.artype.ArTypeDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeDtlDTO;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.service.artype
 * @date 2022/4/11 13:40
 */
@Service
@RequiredArgsConstructor
public class ArTypeServiceImpl implements ArTypeService {

    private final ArTypeDomainService arTypeDomainService;
    private final ArTypeOuDomainService arTypeOuDomainService;

    private final ArOrderDomainService arOrderDomainService;
    private final ArTypeDtlDomainService arTypeDtlDomainService;

    @Override
    public ApiResult<Long> save(ArTypeParam arTypeParam) {
        ArType arType = ArTypeConvert.INSTANCE.convert(arTypeParam);
        if (CollectionUtil.isNotEmpty(arTypeParam.getDtlList())){
            List<ArTypeDtl> arTypeDtlList = arTypeParam.getDtlList().stream().map(ArTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            arType.setDtlList(arTypeDtlList);
        }
        Long res = arTypeDomainService.save(arType);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<Long> update(ArTypeParam arTypeParam) {
        if (null == arTypeParam.getId()) {
            throw new BusinessException("主键id不能为空");
        }
        ArType arType = ArTypeConvert.INSTANCE.convert(arTypeParam);
        if (CollectionUtil.isNotEmpty(arTypeParam.getDtlList())){
            List<ArTypeDtl> arTypeDtlList = arTypeParam.getDtlList().stream().map(ArTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            arType.setDtlList(arTypeDtlList);
        }
        Long res = arTypeDomainService.update(arType);
        return ApiResult.ok(res);
    }

    @Override
    @SysCodeProc
    public ApiResult<ArTypeVO> get(Long id) {
        ArTypeDTO res = arTypeDomainService.get(id);
        ArTypeVO arTypeVO = ArTypeConvert.INSTANCE.convert(res);
        List<ArTypeDtlDTO> arTypeDtlDTOList = arTypeDtlDomainService.selectByMasId(res.getId());
        if (CollectionUtil.isNotEmpty(arTypeDtlDTOList)){
            List<ArTypeDtlVO> arTypeDtlVOList = arTypeDtlDTOList.stream().map(ArTypeDtlConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
            arTypeVO.setDtlList(arTypeDtlVOList);
        }
        return ApiResult.ok(arTypeVO);
    }

    @Override
    @SysCodeProc
    public ApiResult<PagingVO<ArTypeVO>> page(ArTypePageParam arTypePageParam) {
        if (StringUtils.isNotBlank(arTypePageParam.getSourceDoc()) || CollectionUtil.isNotEmpty(arTypePageParam.getSourceDocList())){
            List<String> sourceDocList = new ArrayList<>();
            if (StringUtils.isNotBlank(arTypePageParam.getSourceDoc())){
                sourceDocList.add(arTypePageParam.getSourceDoc());
            }
            if (CollectionUtil.isNotEmpty(arTypePageParam.getSourceDocList())){
                sourceDocList.addAll(arTypePageParam.getSourceDocList());
            }

            ArTypeDtlPageParam arTypeDtlPageParam = new ArTypeDtlPageParam();
            arTypeDtlPageParam.setSourceDocList(sourceDocList);
            List<ArTypeDtlDTO> arTypeDtlDTOList = arTypeDtlDomainService.selectListByParam(arTypeDtlPageParam);
            if (CollectionUtil.isEmpty(arTypeDtlDTOList)){
                return ApiResult.ok(PagingVO.<ArTypeVO>builder().total(0L).records(Collections.EMPTY_LIST).build());
            }
            List<Long> masIds = arTypeDtlDTOList.stream().map(ArTypeDtlDTO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            arTypePageParam.setIdList(masIds);
        }


        PagingVO<ArTypeDTO> res = arTypeDomainService.page(arTypePageParam);
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertPage(res));
    }

    @Override
    public ApiResult<Boolean> updateEnableFlag(List<Long> ids, boolean enable) {
        List<ArTypeDTO> arTypeDTOS = arTypeDomainService.findByIds(ids);
        if (enable) {
            checkEnableRule(arTypeDTOS);
        }
        if (!enable) {
            checkStopRule(arTypeDTOS);
        }
        Boolean res = arTypeDomainService.updateEnableFlag(ids, enable);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<Long> updateDef(Long id) {
        Long res = arTypeDomainService.updateDef(id);
        return ApiResult.ok(res);
    }

    @Override
    public ApiResult<Long> del(Long id) {
        // 查询是否已被公司使用
        List<ArTypeOuDTO> arTypeOuDTOS = arTypeOuDomainService.queryByArTypeId(id);
        if (CollUtil.isNotEmpty(arTypeOuDTOS)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "该数据已分配公司!");
        }
        Boolean aBoolean = arOrderDomainService.queryByArTypeId(id);
        if(aBoolean){
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "该数据已关联应收单!");
        }

        Long res = arTypeDomainService.del(id);
        return ApiResult.ok(res);
    }

    @Override
    @SysCodeProc
    public ApiResult<List<ArTypeVO>> getList() {

        List<ArTypeDTO> res = arTypeDomainService.getList();
        return ApiResult.ok(ArTypeConvert.INSTANCE.convertList(res));
    }

    @Override
    @SysCodeProc
    public ApiResult<ArTypeVO> getDef() {
        ArTypeDTO res = arTypeDomainService.getDef();
        if (res == null) {
            return ApiResult.ok(new ArTypeVO());
        }
        ArTypeVO arTypeVO = ArTypeConvert.INSTANCE.convert(res);
        arTypeVO.setDtlList(Collections.EMPTY_LIST);
        List<ArTypeDtlDTO> arTypeDtlDTOList = arTypeDtlDomainService.selectByMasId(arTypeVO.getId());
        if (CollectionUtil.isNotEmpty(arTypeDtlDTOList)){
            List<ArTypeDtlVO> arTypeDtlVOList = arTypeDtlDTOList.stream().map(ArTypeDtlConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
            arTypeVO.setDtlList(arTypeDtlVOList);
        }
        return ApiResult.ok(arTypeVO);
    }

    /**
     * 停用状态校验
     */
    private void checkStopRule(List<ArTypeDTO> arTypeDTOS) {
        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            // 停用需是启用状态
            if (!arTypeDTO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "已停用状态不能再停用");
            }
        }
    }

    /**
     * 启用状态校验
     */
    private void checkEnableRule(List<ArTypeDTO> arTypeDTOS) {

        for (ArTypeDTO arTypeDTO : arTypeDTOS) {
            // 启用需是停用状态
            if (arTypeDTO.getEnableFlag()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "已启用状态不能再启动");
            }
            // 启用需校验已分配公司
            List<ArTypeOuDTO> arTypeOuDTOS = arTypeOuDomainService.queryByArTypeId(arTypeDTO.getId());
            if (CollUtil.isEmpty(arTypeOuDTOS)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "类型代码"+arTypeDTO.getArTypeCode()+"启用前需要分配公司");
            }

        }

    }
}
