package com.elitesland.fin.application.service.recorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.recorder.FinRecOrderDetailQuery;
import com.elitesland.fin.application.facade.param.recorder.RecOrderDtlExPageParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderDtlExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderExVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderInfoVo;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;

import java.math.BigDecimal;
import java.util.List;
import com.elitesland.fin.application.facade.param.recorder.RecOrderExPageParam;
/**
 * @author lucan.liu
 * @date 2023-09-08 14:29
 */
public interface RecOrderExService {

    PagingVO<RecOrderExVo> getPage(RecOrderExPageParam recOrderExPageParam);


    PagingVO<RecOrderDtlExVo> getDtlPage(RecOrderDtlExPageParam recOrderDtlExPageParam);


    RecOrderExVo getDetailExInfo(RecOrderVO recOrderVO);

    /**
     * 查询明细集合.
     *
     * @param query 查询条件
     * @return 查询结果集
     */
    List<RecOrderDtlExVo> listRecOrderDetail(FinRecOrderDetailQuery query);

    /**
     * 更新核销金额.
     *
     * @param recDId 明细ID
     * @param amt    金额
     * @param verType    核销类型
     */
    void updateVerAmt(Long recDId, BigDecimal amt,String verType);

    /**
     * 更新核销中金额.
     *
     * @param recDId 明细ID
     * @param amt    金额
     */
    void updateMiddleVerAmt(Long recDId, BigDecimal amt);

	/**
	 * 获取收款单详情信息
	 * @param id
	 * @return
	 */
	ApiResult<RecOrderInfoVo> info(Long id);
}
