package com.elitesland.fin.application.web.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAutoRepaymentJobParam;
import com.elitesland.fin.application.service.creditaccount.CreditAccountAutoRepaymentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/01/10
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/creditAccount/autoRepayment")
@Api(value = "信用账户自动还款", tags = {"信用账户自动还款"})
@AllArgsConstructor
public class CreditAccountAutoRepaymentController {

    private final CreditAccountAutoRepaymentService creditAccountAutoRepaymentService;

    @PostMapping("/scheduledTask")
    @ApiOperation("定时任务执行接口")
    public ApiResult<?> saveOrUpdate(@RequestBody CreditAutoRepaymentJobParam jobParam) {
        creditAccountAutoRepaymentService.autoRepayment(jobParam);
        return ApiResult.ok();
    }

}
