package com.elitesland.fin.application.web.recorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.recorder.RecOrderRpcTwoService;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcPageRespVo;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcSaveParam;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcTwoParam;
import com.elitesland.fin.domain.param.recorder.RecOrderRpcUpdateParam;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

@Slf4j
@Api(tags = "收款单Tims")
@RestController
@RequestMapping(value = "/recOrderRpc", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class RecOrderRpcController {
    private final RecOrderRpcTwoService recOrderRpcTwoService;

    /**
     * 收款单保存
     *
     * @param recOrderRpcSaveParam
     * @return
     */
    @ApiOperation(value = "收款单-保存")
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody RecOrderRpcSaveParam recOrderRpcSaveParam) {
        log.info("[FIN-RECORDERRPC] save  param ={}", recOrderRpcSaveParam);
        return ApiResult.ok(recOrderRpcTwoService.save(recOrderRpcSaveParam));
    }

    @ApiOperation(value = "收款单-分页查询")
    @PostMapping(value = "/list")
    public ApiResult<PagingVO<RecOrderRpcPageRespVo>> queryRecOrderRpcPageList(@RequestBody RecOrderRpcTwoParam recOrderRpcTwoParam) {
        log.info("[FIN-RECORDERRPC] list  param ={}", recOrderRpcTwoParam);
        return ApiResult.ok(recOrderRpcTwoService.queryRecOrderRpcPageList(recOrderRpcTwoParam));
    }

    @ApiOperation(value = "收款单-详情查询")
    @GetMapping(value = "/queryRecOrderDetail/{id}")
    public ApiResult<Optional<RecOrderRpcPageRespVo>> queryRecOrderDetail(@PathVariable("id") Long id) {
        log.info("[FIN-RECORDERRPC] queryRecOrderDetail  param ={}", id);
        return ApiResult.ok(recOrderRpcTwoService.queryRecOrderDetail(id));
    }

    @ApiOperation(value = "收款单-修改")
    @PostMapping(value = "/updateRecOrder")
    public ApiResult<Object> update(@RequestBody RecOrderRpcUpdateParam recOrderRpcUpdateParam) {
        log.info("[FIN-RECORDERRPC] update param ={}", recOrderRpcUpdateParam);
        return ApiResult.ok(recOrderRpcTwoService.update(recOrderRpcUpdateParam));
    }

    @ApiOperation(value = "收款单-作废")
    @PostMapping(value = "/enableState")
    public ApiResult<Object> enableState(@RequestBody RecOrderRpcTwoParam recOrderRpcTwoParam) {
        log.info("[FIN-RECORDERRPC] update  id ={}, state ={}", recOrderRpcTwoParam.getMasId(), recOrderRpcTwoParam.getOrderState());
        return ApiResult.ok(recOrderRpcTwoService.enableRecOrderState(recOrderRpcTwoParam.getMasId(), recOrderRpcTwoParam.getOrderState()));
    }

    @ApiOperation("导出收款单")
    @PostMapping(value = "/export")
    public void export(@RequestBody RecOrderRpcTwoParam param, HttpServletResponse response){
        recOrderRpcTwoService.exportExcel(param, response);
    }

    @ApiOperation("【工作流相关】提交流程")
    @GlobalTransactional
    @GetMapping(value = "/submit/{id}")
    public ApiResult<Void> submit(@PathVariable("id") Long id) {
        recOrderRpcTwoService.submit(id);
        return ApiResult.ok();
    }
}
