package com.elitesland.fin.domain.service.expense;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpTypeDtlConvert;
import com.elitesland.fin.domain.expense.ExpTypeDtl;
import com.elitesland.fin.domain.expense.ExpTypeDtlDO;
import com.elitesland.fin.domain.param.expense.ExpTypeDtlPageParam;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDtlDTO;
import com.elitesland.fin.infr.repo.expense.ExpTypeDtlRepo;
import com.elitesland.fin.infr.repo.expense.ExpTypeDtlRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/8/08 17:37
 * @Description:
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ExpTypeDtlDomainServiceImpl implements ExpTypeDtlDomainService {

    private final ExpTypeDtlRepo expTypeDtlRepo;
    private final ExpTypeDtlRepoProc expTypeDtlRepoProc;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void save(List<ExpTypeDtl> dtlList) {
        List<ExpTypeDtlDO> expTypeDtlDOList =
                dtlList.stream().map(ExpTypeDtlConvert.INSTANCE::enToDo).collect(Collectors.toList());
        expTypeDtlRepo.saveAll(expTypeDtlDOList);
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDtlDTO> selectByMasId(Long masId) {
        List<ExpTypeDtlDO> expTypeDtlDOList = expTypeDtlRepo.findAllByMasId(masId);
        if (CollectionUtil.isEmpty(expTypeDtlDOList)) {
            return Collections.EMPTY_LIST;
        }

        List<ExpTypeDtlDTO> expTypeDtlDTOList =
                expTypeDtlDOList.stream().map(ExpTypeDtlConvert.INSTANCE::doToDto).collect(Collectors.toList());

        return expTypeDtlDTOList;
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDtlDTO> selectByMasIds(List<Long> masIds) {
        List<ExpTypeDtlDO> expTypeDtlDOList = expTypeDtlRepo.findAllByMasIdIn(masIds);
        if (CollectionUtil.isEmpty(expTypeDtlDOList)) {
            return Collections.EMPTY_LIST;
        }

        List<ExpTypeDtlDTO> expTypeDtlDTOList =
                expTypeDtlDOList.stream().map(ExpTypeDtlConvert.INSTANCE::doToDto).collect(Collectors.toList());

        return expTypeDtlDTOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<ExpTypeDtlDTO> page(ExpTypeDtlPageParam pageParam) {
        PagingVO<ExpTypeDtlDTO> pagingVO = expTypeDtlRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<ExpTypeDtlDTO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        return pagingVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIdBatch(List<Long> ids) {
        expTypeDtlRepo.deleteAllByMasIdIn(ids);
    }

    @Override
    @SysCodeProc
    public List<ExpTypeDtlDTO> selectListByParam(ExpTypeDtlPageParam pageParam) {
        List<ExpTypeDtlDTO> expTypeDtlDTOList = expTypeDtlRepoProc.selectListByParam(pageParam);
        if (CollectionUtils.isEmpty(expTypeDtlDTOList)) {
            return Collections.EMPTY_LIST;
        }

        return expTypeDtlDTOList;
    }
}
