package com.elitesland.fin.application.facade.param.arorder;

import com.elitesland.fin.domain.param.arorder.ArOrderDtlPageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lucan.liu
 * @date 2023-09-08 12:25
 */
@Data
public class ArOrderDtlExPageParam extends ArOrderDtlPageParam {

    private static final long serialVersionUID = -52878624856498061L;

    @ApiModelProperty("第三方应收单号")
    private String thirdOrderNum;

    @ApiModelProperty("销售公司")
    private String ouCode;

    @ApiModelProperty("业务员")
    private String businessCode;

    @ApiModelProperty("发票号码")
    private String invoiceNumber;

    @ApiModelProperty("开票日期开始")
    private LocalDateTime invStartDate;

    @ApiModelProperty("开票日期结束")
    private LocalDateTime invEndDate;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("订单日期开始")
    private LocalDateTime orderStartDate;

    @ApiModelProperty("订单日期结束")
    private LocalDateTime orderEndDate;

    @ApiModelProperty("主客户编码")
    private String custCode;

    @ApiModelProperty("主客户名称")
    private String custName;

    @ApiModelProperty("渠道类型")
    private String soSource;

    @ApiModelProperty("客户名称")
    private String customName;

    @ApiModelProperty("子客户编码")
    private String subCustCode;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("单据日期开始")
    private LocalDateTime createTimeStart;

    @ApiModelProperty("单据日期结束")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("应收单主表id")
    private Long masId;

    @ApiModelProperty("应收单主表ids")
    private List<Long> masIds;
}
