package com.elitesland.fin.application.facade.param.saobei.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author chaofeng.xia
 * @since 2025/8/18
 */
@ApiModel(value = "扫呗分账信息", description = "扫呗分账信息")
@Data
public class SaoBeiTransParam implements Serializable {

    private static final long serialVersionUID = -2239783444692111972L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("关联流水号")
    private String relateFlowNo;

    @ApiModelProperty("同步状态")
    private String syncStatus;

    @ApiModelProperty("同步状态")
    private List<String> syncStatusList;

    @ApiModelProperty("同步异常日志")
    private String syncLog;

    @ApiModelProperty("出账方账号")
    private String fromAccountNo;

    @ApiModelProperty("入账方账号")
    private String toAccountNo;

    @ApiModelProperty("出账公司")
    private String fromOuCode;
    @ApiModelProperty("出账公司名称")
    private String fromOuName;

    @ApiModelProperty("入账公司")
    private String toOuCode;
    @ApiModelProperty("入账公司名称")
    private String toOuName;

    @ApiModelProperty("来源根单据类型")
    private String rootDoc;

    @ApiModelProperty("来源根单号")
    private String rootDocNo;

    @ApiModelProperty("来源根单号")
    private List<String> rootDocNoList;

    @ApiModelProperty("BIP推送时间-开始")
    private LocalDateTime createTimeFrom;

    @ApiModelProperty("BIP推送时间-结束")
    private LocalDateTime createTimeTo;

    @ApiModelProperty("ids")
    private List<Long> ids;

    @ApiModelProperty("来源单据状态")
    private List<String> sourceDocStatusList;
}
