package com.elitesland.fin.application.facade.vo.saleinv;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author chaofeng.xia
 * @since 2025/8/9
 */
@Data
public class SaleInvDetailAppVO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -8937521963467421958L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("申请单号")
    private String applyNo;

    @ApiModelProperty("含税总金额(开票申请金额)")
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal totalAmt;

    @ApiModelProperty("对账申请时间")
    private LocalDateTime recApplyTime;

    @ApiModelProperty("根单据下单时间从")
    private LocalDateTime rootDocTimeFrom;

    @ApiModelProperty("根单据下单时间至")
    private LocalDateTime rootDocTimeTo;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-fin", mod = "INVOICE_STATUS")
    private String orderState;
    private String orderStateName;

}
