package com.elitesland.fin.entity.creditaccount;


import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

@Entity
@Table(name = "credit_account")
@org.hibernate.annotations.Table(appliesTo = "credit_account", comment = "信用账户表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class CreditAccountDO extends CustomFieldBaseModel {

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String ouCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "belong_type", columnDefinition = "varchar(16) comment '对象类型(客户组 客户)'")
    private String objectType;

    @Column(name = "object_name", columnDefinition = "varchar(64) comment '对象名称(客户组名称/客户名称)'")
    private String objectName;

    @Column(name = "object_code", columnDefinition = "varchar(32) comment '对象编码'")
    private String objectCode;

    @Column(name = "credit_account_code", columnDefinition = "varchar(32) comment '信用账户编码'")
    private String creditAccountCode;

    @Column(name = "credit_account_name", columnDefinition = "varchar(64) comment '信用账户名称'")
    private String creditAccountName;

    @Column(name = "credit_account_type", columnDefinition = "varchar(16) comment '信用账户类型'")
    private String creditAccountType;

    @Column(name = "salesman_no", columnDefinition = "varchar(32) comment '业务员编号'")
    private String salesmanNo;

    @Column(name = "salesman_name", columnDefinition = "varchar(32) comment '业务员姓名'")
    private String salesmanName;

   /* @Column(name = "dept_id", columnDefinition = "bigint(20) comment '部门ID'")
    private Long deptId;

    @Column(name = "dept_code", columnDefinition = "varchar(32) comment '部门编码'")
    private String deptCode;

    @Column(name = "dept_name", columnDefinition = "varchar(32) comment '部门名称'")
    private String deptName;

    @Column(name = "product_line_code", columnDefinition = "varchar(32) comment '产品线编码'")
    private String productLineCode;

    @Column(name = "product_line_name", columnDefinition = "varchar(32) comment '产品线名称'")
    private String productLineName;*/

    @Column(name = "credit_account_limit", columnDefinition = "decimal(18,8) comment '账户额度'")
    private BigDecimal creditAccountLimit;

    @Column(name = "credit_account_used_limit", columnDefinition = "decimal(18,8) comment '账户使用额度'")
    private BigDecimal creditAccountUsedLimit;

    @Column(name = "credit_account_occupancy_limit", columnDefinition = "decimal(18,8) comment '占用额度'")
    private BigDecimal creditAccountOccupancyLimit;

    @Column(name = "credit_account_available_limit", columnDefinition = "decimal(18,8) comment '可用额度'")
    private BigDecimal creditAccountAvailableLimit;

    @Column(name = "status", columnDefinition = "varchar(32) default 'CLOSED'  comment '是否启用，默认为禁用 [UDC]FIN:ACTIVE_STATUS'")
    private String status;

    @Column(name = "relate_account_code", columnDefinition = "varchar(32) comment '关联账户编码'")
    private String relateAccountCode;
}
