package com.elitesland.fin.infinity.aisino.vo.resp;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * 红票开具结果响应类
 * 用于接收航信红票开具接口的返回结果
 */
@Data
public class RedInvoiceResultResp {


    /**
     * 业务代码
     * "00" 表示业务处理成功
     */
    @JSONField(name = "CODE")
    private String CODE = "";

    /**
     * 业务消息
     * 对业务处理结果的描述
     */
    @JSONField(name = "MESSAGE")
    private String MESSAGE = "";

    /**
     * 发票号码
     * 开具的红字发票号码
     */
    @JSONField(name = "FPHM")
    private String FPHM = "";

    /**
     * 纸质发票号码
     * 纸质发票的发票号码
     */
    @JSONField(name = "ZZFPHM")
    private String ZZFPHM = "";

    /**
     * 发票代码
     * 发票的代码信息
     */
    @JSONField(name = "FPDM")
    private String FPDM = "";

    /**
     * 开票日期
     * 格式: yyyy-MM-dd HH:mm:ss
     */
    @JSONField(name = "KPRQ")
    private String KPRQ = "";

    /**
     * 销售方纳税人识别号
     */
    @JSONField(name = "XSFNSRSBH")
    private String XSFNSRSBH = "";

    /**
     * 购买方纳税人识别号
     */
    @JSONField(name = "GMFNSRSBH")
    private String GMFNSRSBH = "";

    /**
     * 销售方名称
     */
    @JSONField(name = "XSFMC")
    private String XSFMC = "";

    /**
     * 备注信息
     */
    @JSONField(name = "BZXX")
    private String BZXX = "";

    /**
     * 发票票种代码
     */
    @JSONField(name = "FPPZDM")
    private String FPPZDM = "";
}
