/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.config;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.fin.application.facade.dto.mq.AdjustOrderSubmitProcessMqMessageDTO;
import com.elitesland.fin.application.facade.dto.mq.InvoiceApplyProcessMqMessageDTO;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvdDtlDO;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvdDtlRepo;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceJobHandler {
    private static final Logger log = LoggerFactory.getLogger(InvoiceJobHandler.class);
    private final SaleInvdDtlRepo saleInvdDtlRepo;
    private final SaleInvRepo saleInvRepo;
    private final MessageQueueTemplate messageQueueTemplate;
    private final AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;

    @XxlJob(value="invoiceOrderGetResult")
    public ReturnT<String> invoiceGetResult(String param) {
        try {
            log.info("\u5f00\u59cb\u626b\u63cf\u5f00\u7968\u4e2d\u7684\u53d1\u7968...");
            List<SaleInvdDtlDO> allByInvState = this.saleInvdDtlRepo.findAllByInvState(UdcEnum.INV_STATE_ING.getValueCode());
            if (allByInvState != null && !allByInvState.isEmpty()) {
                log.info("\u627e\u5230 {} \u6761\u5f00\u7968\u4e2d\u7684\u53d1\u7968\uff0c\u5f00\u59cb\u63d0\u4ea4...", (Object)allByInvState.size());
                for (SaleInvdDtlDO draftOrder : allByInvState) {
                    AdjustOrderSubmitProcessMqMessageDTO messageDTO = new AdjustOrderSubmitProcessMqMessageDTO();
                    messageDTO.setId(draftOrder.getId());
                    messageDTO.setBusinessKey(draftOrder.getFlowNo());
                    try {
                        this.messageQueueTemplate.publishMessage("yst-fin", "invoice_opening_process", (Serializable)messageDTO);
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u5904\u7406\u5f00\u7968\u4e2d\u7684\u53d1\u7968,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
                    }
                }
            } else {
                log.info("\u672a\u627e\u5230\u5f00\u7968\u4e2d\u7684\u53d1\u7968");
            }
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u63d0\u4ea4\u5f00\u7968\u4e2d\u7684\u53d1\u7968\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="invoiceOrderSubmit")
    public ReturnT<String> invoiceSubmit(String param) {
        try {
            log.info("\u5f00\u59cb\u626b\u63cf\u5f85\u5f00\u7968\u7533\u8bf7..");
            List<SaleInvDO> allByInvState = this.saleInvRepo.findAllByInvState(UdcEnum.INVOICE_STATUS_DRAFT.getValueCode());
            if (CollectionUtil.isEmpty(allByInvState)) {
                log.info("\u672a\u627e\u5230\u5f85\u5f00\u53d1\u7968\u7533\u8bf7");
                return ReturnT.SUCCESS;
            }
            Map<String, List<SaleInvDO>> saleInvMap = allByInvState.stream().collect(Collectors.groupingBy(SaleInvDO::getSaleTaxNo));
            saleInvMap.forEach((key, value) -> {
                List<Long> list = value.stream().map(BaseModel::getId).toList();
                InvoiceApplyProcessMqMessageDTO messageDTO = new InvoiceApplyProcessMqMessageDTO();
                messageDTO.setIdList(list);
                messageDTO.setBusinessKey((String)key);
                try {
                    this.messageQueueTemplate.publishMessage("yst-fin", "invoice_apply_process", (Serializable)messageDTO);
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001mq\u6d88\u606f\uff0c\u5904\u7406\u5f85\u5f00\u7968\u7684\u53d1\u7968,\u540c\u6b65\u5185\u5bb9{}, \u5931\u8d25\u539f\u56e0\uff1a{}", (Object)messageDTO, (Object)e.getMessage());
                }
            });
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u63d0\u4ea4\u5f85\u5f00\u7968\u7684\u53d1\u7968\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return ReturnT.SUCCESS;
    }

    public InvoiceJobHandler(SaleInvdDtlRepo saleInvdDtlRepo, SaleInvRepo saleInvRepo, MessageQueueTemplate messageQueueTemplate, AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService) {
        this.saleInvdDtlRepo = saleInvdDtlRepo;
        this.saleInvRepo = saleInvRepo;
        this.messageQueueTemplate = messageQueueTemplate;
        this.abstractInvoiceSaveService = abstractInvoiceSaveService;
    }
}

