package com.elitesland.fin.application.facade.param.invoice;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/19
 */
@Data
@Accessors(chain = true)
@ApiModel("待开发票分页查询参数")
public class InvoiceAwaitQueryParam extends BaseModelParam {

    @ApiModelProperty("公司编码")
    private String ouCode;
    /*@ApiModelProperty("公司编码集合")
    private List<String> ouCodeList;*/
    @ApiModelProperty("客户名称")
    private String custName;
    @ApiModelProperty("客户名称集合")
    private List<String> custNameList;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户编码集合")
    private List<String> custCodeList;
    @ApiModelProperty("单号")
    private String docNo;
    @ApiModelProperty("单号集合")
    private List<String> docNoList;
    @ApiModelProperty("待开发票状态")
    private String invoiceAwaitStatus;
    @ApiModelProperty("待开发票状态集合")
    private List<String> invoiceAwaitStatusList;
//    @ApiModelProperty("公司名称")
//    private String ouName;

    @ApiModelProperty("来源单号")
    private String optDocNo;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;
    @ApiModelProperty("主客户编码集合")
    private List<String> mainCustCodeList;
    @ApiModelProperty("主客户名称")
    private String mainCustName;
    @ApiModelProperty("主客户名称集合")
    private List<String> mainCustNameList;
    @ApiModelProperty("对账类型-订单分组")
    private String docType3;
    @ApiModelProperty("对账类型-订单分组集合")
    private List<String> docType3List;
    /**
     * 订货人
     */
    @ApiModelProperty("订货人")
    private String recvContactName;
    /**
     * 订货联系电话
     */
    @ApiModelProperty("订货联系电话")
    private String recvContactTel;


    @ApiModelProperty("开票申请单号")
    private String invoiceApplyNo;
}
