package com.elitesland.fin.application.service.excel.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@ApiModel(value = "费用台帐", description = "费用台帐")
@Data
public class ExpLedgerExportEntity implements Serializable {

    @ExcelProperty(value = "公司")
    private String ouName;

    @ExcelProperty(value = "仓库")
    private String whName;

    @ExcelProperty(value = "物流公司")
    private String carrierName;

    @ExcelProperty(value = "品牌")
    private String brandName;

    @ExcelProperty("客户")
    private String custName;

    @ExcelProperty("门店")
    private String storeName;

    @ExcelProperty("费用类型")
    private String expTypeName;

    @ExcelProperty("单据类型")
    private String docTypeName;

    @ExcelProperty("单据编码")
    private String sourceDocNo;

    @ExcelProperty("出入库单号")
    private String stockNo;

    @ExcelProperty("出入库日期")
    private LocalDateTime stockDate;

    @ExcelProperty("来源单据日期")
    private LocalDate sourceDocNoDate;

    @ExcelProperty("含税金额")
    private BigDecimal amt;

    @ExcelProperty("未税金额")
    private BigDecimal netAmt;

    @ExcelProperty("税额")
    private BigDecimal taxAmt;

    @ExcelProperty("税率")
    private BigDecimal taxRate;

    @ExcelProperty("审批状态")
    private String orderStateName;

    @ExcelProperty("计算状态")
    private String calStateName;

    @ExcelProperty("单据金额")
    private BigDecimal docAmt;
}
