/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.imp;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.fin.application.facade.dto.mq.AdjustOrderSubmitProcessMqMessageDTO;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepo;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.util.Strings;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AdjustOrderSubmitProcessListener
implements MessageQueueListener<AdjustOrderSubmitProcessMqMessageDTO> {
    private static final Logger log = LoggerFactory.getLogger(AdjustOrderSubmitProcessListener.class);
    private final AdjustOrderService adjustOrderService;
    private final RedLockUtils redLockUtils;
    private final AdjustOrderRepo adjustOrderRepo;

    @NotEmpty
    public String[] channels() {
        return new String[]{"adjust_order_submit_process"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConsume(@NotBlank String s, @NotNull AdjustOrderSubmitProcessMqMessageDTO messageDTO) {
        log.info("\u8c03\u6574\u5355\u786e\u8ba4\u5904\u7406\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)messageDTO));
        RedissonRedLock redLock = null;
        AdjustOrderDO draftOrder = null;
        try {
            redLock = this.redLockUtils.getRedLock("adjust-order-submit-process" + messageDTO.getBusinessKey());
            boolean lockFlag = redLock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u8c03\u6574\u5355\u5df2\u5728\u5904\u7406\u4e2d,\u83b7\u53d6\u9501\u5931\u8d25");
                return;
            }
            Optional byId = this.adjustOrderRepo.findById(messageDTO.getId());
            if (byId.isEmpty()) {
                log.error("\u672a\u627e\u5230\u8c03\u6574\u5355");
                return;
            }
            draftOrder = (AdjustOrderDO)((Object)byId.get());
            if (!draftOrder.getState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                log.error("\u8c03\u6574\u5355\u4e0d\u5904\u4e8e\u8349\u7a3f\u72b6\u6001\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            if (!draftOrder.getProcessStatus().equals("TODO")) {
                log.error("\u8c03\u6574\u5355\u4e0d\u5904\u4e8e\u5f85\u5904\u7406\u72b6\u6001\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            this.adjustOrderService.workflowAndGenerateAccountFlow(draftOrder);
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u8c03\u6574\u5355\u65f6\u53d1\u751f\u5f02\u5e38,\u8c03\u6574\u5355\u53f7:{}", (Object)messageDTO.getBusinessKey(), (Object)e);
            if (draftOrder != null) {
                draftOrder.setProcessResult(e.getMessage());
                draftOrder.setState("REJECTED");
                draftOrder.setProcessStatus("FAIL");
            }
        }
        finally {
            if (redLock != null) {
                redLock.unlock();
                log.info("\u8c03\u6574\u5355\u786e\u8ba4\u5b8c\u6210\uff0c\u91ca\u653e\u9501\u6210\u529f");
            }
        }
        if (draftOrder != null && Strings.isNotBlank((String)draftOrder.getProcessResult())) {
            this.adjustOrderRepo.save((Object)draftOrder);
        }
    }

    public AdjustOrderSubmitProcessListener(AdjustOrderService adjustOrderService, RedLockUtils redLockUtils, AdjustOrderRepo adjustOrderRepo) {
        this.adjustOrderService = adjustOrderService;
        this.redLockUtils = redLockUtils;
        this.adjustOrderRepo = adjustOrderRepo;
    }
}

