/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.mq.MessageQueueListener;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitesland.fin.application.facade.dto.mq.InvoiceSaveProcessMqMessageDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.redisson.RedissonRedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InvoiceSaveProcessListener
implements MessageQueueListener<InvoiceSaveProcessMqMessageDTO> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceSaveProcessListener.class);
    private final RedLockUtils redLockUtils;
    private final InvoiceAwaitService invoiceAwaitService;
    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService;

    @NotEmpty
    public String[] channels() {
        return new String[]{"invoice_save_process"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConsume(@NotBlank String s, @NotNull InvoiceSaveProcessMqMessageDTO messageDTO) {
        log.info("\u5f85\u5f00\u7968\u6570\u636e\u5904\u7406\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)messageDTO));
        RedissonRedLock redLock = null;
        try {
            redLock = this.redLockUtils.getRedLock("invoice_save_process" + messageDTO.getBusinessKey());
            boolean lockFlag = redLock.tryLock(3L, 5L, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("\u5f85\u5f00\u7968\u6570\u636e\u5df2\u5728\u5904\u7406\u4e2d,\u83b7\u53d6\u9501\u5931\u8d25");
                return;
            }
            Long id = messageDTO.getId();
            Optional byId = this.invoiceAwaitRepo.findById(id);
            if (byId.isEmpty()) {
                log.error("\u672a\u627e\u5230\u5f85\u5f00\u7968\u6570\u636e");
                return;
            }
            InvoiceAwaitDO save = (InvoiceAwaitDO)byId.get();
            if (!Objects.equals(save.getInvoiceAwaitStatus(), UdcEnum.INVOICE_AWAIT_STATUS_WAIT.getValueCode())) {
                log.error("\u5f85\u5f00\u7968\u6570\u636e\u4e0d\u5904\u4e8e\u5f85\u5f00\u7968\u72b6\u6001\uff0c\u8df3\u8fc7\u5904\u7406");
                return;
            }
            InvoiceApplyParam applyParam = this.invoiceAwaitService.getInvoiceApplyParamByAwaitOrder(save);
            log.info("\u751f\u6210\u5f00\u7968\u7533\u8bf7\uff1a{}", (Object)JSONUtil.toJsonStr((Object)applyParam));
            this.abstractInvoiceSaveService.save(applyParam);
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u65f6\u53d1\u751f\u5f02\u5e38,\u5f85\u5f00\u7968\u6570\u636e\u5355\u53f7:{}", (Object)messageDTO.getBusinessKey(), (Object)e);
        }
        finally {
            if (redLock != null) {
                redLock.unlock();
                log.info("\u5f00\u7968\u5b8c\u6210\uff0c\u91ca\u653e\u9501\u6210\u529f");
            }
        }
    }

    public InvoiceSaveProcessListener(RedLockUtils redLockUtils, InvoiceAwaitService invoiceAwaitService, InvoiceAwaitRepo invoiceAwaitRepo, AbstractInvoiceSaveServiceImpl abstractInvoiceSaveService) {
        this.redLockUtils = redLockUtils;
        this.invoiceAwaitService = invoiceAwaitService;
        this.invoiceAwaitRepo = invoiceAwaitRepo;
        this.abstractInvoiceSaveService = abstractInvoiceSaveService;
    }
}

