package com.elitesland.fin.application.facade.param.saobei.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class SaobeiTradeItemRespVO {

    /**
     * 交易日期，格式：YYYYMMDD
     */
    @ApiModelProperty("交易日期，格式：YYYYMMDD")
    private String trans_date;
    /**
     * 交易时间，格式：HHMMSS
     */
    @ApiModelProperty("交易时间，格式：HHMMSS")
    private String trans_time;
    /**
     * 交易类型: 1.订单分账 2.余额分账3. 充值 4.提现 5.分账退回 6. 清分
     */
    @ApiModelProperty("交易类型: 1.订单分账 2.余额分账3. 充值 4.提现 5.分账退回 6. 清分")
    private String trans_type;
    /**
     * 资金方向 1：转出 2：转入
     */
    @ApiModelProperty("资金方向 1：转出 2：转入")
    private String trans_flag;
    /**
     * 交易金额，单位：分
     */
    @ApiModelProperty("交易金额，单位：分")
    private String amt;
    /**
     * CBK分账订单号
     */
    @ApiModelProperty("交易金额，单位：分")
    private String out_trade_no;
    /**
     * 通道分账订单号
     */
    @ApiModelProperty("通道分账订单号")
    private String channel_trade_no;
    /**
     * 0:成功
     */
    @ApiModelProperty("0:成功")
    private String trade_status;
    /**
     * 交易备注
     */
    @ApiModelProperty("交易备注")
    private String order_body;

}
