package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpLedgerQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpLedgerPageVO;
import com.elitesland.fin.application.service.excel.ExportConstants;
import com.elitesland.fin.application.service.excel.entity.ExpLedgerExportEntity;
import com.elitesland.fin.application.service.expense.ExpenseLedgerService;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import groovy.util.logging.Slf4j;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

@Component
@Slf4j
@RequiredArgsConstructor
public class ExpenseLedgerServiceImpl implements DataExport<ExpLedgerExportEntity, ExpLedgerQueryParam> {


    private final ExpenseLedgerService expenseledgerService;

    @Override
    public String getTmplCode() {
        return ExportConstants.FIN_EXPENSE_LEDGER_EXPORT;
    }

    @Override
    public Integer pageSize() {
        return 100;
    }

    public PagingVO<ExpLedgerExportEntity> executeExport(ExpLedgerQueryParam queryParam) {
        PagingVO<ExpLedgerPageVO> page = expenseledgerService.searchPage(queryParam);
        return new PagingVO<>(
                page.getTotal(),
                ExcelConvertUtils.convertLoosely(page.getRecords(), ExpLedgerExportEntity.class)
        );
    }

}
