package com.elitesland.fin.application.service.payorder;


import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.convert.paytype.PayTypeConvert;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplyApHeadConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySaveDTO;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerificationDTO;
import com.elitesland.fin.application.facade.dto.writeoff.PayOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.payorder.ApOrderToPaySaveParam;
import com.elitesland.fin.application.facade.param.payorder.FinPayOrderDetailQuery;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderDtlVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.facade.vo.paytype.PayTypeVO;
import com.elitesland.fin.application.facade.vo.writeoff.*;
import com.elitesland.fin.application.service.aporder.ApOrderService;
import com.elitesland.fin.application.service.paytype.PayTypeService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplyService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.entity.apordertopay.ApOrderToPay;
import com.elitesland.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtl;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.param.aptype.ApTypePageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeDomainService;
import com.elitesland.fin.domain.service.aptype.ApTypeOuDomainService;
import com.elitesland.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.domain.service.paytype.PayTypeDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeDTO;
import com.elitesland.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.dto.paytype.PayTypeDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayHeadRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyPayRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplyRepoProc;
import com.elitesland.fin.repo.writeoff.PayOrderDetailRepoProc;
import com.elitesland.fin.rpc.pur.RmiPurRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.pur.dto.supp.PurSuppBaseDTO;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuComRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgOuComRpcParam;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author zhiyu.he
 * @date 2022/3/16 13:03
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PayOrderServiceImpl implements PayOrderService {

    private final PayOrderRepo payOrderRepo;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RecOrderRepoProc recOrderRepoProc;
    private final RmiPurRpcService rmiPurRpcService;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    private final TransactionTemplate transactionTemplate;
    private final ApTypeOuDomainService apTypeOuDomainService;
    private final ApTypeDomainService apTypeDomainService;
    private final PayTypeService payTypeService;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final FinApPayVerApplyPayHeadRepoProc finApPayVerApplyPayHeadRepoProc;
    private final FinApPayVerApplyPayRepoProc finApPayVerApplyPayRepoProc;

    private final ApOrderDtlDomainService apOrderDtlDomainService;
    @Lazy
    @Autowired
    private FinApPayVerApplyService finApPayVerApplyService;

    private final PayOrderDomainService payOrderDomainService;

    private final PayOrderDtlDomainService payOrderDtlDomainService;

    private final PayTypeDomainService payTypeDomainService;

    private final ApOrderToPayDomainService apOrderToPayDomainService;

    private final ApOrderDomainService apOrderDomainService;

    private final ApVerRecDomainService apVerRecDomainService;

    private final WorkflowRpcService workflowRpcService;
    private final PayOrderDtlRepoProc payOrderDtlRepoProc;
    private final PayOrderDtlRepo payOrderDtlRepo;

    private final PayOrderDetailRepoProc payOrderDetailRepoProc;
    private final FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private  ApOrderService apOrderService;
    @Autowired
    private FinApPayVerApplyRepoProc finApPayVerApplyRepoProc;

    @SysCodeProc
    @Override
    public PagingVO<PayOrderVO> page(PayOrderPageParam param) {
        PagingVO<PayOrderDTO> page = payOrderDomainService.page(param);
        PagingVO<PayOrderVO> payOrderVOPagingVO = PayOrderConvert.INSTANCE.convertPage(page);
        if(payOrderVOPagingVO.isEmpty()){
            return payOrderVOPagingVO;
        }
        final List<Long> masIds = payOrderVOPagingVO.getRecords().stream().map(PayOrderVO::getId).collect(Collectors.toList());
        final List<PayOrderDtlDTO> payOrderDtlDTOS = payOrderDtlRepoProc.queryByMasId(masIds);
        final Map<Long, List<PayOrderDtlDTO>> payorderDtlDTOMap= payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId, Collectors.toList()));
        List<String> relevanceOuCodeList = payOrderVOPagingVO.getRecords().stream().map(PayOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);

        payOrderVOPagingVO.getRecords().stream().forEach(v->{
            BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
            BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
            BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
            final List<PayOrderDtlDTO> payOrderDtlDTOS1 = payorderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty(payOrderDtlDTOS1)) {
                for (PayOrderDtlDTO payOrderDtlDTO : payOrderDtlDTOS1) {
                    if(payOrderDtlDTO.getVerAmt()!=null){
                        verAmt = verAmt.add(payOrderDtlDTO.getVerAmt());
                    }
                    if(payOrderDtlDTO.getApplyVerAmTing()!=null){
                        verAmting = verAmting.add(payOrderDtlDTO.getApplyVerAmTing());
                    }
                    if(payOrderDtlDTO.getUnVerAmt()!=null){
                        unVerAmt = unVerAmt.add(payOrderDtlDTO.getUnVerAmt());
                    }
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }

            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }

        });
        flexFieldUtilService.handleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.PAY_ORDER,payOrderVOPagingVO.getRecords());
        return payOrderVOPagingVO;
    }
    @SysCodeProc
    @Override
    public PagingVO<PayOrderVO> writeoffPage(PayOrderPageParam param) {
        PagingVO<PayOrderDTO> page = payOrderDomainService.writeoffPage(param);
        PagingVO<PayOrderVO> payOrderVOPagingVO = PayOrderConvert.INSTANCE.convertPage(page);
        if(payOrderVOPagingVO.isEmpty()){
            return payOrderVOPagingVO;
        }
        final List<Long> masIds = payOrderVOPagingVO.getRecords().stream().map(PayOrderVO::getId).collect(Collectors.toList());
        final List<PayOrderDtlDTO> payOrderDtlDTOS = payOrderDtlRepoProc.queryByMasId(masIds);
        final Map<Long, List<PayOrderDtlDTO>> payorderDtlDTOMap= payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId, Collectors.toList()));

        List<String> relevanceOuCodeList = payOrderVOPagingVO.getRecords().stream().map(PayOrderVO::getRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeList);

        payOrderVOPagingVO.getRecords().stream().forEach(v->{
            BigDecimal verAmt = BigDecimal.ZERO;//已核销金额
            BigDecimal verAmting = BigDecimal.ZERO;//核销中金额
            BigDecimal unVerAmt = BigDecimal.ZERO;//未核销金额
            final List<PayOrderDtlDTO> payOrderDtlDTOS1 = payorderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty(payOrderDtlDTOS1)) {
                for (PayOrderDtlDTO payOrderDtlDTO : payOrderDtlDTOS1) {
                    verAmt = verAmt.add(payOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(payOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(payOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }

            OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(v.getRelevanceOuCode());
            if (Objects.nonNull(ouRpcSimpleDTO)){
                v.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
            }

        });
        return payOrderVOPagingVO;
    }

    @SysCodeProc
    @Override
    public PayOrderVO queryById(Long id) {
        PayOrderDTO payOrderDTO = payOrderDomainService.queryById(id, false);
        PayOrderVO payOrderVO = PayOrderConvert.INSTANCE.dtoToVo(payOrderDTO);

        Map<String, OrgOuRpcSimpleDTO> ouMap = StringUtils.isBlank(payOrderVO.getRelevanceOuCode()) ? new HashMap<>() : rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(payOrderVO.getRelevanceOuCode()));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(payOrderVO.getRelevanceOuCode());
        if (Objects.nonNull(ouRpcSimpleDTO)){
            payOrderVO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }

        flexFieldUtilService.handleSingleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.PAY_ORDER,payOrderVO);
        return payOrderVO;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<List<Long>> deleteByIds(List<Long> ids) {
        List<Long> deleteByIds = payOrderDomainService.deleteByIds(ids);
        //删除中间表应付单数据
        apOrderToPayDomainService.deleteByPayIds(ids);
        return ApiResult.ok(deleteByIds);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<Long> save(PayOrderSaveParam param) {
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertParam(param);
        //如果修改的是应付单来源
        if (param.getId() != null) {
            deleteBeforePushDate(param);
        }
        Long id = payOrderDomainService.save(payOrder);
        checkPushedAmt(payOrder);
        return ApiResult.ok(id);
    }

    private void checkPushedAmt(PayOrder payOrder) {
        String createMode = payOrder.getCreateMode();
        //仅应付单生成的需要校验
        if (!"AP".equals(createMode)) {
            return;
        }
        List<PayOrderDtl> apOrderDTOS = payOrder.getDtlList();
        List<Long> apOrderIds =
                apOrderDTOS.stream().filter(e -> e.getSourceId() != null).map(PayOrderDtl::getSourceId).distinct().collect(Collectors.toList());
        List<PayOrderDtlDTO> payOrderDtlDTOS =
                payOrderDtlDomainService.queryBySourceIdList(apOrderIds);
        Map<Long, List<PayOrderDtlDTO>> groupedPayOrderDtlDTOS =
                payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getSourceId));
        HashMap<Long, BigDecimal> BigDecimalAmtMap = new HashMap<>();
        //计算每个应付单的关联草稿状态付款单金额
        for (Map.Entry<Long, List<PayOrderDtlDTO>> entry : groupedPayOrderDtlDTOS.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().map(PayOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO,
                    BigDecimal::add);
            BigDecimalAmtMap.put(entry.getKey(), reduce);
        }

        apOrderDTOS.forEach(order -> {
            if (BigDecimalAmtMap.get(order.getId()) != null) {
                //减去核销金额
                BigDecimal payAmt =
                        order.getTotalAmt().subtract(BigDecimalAmtMap.get(order.getId())).subtract(order.getVerAmt());
                //对比获取到的付款单金额和应付单剩余可推金额  如果此刻推送的金额大于可推金额则校验
                if (payAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "应付单号:" + order.getSourceNo() + "," +
                            "可推金额不足,请重新选择!");
                }
            }
        });
    }

    private void deleteBeforePushDate(PayOrderSaveParam param) {
        if (param.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode())) {
            //修改数据之前需要检验金额是否满足修改条件
            checkApOrderMoney(param);
            //删除之前已推数据
            apOrderToPayDomainService.deleteByPayId(param.getId());
            //新增上之前关联数据
            saveApOrderToPay(param);
        }
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Long> submit(PayOrderSaveParam param) {
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertParam(param);
        //如果修改的是应付单来源
        if (param.getId() != null) {
            deleteBefore(param);
        }
        checkPushedAmt(payOrder);
        Long id = payOrderDomainService.submit(payOrder);
        //提交后生成审批中状态应付付款核销单
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionTemplate.execute(trans -> {
            try {
                processAfterSubmit(payOrder);
            } catch (Exception exception) {
                trans.setRollbackOnly();
            }
            return null;
        });

        // 启动工作流
        if (payOrder.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(payOrder.getProcInstStatus())) {
            // 启动流程
            String procInstName = "付款单审核-" + payOrder.getPayOrderNo();
            String procKey = WorkFlowDefKey.FIN_PAY_ORDER.name();
            ProcessInfo processInfo = workflowRpcService.startProcess(procKey, procInstName, id.toString(), new HashMap<>());
            payOrderDomainService.updateWorkInfo(processInfo, id);
        }
        return ApiResult.ok(id);
    }

    private void processAfterSubmit(PayOrder payOrder) {
        log.info("准备生成核销单，参数{}", JSONUtil.toJsonStr(payOrder));
        //如果已经生成过核销申请单，则跳过
        Long payOrderId = payOrder.getId();
        if (payOrderId != null) {
            PayOrderDO payOrderDO =
                    payOrderRepo.findById(payOrderId).orElseThrow(new com.elitescloud.boot.exception.BusinessException(
                            "提交的单据不存在" + ":" + payOrderId));
            if ("1".equals(payOrderDO.getVerApplyFlag())) {
                log.info("该单据已经生成过核销申请单:{}", payOrderId);
                return;
            }
        }
        List<PayOrderDtl> dtlList = payOrder.getDtlList();
        if (CollUtil.isEmpty(dtlList)) {
            throw new com.elitescloud.boot.exception.BusinessException("付款单明细不存在");
        }
        List<Long> apOrderIds =
                dtlList.stream().filter(e -> e.getSourceId() != null).distinct().map(PayOrderDtl::getSourceId).collect(Collectors.toList());

        List<ApOrderVO> apOrderVOList = apOrderService.getBatch(apOrderIds);
       /* Map<Object, List<ApOrderDtlDO>> apOrderDtlMap =
                apOrderDtlRepo.findAllByMasIdIn(apOrderIds).stream().collect(Collectors.groupingBy
                (ApOrderDtlDO::getMasId));*/

        BigDecimal totalAmt =
                payOrderDtlRepoProc.queryByMasId(payOrder.getId()).stream().map(PayOrderDtlDTO::getTotalAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<Long, BigDecimal> payAmtMap =
                payOrderDtlRepoProc.queryByMasId(payOrder.getId()).stream().collect(Collectors.toMap(PayOrderDtlDTO::getSourceId,
                        PayOrderDtlDTO::getRealPayAmt));
        apOrderVOList.forEach(
                apOrderVO -> {
                    if (payAmtMap.containsKey(apOrderVO.getId())) {
                        apOrderVO.setVerAmt(payAmtMap.get(apOrderVO.getId()));
                    }
                }
        );
        payOrder.setVerAmt(totalAmt);
        FinApPayVerApplySaveDTO save = new FinApPayVerApplySaveDTO();
        save.setApHeadSaveList(FinApPayVerApplyApHeadConvert.INSTANCE.VO2DOBatchApOrder(apOrderVOList));
        save.setPayHeadSaveList(FinApPayVerApplyApHeadConvert.INSTANCE.VO2DOBatchPayOrder(List.of(payOrder)));
        save.setHeadFlag(true);
        log.info("生成应付付款核销单,参数save:{}", JSONUtil.toJsonStr(save));
        Long id = finApPayVerApplyService.writeOffCreate(save);
        finApPayVerApplyRepoProc.updateStatusById(id);
        //将付款单对应的标识设置为1,如果工作流失败重新提交将不会再重复生成核销申请单
        payOrderRepoProc.updateVerApplyFlag(payOrder.getId(), "1");
        //回写应付单,收款单明细
       /* FinApPayVerApplyVO detail = finApPayVerApplyService.detail(id);

        List<Long> apDIds =
                detail.getApList().stream().filter(e -> e.getApDId() != null).map(FinApPayVerApplyApVO::getApDId)
                .distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> apDIdVerAmtMap =
                detail.getApList().stream().filter(e -> e.getApDId() != null).collect(Collectors.toMap
                (FinApPayVerApplyApVO::getApDId,
                        FinApPayVerApplyApVO::getVerAmt));

        List<Long> payDIds =
                detail.getPayList().stream().filter(e -> e.getPayDId() != null).map(FinApPayVerApplyPayVO::getPayDId)
                .distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> payDIdVerAmtMap =
                detail.getPayList().stream().filter(e -> e.getPayDId() != null).collect(Collectors.toMap
                (FinApPayVerApplyPayVO::getPayDId,
                        FinApPayVerApplyPayVO::getVerAmt));
        log.info("准备回写应付单明细,apDIdVerAmtMap:{},apDIds:{}", JSONUtil.toJsonStr(apDIdVerAmtMap),
                JSONUtil.toJsonStr(apDIds));
        apOrderDtlDomainService.updateVerAmt(apDIdVerAmtMap, apDIds);
        log.info("准备回写付款单明细,payDIdVerAmtMap:{},payDIds:{}", JSONUtil.toJsonStr(payDIdVerAmtMap),
                JSONUtil.toJsonStr(payDIds));
        payOrderDtlDomainService.updateVerAmt(payDIdVerAmtMap, payDIds);*/
    }

    private void deleteBefore(PayOrderSaveParam param) {
        if (param.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode())) {
            //修改数据之前需要检验金额是否满足修改条件
            checkApOrderMoney(param);
            //删除之前已推数据
            apOrderToPayDomainService.deleteByPayId(param.getId());
            //新增上之前关联数据
            saveApOrderToPay(param);
        }
    }

    @Override
    public ApiResult<PayOrderVO> defaultValue() {
        PayTypeDTO payTypeDTO = payTypeDomainService.defaultValue();
        PayOrderVO payOrderVO = PayTypeConvert.INSTANCE.typeToOrder(payTypeDTO);
        if (payOrderVO == null) {
            return ApiResult.ok(new PayOrderVO());
        }
        return ApiResult.ok(payOrderVO);
    }

    @SysCodeProc
    @Override
    public PayOrderVO queryDetailsById(Long id) {
        PayOrderDTO payOrderDTO = payOrderDomainService.queryById(id, true);
        PayOrderVO payOrderVO = PayOrderConvert.INSTANCE.dtoToVo(payOrderDTO);
        Map<String, OrgOuRpcSimpleDTO> ouMap = StringUtils.isBlank(payOrderVO.getRelevanceOuCode()) ? new HashMap<>() : rmiOrgOuRpcServiceService.findBaseOuMapByCodes(Collections.singletonList(payOrderVO.getRelevanceOuCode()));
        OrgOuRpcSimpleDTO ouRpcSimpleDTO = ouMap.get(payOrderVO.getRelevanceOuCode());
        if (Objects.nonNull(ouRpcSimpleDTO)){
            payOrderVO.setRelevanceOuName(ouRpcSimpleDTO.getOuName());
        }
        flexFieldUtilService.handleSingleFlexFieldShowNameForVO(FinFlexFieldCodeConstant.PAY_ORDER,payOrderVO);
        return payOrderVO;
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult<String> saveByApOrder(ApOrderToPaySaveParam param) {
        List<ApOrderDTO> apOrderDTOS = apOrderDomainService.queryByIds(param.getIds());
        List<String> ouCode = new ArrayList<>();
        List<String> supCode = new ArrayList<>();
        List<String> curr = new ArrayList<>();
        List<String> apType = new ArrayList<>();
        //校验规则
        List<String> ouCodeList =
                apOrderDomainService.queryByIds(param.getIds()).stream().map(e -> e.getOuCode()).distinct().collect(Collectors.toList());
        OrgOuComRpcParam param1 = new OrgOuComRpcParam();
        param1.setOuCodeList(ouCodeList);
        List<OrgOuComRpcDTO> ouDtoByParam = rmiOrgOuRpcServiceService.findOuDtoByParam(param1);
        for (OrgOuComRpcDTO orgOuRpcDTO : ouDtoByParam) {
            if ("OUTER".equals(orgOuRpcDTO.getOuType2())) {
                throw new com.elitescloud.boot.exception.BusinessException("应付单的公司关联的客户类型为外部客户,不能下推生成付款单");
            }
        }
        apOrderDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "只能选择审核通过的应付单据!");
            }
            if (dto.getTotalAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "只能选择应付单金额不为0的单据!");
            }
            ouCode.add(dto.getOuCode());
            supCode.add(dto.getSuppCode());
            curr.add(dto.getCurrCode());
            apType.add(dto.getApTypeCode());
        });
        //校验是否同一家公司
        List<String> ou = ouCode.stream().distinct().collect(Collectors.toList());
        if (ou.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "请选择同一家公司的数据!");
        }
        //校验是否同一供应商
        List<String> sup = supCode.stream().distinct().collect(Collectors.toList());
        if (sup.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "请选择同一家供应商的数据!");
        }
        //校验是否同一币种
        List<String> currCode = curr.stream().distinct().collect(Collectors.toList());
        if (currCode.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "请选择同一币种的数据!");
        }
        //校验是否同一结算类型
        List<String> apTypeCode = apType.stream().distinct().collect(Collectors.toList());
        if (apTypeCode.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "请选择同一应付单类型的数据!");
        }

        List<PayOrderDtlDTO> payOrderDtlDTOS = payOrderDtlDomainService.queryBySourceIdList(param.getIds());
        Map<Long, List<PayOrderDtlDTO>> groupedPayOrderDtlDTOS =
                payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getSourceId));
        log.info("关联的草稿付款单:{}", JSONUtil.toJsonStr(groupedPayOrderDtlDTOS));
        HashMap<Long, BigDecimal> BigDecimalAmtMap = new HashMap<>();
        //计算每个应付单的关联草稿状态付款单金额
        for (Map.Entry<Long, List<PayOrderDtlDTO>> entry : groupedPayOrderDtlDTOS.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().map(PayOrderDtlDTO::getTotalAmt).reduce(BigDecimal.ZERO,
                    BigDecimal::add);
            BigDecimalAmtMap.put(entry.getKey(), reduce);
        }
        log.info("关联的草稿付款单金额汇总:{}", JSONUtil.toJsonStr(BigDecimalAmtMap));

        List<Long> apOrderIds = apOrderDTOS.stream().map(ApOrderDTO::getId).distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> apOrderUnVerAmtMap =
                apOrderDtlRepo.findAllByMasIdIn(apOrderIds).stream().collect(Collectors.groupingBy(ApOrderDtlDO::getMasId,
                        Collectors.reducing(BigDecimal.ZERO, ApOrderDtlDO::getUnVerAmt, BigDecimal::add)));
        apOrderDTOS.forEach(
                dto -> {
                    if (apOrderUnVerAmtMap.containsKey(dto.getId())) {
                        dto.setUnVerAmt(apOrderUnVerAmtMap.get(dto.getId()));
                    }
                }
        );
        /*
        //根据应付单ID查询中间表数据
        Map<Long, List<ApOrderToPayDTO>> apOrderToPayMap = apOrderToPayDomainService.queryByApId(param.getIds())
        .stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));

        HashMap<Long, BigDecimal> BigDecimalMap = new HashMap<>();
        //计算每个应付单的已退金额总和
        for (Map.Entry<Long, List<ApOrderToPayDTO>> entry : apOrderToPayMap.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().map(ApOrderToPayDTO::getPayAmt).reduce(BigDecimal.ZERO,
            BigDecimal::add);
            BigDecimalMap.put(entry.getKey(), reduce);
        }*/

        // 可推付款单金额（剩余金额）=含税金额-（应付单列表已核销金额+已推付款单金额(未核销的付款单的金额)）
        //如果有推送记录得，计算可推金额放入totalAmt
        apOrderDTOS.forEach(order -> {
                //未减去核销金额-关联草稿状态金额
            BigDecimal payAmt = order.getUnVerAmt().subtract(BigDecimalAmtMap.getOrDefault(order.getId(),
                    BigDecimal.ZERO));

            //     order.getTotalAmt().subtract(BigDecimalAmtMap.get(order.getId())).subtract(order.getVerAmt());
                //对比获取到的付款单金额和应付单剩余可推金额  如果此刻推送的金额大于可推金额则校验
                if (payAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "应付单号:" + order.getApOrderNo() + ",可推金额不足,请重新选择!");
                }
                //设置可推付款金额
                //应付单下推生成付款单时默认带出来未核销的金额-关联的草稿付款单的金额
                log.info("付款单:{},总金额:{},已核销金额:{},关联的草稿付款单金额:{},可推金额:{}", order.getApOrderNo(),
                        order.getTotalAmt(), order.getVerAmt(), BigDecimalAmtMap.get(order.getId()), payAmt);
                order.setTotalAmt(payAmt);

        });


        //如果没有推送记录得直接取当前金额
        PayOrder payOrder = new PayOrder();
        getPayOrder(payOrder, param, apOrderDTOS);
        List<PayOrderDtl> dtl = getDtl(apOrderDTOS, param);
        payOrder.setDtlList(dtl);
        payOrder.setPayTypeCode("AP");
        payOrder.setPayTypeName("标准付款");
        payOrder.setPayTypeId(getApTypeIdByCode("AP"));
        Long id = payOrderDomainService.save(payOrder);

        return ApiResult.ok(id.toString());
    }

    private Long getApTypeIdByCode(String code) {
        if (StrUtil.isBlank(code)) {
            return null;
        }
        List<PayTypeVO> payTypeVOList = payTypeService.findAll().computeData();
        Optional<PayTypeVO> first = payTypeVOList.stream().filter(e -> e.getPayTypeCode().equals(code)).findFirst();
        return first.map(PayTypeVO::getId).orElse(null);
    }

    /**
     * 查询应付单类型的配置规则
     *
     * @param sourceDoc       来源单据
     * @param sourceDocType   来源单据类型
     * @param sourceDocStatus 来源单据状态
     * @param ouId            公司ID
     * @param ouCode          公司编码
     * @return
     */
    private ApTypeDTO selectApType(String sourceDoc, String sourceDocType, String sourceDocStatus, Long ouId,
                                   String ouCode) {

        //1.来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则
        ApTypePageParam apTypeParam = new ApTypePageParam();
        /*apTypeParam.setSourceDoc(sourceDoc);
        apTypeParam.setSourceDocType(sourceDocType);
        apTypeParam.setSourceDocStatus(sourceDocStatus);*/
        //传一个默认编码
        apTypeParam.setApTypeCode(FinConstant.AP_TYPE_CODE_YFD05_SYS);
        List<ApTypeDTO> apTypeDTOList = apTypeDomainService.selectMatchByParam(apTypeParam);
        if (CollectionUtil.isEmpty(apTypeDTOList)) {
            log.error("未匹配到应付单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType, sourceDocStatus);
            throw new com.elitescloud.boot.exception.BusinessException("未匹配到应付单类型的配置规则");
        }
        if (CollectionUtil.isNotEmpty(apTypeDTOList) && apTypeDTOList.size() > 1) {
            log.error("匹配到多条应付单类型的配置规则, 来源单据: {},来源单据类型: {},来源单据状态:{}",
                    sourceDoc, sourceDocType, sourceDocStatus);
            throw new com.elitescloud.boot.exception.BusinessException("匹配到多条应付单类型的配置规则");
        }

        //2.注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司
        Long apTypeId = apTypeDTOList.get(0).getId();
        List<ApTypeOuDTO> apTypeOuDTOList = apTypeOuDomainService.queryByApTypeId(apTypeId);
        if (CollectionUtil.isEmpty(apTypeOuDTOList)) {
            log.error("应付单的分配公司为空, 应付单编码: {}", apTypeDTOList.get(0).getApTypeCode());
            throw new com.elitescloud.boot.exception.BusinessException("应付单的分配公司为空");
        }
        List<String> apTypeOuCodeList =
                apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> apTypeOuIdList =
                apTypeOuDTOList.stream().map(ApTypeOuDTO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());

        if (!apTypeOuIdList.contains(ouId) && !apTypeOuCodeList.contains(ouCode)) {
            log.error("应付单未分配该公司, 应付单编码: {},公司ID: {},公司编码: {}", apTypeDTOList.get(0).getApTypeCode(), ouId, ouCode);
            throw new com.elitescloud.boot.exception.BusinessException("应付单未分配该公司");
        }

        return apTypeDTOList.get(0);
    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void approved(Long id) {
        //获取来源单据为AP的付款单ID
        PayOrderDTO payOrderDTO = payOrderDomainService.queryById(id, false);
        if (payOrderDTO.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode()) && !payOrderDTO.getApFlag()) {
            //获取对应付款信息行数据
            List<PayOrderDtlDTO> payOrderDtlDTOS = payOrderDtlDomainService.queryByMasId(CollUtil.newArrayList(payOrderDTO.getId()));
            List<Long> apIds = payOrderDtlDTOS.stream().map(PayOrderDtlDTO::getSourceId).collect(Collectors.toList());
            List<ApOrderDTO> apOrderDTOS = apOrderDomainService.queryByIds(apIds);
            ApOrderDTO apOrderDTO = apOrderDTOS.get(0);
            Map<Long, ApOrderDTO> apOrderDTOMap = apOrderDTOS.stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
            List<ApVerRecDtl> apVerRecDtls = new ArrayList<>();
            //组装付款单对应的核销明细
            List<ApVerRecDtl> payVerDtls = payOrderDtlDTOS.stream().map(t -> {
                ApVerRecDtl apVerRecDtl = new ApVerRecDtl();
                apVerRecDtl.setOuCode(apOrderDTO.getOuCode());
                apVerRecDtl.setOuName(apOrderDTO.getOuName());
                apVerRecDtl.setOuId(apOrderDTO.getOuId());
                apVerRecDtl.setSuppCode(apOrderDTO.getSuppCode());
                apVerRecDtl.setSuppName(apOrderDTO.getSuppName());
                apVerRecDtl.setSuppId(apOrderDTO.getSuppId());
                apVerRecDtl.setCurrCode(apOrderDTO.getCurrCode());
                apVerRecDtl.setCurrName(apOrderDTO.getCurrName());
                apVerRecDtl.setAmt(t.getRealPayAmt());
                apVerRecDtl.setOrderId(t.getMasId());
                apVerRecDtl.setOrderNo(payOrderDTO.getPayOrderNo());
                apVerRecDtl.setOrderType(FinConstant.PAY);
                apVerRecDtl.setOrderName("付款单");
                apVerRecDtl.setVerDate(LocalDateTime.now());
                apVerRecDtl.setBuDate(payOrderDTO.getBuDate());
                apVerRecDtl.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_AUTO.getValueCode());
                return apVerRecDtl;
            }).collect(Collectors.toList());
            apVerRecDtls.addAll(payVerDtls);
            //组装应付单对应的核销明细
            List<ApVerRecDtl> apVerDtls = payOrderDtlDTOS.stream().map(t -> {
                ApVerRecDtl apVerRecDtl = new ApVerRecDtl();
                apVerRecDtl.setOuCode(apOrderDTO.getOuCode());
                apVerRecDtl.setOuName(apOrderDTO.getOuName());
                apVerRecDtl.setOuId(apOrderDTO.getOuId());
                apVerRecDtl.setSuppCode(apOrderDTO.getSuppCode());
                apVerRecDtl.setSuppName(apOrderDTO.getSuppName());
                apVerRecDtl.setSuppId(apOrderDTO.getSuppId());
                apVerRecDtl.setCurrCode(apOrderDTO.getCurrCode());
                apVerRecDtl.setCurrName(apOrderDTO.getCurrName());
                apVerRecDtl.setAmt(t.getRealPayAmt());
                apVerRecDtl.setOrderId(t.getSourceId());
                apVerRecDtl.setOrderNo(apOrderDTOMap.get(t.getSourceId()).getApOrderNo());
                apVerRecDtl.setOrderType(FinConstant.AP);
                apVerRecDtl.setOrderName("应付单");
                apVerRecDtl.setVerDate(LocalDateTime.now());
                apVerRecDtl.setBuDate(apOrderDTO.getBuDate());
                apVerRecDtl.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_AUTO.getValueCode());
                return apVerRecDtl;
            }).collect(Collectors.toList());
            apVerRecDtls.addAll(apVerDtls);
            apVerRecDomainService.save(apVerRecDtls);
            apVerRecDtls.stream().forEach(t -> {
                if (t.getOrderType().equals(FinConstant.AP)) {
                    apOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
                } else if (t.getOrderType().equals(FinConstant.PAY)) {
                    payOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
                }
            });
        }
    }

    private List<PayOrderDtl> getDtl(List<ApOrderDTO> apOrderDTOS, ApOrderToPaySaveParam param) {
        return apOrderDTOS.stream().map(dto -> {
            PayOrderDtl dtl = new PayOrderDtl();
            dtl.setSourceId(dto.getId());
            dtl.setSourceNo(dto.getApOrderNo());
            dtl.setPayAccount(param.getPayAccount());
            dtl.setPayBank(param.getPayBank());
            dtl.setPayType(param.getPayType());
            dtl.setRecBank(param.getRecBank());
            dtl.setRecAccount(param.getRecAccount());
            dtl.setTotalAmt(dto.getTotalAmt());
            return dtl;
        }).collect(Collectors.toList());
    }

    private void getPayOrder(PayOrder payOrder, ApOrderToPaySaveParam param, List<ApOrderDTO> apOrderDTOS) {
        //状态
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        //应付单
        payOrder.setCreateMode(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode());
        //备注
        payOrder.setRemark(param.getRemark());
        ApOrderDTO apOrderDTO = apOrderDTOS.get(0);
        payOrder.setInOutCust(apOrderDTO.getInOutCust());
        payOrder.setRelevanceOuCode(apOrderDTO.getRelevanceOuCode());

        payOrder.setOuId(apOrderDTO.getOuId());
        payOrder.setOuCode(apOrderDTO.getOuCode());
        payOrder.setOuName(apOrderDTO.getOuName());
        payOrder.setSuppCode(apOrderDTO.getSuppCode());
        payOrder.setSuppName(apOrderDTO.getSuppName());
        payOrder.setSuppId(apOrderDTO.getSuppId());
        payOrder.setApTypeId(apOrderDTO.getApTypeId());
        payOrder.setApTypeName(apOrderDTO.getApTypeName());
        payOrder.setApTypeCode(apOrderDTO.getApTypeCode());
        payOrder.setApFlag(false);
        payOrder.setInitFlag(false);
        //本位币
        payOrder.setLocalCurrCode(apOrderDTO.getLocalCurrCode());
        payOrder.setLocalCurrName(apOrderDTO.getLocalCurrName());
        payOrder.setCurrCode(apOrderDTO.getCurrCode());
        payOrder.setCurrName(apOrderDTO.getCurrName());
        //税率
        payOrder.setExchangeRate(apOrderDTO.getExchangeRate());
        payOrder.setBuDate(LocalDateTime.now());
        payOrder.setApDate(LocalDateTime.now());
    }

    /**
     * 新增应付单和付款单关系
     *
     * @param param 新增参数
     */
    private void saveApOrderToPay(PayOrderSaveParam param) {
        List<ApOrderToPay> collect = param.getPayOrderDtlSaveParams().stream().map(dtl -> {
            ApOrderToPay apOrderToPay = new ApOrderToPay();
            //修改时获取的付款单单头ID
            apOrderToPay.setPayOrderId(param.getId());
            //明细信息行返回的数据 应付单ID和金额
            apOrderToPay.setApOrderId(dtl.getSourceId());
            apOrderToPay.setPayAmt(dtl.getTotalAmt());
            apOrderToPay.setSourceType(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode());
            return apOrderToPay;
        }).collect(Collectors.toList());
        apOrderToPayDomainService.save(collect);
    }

    /**
     * 校验可推金额
     *
     * @param param 生成付款单参数
     */
    private void checkApOrderMoney(PayOrderSaveParam param) {
        //获取到修改的明细数据
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = param.getPayOrderDtlSaveParams();
        //获取到应付单ID
        List<Long> apOrderId = payOrderDtlSaveParams.stream().map(PayOrderDtlSaveParam::getSourceId).collect(Collectors.toList());
        //查询应付单数据
        List<ApOrderDTO> orderDTOS = apOrderDomainService.queryByIds(apOrderId);
        Map<Long, ApOrderDTO> apMap = orderDTOS.stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
        //根据应付单ID查询中间表数据
        Map<Long, List<ApOrderToPayDTO>> apOrderToPayMap = apOrderToPayDomainService.queryByApId(apOrderId).stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));

        HashMap<Long, BigDecimal> BigDecimalMap = new HashMap<>();
        //计算每个应付单的已退金额总和
        for (Map.Entry<Long, List<ApOrderToPayDTO>> entry : apOrderToPayMap.entrySet()) {
            //计算时过滤掉修改数据之前得金额
            BigDecimal reduce = entry.getValue().stream().filter(order -> !order.getPayOrderId().equals(param.getId())).map(ApOrderToPayDTO::getPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimalMap.put(entry.getKey(), reduce);
        }

        // 可推付款单金额（剩余金额）=含税金额-（应付单列表已核销金额+已推付款单金额(未核销的付款单的金额)）
        payOrderDtlSaveParams.forEach(order -> {
            if (BigDecimalMap.get(order.getSourceId()) != null) {
                payAmtCount(apMap, BigDecimalMap, order);

            }
        });
    }

    private static void payAmtCount(Map<Long, ApOrderDTO> apMap, HashMap<Long, BigDecimal> BigDecimalMap, PayOrderDtlSaveParam order) {
        if (apMap.get(order.getSourceId()) != null) {
            //获取应付单金额
            BigDecimal apOrderAmount = apMap.get(order.getSourceId()).getTotalAmt();
            //应付单的核销金额
            BigDecimal verAmount = apMap.get(order.getSourceId()).getVerAmt();
            //计算可推金额，如果修改值大于可推金额，则报错
            BigDecimal payAmt = apOrderAmount.subtract(verAmount).subtract(BigDecimalMap.get(order.getSourceId()));
            //对比获取到的付款单金额和应付单剩余可推金额  如果此刻推送的金额大于可推金额则校验
            if (order.getTotalAmt().compareTo(payAmt) > 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "应付单号:" + order.getSourceNo() + ",可推金额不足,请重新选择!");
            }
        }
    }

    private Map<Long, String> getSuppType2(List<Long> suppIds) {
        List<PurSuppBaseDTO> bySuppIdBatch = rmiPurRpcService.findBySuppIdBatch(suppIds);
        if (CollUtil.isEmpty(bySuppIdBatch)) {
            throw new com.elitescloud.boot.exception.BusinessException("单据对应供应商信息不存在");
        }
        Map<Long, String> idAndSupptype2Map = bySuppIdBatch.stream().collect(Collectors.toMap(PurSuppBaseDTO::getId,
                PurSuppBaseDTO::getSuppType2));
        log.info("供应商idAndSupptype2Map字典:{}", JSONUtil.toJsonStr(idAndSupptype2Map));
        return idAndSupptype2Map;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        List<PayOrderDO>  payOrderDOS = payOrderDomainService.queryByIds(ids);

        //增加校验，如果付款单的供应商类型=系统内，且已经生成关联的收款单，不允许取消审批
        List<Long> suppIds = payOrderDOS.stream().map(PayOrderDO::getSuppId).distinct().collect(Collectors.toList());
        List<String> payOrderNos =
                payOrderDOS.stream().map(PayOrderDO::getPayOrderNo).distinct().collect(Collectors.toList());
        Map<Long, String> suppType2Map = getSuppType2(suppIds);
        Map<String, List<RecOrderDO>> sourceNoDataMap =
                recOrderRepoProc.findBySourceNoList(payOrderNos).stream().collect(Collectors.groupingBy(RecOrderDO::getSourceNo));
        log.info("参数,payOrderDOS:{},suppType2Map:{},sourceNoDataMap:{}", JSONUtil.toJsonStr(payOrderDOS),
                JSONUtil.toJsonStr(suppType2Map),
                JSONUtil.toJsonStr(sourceNoDataMap));
        List<String> errorPayOrderNoList = new ArrayList<>();
        for (PayOrderDO payOrderDO : payOrderDOS) {
            Long suppId = payOrderDO.getSuppId();
            String suppType2 = suppType2Map.get(suppId);
            List<RecOrderDO> data = sourceNoDataMap.get(payOrderDO.getPayOrderNo());
            if ("INNER".equals(suppType2)) {
                if (CollUtil.isNotEmpty(data)) {
                    errorPayOrderNoList.add(payOrderDO.getPayOrderNo());
                }
            }
        }
        if (CollUtil.isNotEmpty(errorPayOrderNoList)) {
            String jsonStr = String.join(",", errorPayOrderNoList);
            throw new com.elitescloud.boot.exception.BusinessException("单据已经生成关联的收款单，不允许取消审批,单号:" + jsonStr);
        }


        //检查
        checkCancelDoc(payOrderDOS);
        // 重置状态
        payOrderDOS.forEach(payOrderDTO -> {

            payOrderDTO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            payOrderDTO.setProposedStatus(null);
            payOrderDTO.setProcInstId(null);
            payOrderDTO.setProcInstStatus(null);
        });
        payOrderDomainService.saveAll(payOrderDOS);
        for (Long id : ids) {
            //需要将提交后生成的审批中状态的应付付款核销单取消审批且删除
            List<Long> byPayId = finApPayVerApplyPayRepoProc.findByPayId(id);
            if(CollUtil.isEmpty(byPayId)){
                continue;
            }
            List<Long> idsHeader = finApPayVerApplyPayHeadRepoProc.findByPayId(byPayId);
            if(CollUtil.isEmpty(idsHeader)){
                continue;
            }
            log.info("开始删除应付付款核销单ids:{}", JSONUtil.toJsonStr(idsHeader));
            //过滤掉失效数据
            idsHeader =
                    finApPayVerApplyRepoProc.findAllByIds(ids).stream().map(BaseModel::getId).distinct().collect(Collectors.toList());
            log.info("取消审批,过滤后的付款核销单ids:{}", JSONUtil.toJsonStr(idsHeader));
            //回写应付单,收款单明细
            for (Long apPayVerApplyId : idsHeader) {
                FinApPayVerApplyVO detail = finApPayVerApplyService.writeOffDetail(apPayVerApplyId);
                log.info("核销申请单详情:{}", JSONUtil.toJsonStr(detail));
                List<FinApPayVerApplyApVO> apList = new ArrayList<>();
                for (FinApPayVerApplyApHeadVO apHeadVO : detail.getApHeadList()) {
                    apList.addAll(apHeadVO.getApList());
                }
                List<FinApPayVerApplyPayVO> payList = new ArrayList<>();
                for (FinApPayVerApplyPayHeadVO payHeadVO : detail.getPayHeadList()) {
                    payList.addAll(payHeadVO.getPayList());
                }

                List<Long> apDIds =
                        apList.stream().filter(e -> e.getApDId() != null).map(FinApPayVerApplyApVO::getApDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> apDIdVerAmtMap =
                        apList.stream().filter(e -> e.getApDId() != null).collect(Collectors.toMap(FinApPayVerApplyApVO::getApDId,
                                FinApPayVerApplyApVO::getVerAmt));

                List<Long> payDIds =
                        payList.stream().filter(e -> e.getPayDId() != null).map(FinApPayVerApplyPayVO::getPayDId).distinct().collect(Collectors.toList());
                Map<Long, BigDecimal> payDIdVerAmtMap =
                        payList.stream().filter(e -> e.getPayDId() != null).collect(Collectors.toMap(FinApPayVerApplyPayVO::getPayDId,
                                FinApPayVerApplyPayVO::getVerAmt));
                log.info("付款单取消审批,回写参数:apDIdVerAmtMap:{},apDIds:{},payDIdVerAmtMap:{},payDIds:{}",
                        JSONUtil.toJsonStr(apDIdVerAmtMap), apDIds, JSONUtil.toJsonStr(payDIdVerAmtMap), payDIds);
                if(MapUtil.isNotEmpty(apDIdVerAmtMap) && CollUtil.isNotEmpty(apDIds)){
                    apOrderDtlDomainService.resortVerAmt(apDIdVerAmtMap, apDIds);
                }
                if(MapUtil.isNotEmpty(payDIdVerAmtMap) && CollUtil.isNotEmpty(payDIds)){
                    payOrderDtlDomainService.resortVerAmt(payDIdVerAmtMap, payDIds);
                }

            }
            payOrderRepoProc.updateVerApplyFlag(id, "0");
            log.info("取消审批,将付款的核销申请单标识重新设置为0");
            if (CollUtil.isNotEmpty(idsHeader)) {
                finApPayVerApplyRepoProc.deleteByIds(idsHeader);
            }
            log.info("取消审批完成");
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = {RuntimeException.class, Exception.class})
    public ApiResult<Long> redPunch(Long id) {
        PayOrderDTO payOrderDTO = payOrderDomainService.queryById(id, false);
        //检查
        this.checkRedPunch(payOrderDTO);
        //红冲
        PayOrder payOrder = payOrderDomainService.redPunchCreate(id);
        PayOrderSaveParam param = PayOrderConvert.INSTANCE.convert(payOrder);
        return this.submit(param);
    }




    /**
     * 取消单据检查
     * @param payOrderDOS
     */
    void checkCancelDoc(List<PayOrderDO> payOrderDOS) {
        if (CollectionUtils.isEmpty(payOrderDOS)) {
            throw new com.elitescloud.boot.exception.BusinessException("单据不存在");
        }

        List<PayOrderDtlDTO> payOrderDtlDTOS = payOrderDtlRepoProc.queryByMasId(payOrderDOS.stream().map(PayOrderDO::getId).collect(Collectors.toList()));

        Map<Long, List<PayOrderDtlDTO>> listMap = payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId));

        payOrderDOS.forEach(payOrderDO -> {
            String perfix = "单号：" + payOrderDO.getPayOrderNo() + "-";
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(payOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()
                .equals(payOrderDO.getProposedStatus())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "拟定状态必须为草稿或拟定失败");
            }
//            if (!(BigDecimal.ZERO.compareTo(payOrderDO.getVerAmt()) == 0)) {
//                throw new com.elitescloud.boot.exception.BusinessException(perfix + "已核销金额必须为0");
//            }

            if(listMap.containsKey(payOrderDO.getId()) && CollUtil.isNotEmpty(listMap.get(payOrderDO.getId()))){
                // 根据明细，统计已核销金额大于0不能核销
                if(CollUtil.isNotEmpty(listMap.get(payOrderDO.getId()))){
                    BigDecimal verAmt = listMap.get(payOrderDO.getId()).stream().map(PayOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (!(BigDecimal.ZERO.compareTo(verAmt)==0)){
                        throw new com.elitescloud.boot.exception.BusinessException( perfix + "已核销金额必须为0");
                    }
                }
            }

            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(payOrderDO.getOrderState())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "单据状态必须为审核通过");
            }
            if (Boolean.TRUE.equals(payOrderDO.getRedState())){
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "单据已红冲");
            }
        });


    }

    /**
     * 红冲单据检查
     * @param payOrderDTO
     */
    void checkRedPunch(PayOrderDTO payOrderDTO) {
        if (Objects.isNull(payOrderDTO)){
            throw new com.elitescloud.boot.exception.BusinessException("单据不存在");
        }
        if (Boolean.TRUE.equals(payOrderDTO.getRedState())){
            throw new com.elitescloud.boot.exception.BusinessException("单据已红冲");
        }
        if (Objects.nonNull(payOrderDTO.getRedSourceNo())){
            throw new com.elitescloud.boot.exception.BusinessException("来源单据不可为红冲单据");
        }
//        if (!(BigDecimal.ZERO.compareTo(payOrderDTO.getVerAmt())==0)){
//            throw new com.elitescloud.boot.exception.BusinessException("已核销金额必须为0");
//        }
        // 根据明细，统计已核销金额大于0不能核销
        if(CollUtil.isNotEmpty(payOrderDTO.getPayOrderDtlVOList())){
            BigDecimal verAmt = payOrderDTO.getPayOrderDtlVOList().stream().map(PayOrderDtlDTO::getVerAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!(BigDecimal.ZERO.compareTo(verAmt)==0)){
                throw new com.elitescloud.boot.exception.BusinessException("已核销金额必须为0");
            }
        }

        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(payOrderDTO.getOrderState())){
            throw new com.elitescloud.boot.exception.BusinessException("单据状态必须为审核通过");
        }
        if (!payOrderDTO.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            throw new com.elitescloud.boot.exception.BusinessException("只允许红冲手工生成的收款单");
        }
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateMiddleVerAmt(Long payDId, BigDecimal amt) {
        PayOrderDtlDO detail = findDetail(payDId);
        doUpdateVerAmt(getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }
    private PayOrderDtlDO findDetail(Long recDId) {
        PayOrderDtlDO detail = payOrderDetailRepoProc.getPayOrderDetailAmt(recDId);
        Assert.notNull(detail, "未查询到收款单明细，明细ID:" + recDId);
        return detail;
    }

    private void doUpdateVerAmt(PayOrderAmtUpdateDTO update) {
        if (payOrderDetailRepoProc.updateExtVerAmt(update) == 0) {
            throw new com.elitescloud.boot.exception.BusinessException("更新核销金额失败，请稍后重试");
        }
    }

    private void repoUpdateVerAmt(PayOrderAmtUpdateDTO update) {
       /* if (payOrderDetailRepoProc.updateExtVerAmt(update) == 0) {
            throw new com.elitescloud.boot.exception.BusinessException("更新核销金额失败，请稍后重试");
        }*/

        if (payOrderDtlRepo.updateExtVerAmt(update.getPayDId(),update.getVersion(),update.getVerAmt(),update.getVerAmting(),update.getUnVerAmt()) == 0) {
            throw new com.elitescloud.boot.exception.BusinessException("更新核销金额失败，请稍后重试");
        }
    }

    @NotNull
    private PayOrderAmtUpdateDTO.PayOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, PayOrderDtlDO detail) {

        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);

        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new com.elitescloud.boot.exception.BusinessException("请核对金额数据");
        }

        return PayOrderAmtUpdateDTO.builder()
                .payDId(detail.getId())
                .unVerAmt(unVerAmt)
                .verAmting(verAmting)
                .verAmt(detail.getVerAmt())
                .version(detail.getAuditDataVersion());

    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateVerAmt(Long recDId, BigDecimal amt, String verType) {
        PayOrderDtlDO detail = findDetail(recDId);
        doUpdateVerAmt(getUpdateVerAmtBuilder(amt, detail, verType).build());
    }
    @NotNull
    private PayOrderAmtUpdateDTO.PayOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, PayOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr(detail);
        log.info("计算收款单核销金额,{}-{}", amt, infoStr);
        // 取消核销
        if (FinApPayVerificationDTO.VerType.CANCEL.equals(verType)) {

            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("取消核销,{}-{}-{}", infoStr, verAmt, unVerAmt);
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new com.elitescloud.boot.exception.BusinessException("请核对金额数据");
            }

            return PayOrderAmtUpdateDTO.builder()
                    .payDId(detail.getId())
                    .unVerAmt(unVerAmt)
                    .verAmting(detail.getApplyVerAmTing())
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());

        } else {

            BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
            BigDecimal verAmt = detail.getVerAmt().add(amt);
            log.info("核销通过,{}-{}-{}", infoStr, verAmting, verAmt);
            if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
                throw new com.elitescloud.boot.exception.BusinessException("请核对金额数据");
            }

            return PayOrderAmtUpdateDTO.builder()
                    .payDId(detail.getId())
                    .unVerAmt(detail.getUnVerAmt())
                    .verAmting(verAmting)
                    .verAmt(verAmt)
                    .version(detail.getAuditDataVersion());

        }

    }
    @Override
    public List<PayOrderDtlVO> listPayOrderDetail(FinPayOrderDetailQuery query) {
        return payOrderDetailRepoProc.listRecOrderDetail(query);
    }

}
