package com.elitesland.fin.application.web.arverrec;

import com.elitesland.fin.application.facade.param.arverrec.ArVerRecSaveParam;
import com.elitesland.fin.application.facade.vo.arverrec.ArVerRecDtlVO;
import com.elitesland.fin.application.service.arverrec.ArVerRecService;
import com.elitesland.fin.domain.param.arverrec.ArVerRecPageParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2022/4/26 16:32
 */
@RestController
@RequestMapping("/fin/arVerRec")
@RequiredArgsConstructor
@Api(value = "应收核销管理", tags = {"应收核销管理"})
public class ArVerRecController {
    private final ArVerRecService arVerRecService;

    @PostMapping("page")
    @ApiOperation("查询")
    public ApiResult<PagingVO<ArVerRecDtlVO>> page(@RequestBody ArVerRecPageParam pageParam) {
        PagingVO<ArVerRecDtlVO> page = arVerRecService.page(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("confirm")
    @ApiOperation("确定")
    public ApiResult<String> confirm(@RequestBody ArVerRecSaveParam param) {
        arVerRecService.confirm(param);
        return ApiResult.ok("生成核销记录成功");
    }

    @PostMapping("cancel")
    @ApiOperation("取消核销")
    public ApiResult<String> cancel(@RequestBody List<Long> masIds) {
        arVerRecService.cancel(masIds);
        return ApiResult.ok("取消核销记录成功");
    }
}
