package com.elitesland.fin.domain.service.aptype;

import com.elitesland.fin.application.convert.aptype.ApTypeOuConvert;
import com.elitesland.fin.domain.entity.aptype.ApTypeOu;
import com.elitesland.fin.domain.entity.aptype.ApTypeOuDO;
import com.elitesland.fin.domain.param.aptype.ApTypeOuPageParam;
import com.elitesland.fin.infr.dto.aptype.ApTypeOuDTO;
import com.elitesland.fin.infr.repo.aptype.ApTypeOuRepo;
import com.elitesland.fin.infr.repo.aptype.ApTypeOuRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.aptypeou
 * @date 2022/3/14 16:35
 */
@Service
@RequiredArgsConstructor
public class ApTypeOuDomainServiceImpl implements ApTypeOuDomainService {

    private final ApTypeOuRepo apTypeOuRepo;

    private final ApTypeOuRepoProc apTypeOuRepoProc;


    @Override
    public List<ApTypeOuDTO> queryByApTypeId(Long id) {
        List<ApTypeOuDTO> apTypeOuDTOS = apTypeOuRepoProc.queryByApTypeId(id);
        return apTypeOuDTOS;
    }

    @Override
    public PagingVO<ApTypeOuDTO> page(ApTypeOuPageParam apTypeOuParam) {
        PagingVO<ApTypeOuDTO> res = apTypeOuRepoProc.page(apTypeOuParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long addOu(ApTypeOu apTypeOu) {

        ApTypeOuDO apTypeOuDO = ApTypeOuConvert.INSTANCE.convert(apTypeOu);
        // 验证apTypeId 和 ouid是否存在，

        Boolean isExist = apTypeOuRepoProc.existByApTypeIdOuId(apTypeOuDO);
        if (!isExist) {
            ApTypeOuDO save = apTypeOuRepo.save(apTypeOuDO);
            return save.getId();
        }
        return apTypeOu.getApTypeId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public Long cancelOu(List<Long> ids) {
        Long res = apTypeOuRepoProc.cancelOu(ids);
        return res;
    }

    @Override
    public List<Long> queryByOuId(Long ouId) {

        List<Long> res = apTypeOuRepoProc.queryByOuId(ouId);
        return res;
    }

}
