package com.elitesland.fin.provider.accountingengine;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.accountingengine.FinJournalGenerateConvert;
import com.elitesland.fin.application.facade.param.accountingengine.ManualProposedParam;
import com.elitesland.fin.application.service.accountingengine.JournalGenerateService;
import com.elitesland.fin.param.accountingengine.ManualProposedRpcParam;
import com.elitesland.fin.service.accountingengine.JournalGenerateRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + JournalGenerateRpcService.PATH)
@Slf4j
public class JournalGenerateRpcServiceImpl implements JournalGenerateRpcService {

    private final JournalGenerateService journalGenerateService;

    @Override
    public ApiResult<Void> manualProposed(ManualProposedRpcParam rpcParam) {
        log.info("手动拟定的Rpc入参:{}", JSON.toJSONString(rpcParam));

        if (Objects.isNull(rpcParam)){
            return ApiResult.ok();
        }

        ManualProposedParam manualProposedParam = FinJournalGenerateConvert.INSTANCE.rpcParamToParam(rpcParam);
        journalGenerateService.manualProposed(manualProposedParam);

        return ApiResult.ok();
    }

}
