package com.elitesland.fin.repo.invoice;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDtlDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvDtlPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class InvoiceDtlRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QSaleInvDtlDO qSaleInvDtlDO = QSaleInvDtlDO.saleInvDtlDO;


    /**
     * 根据条件获取销售库存详情数据列表。
     *
     * @param masId 主键ID，可为空，为空时查询所有
     * @return 返回SaleInvDtlDTO对象列表，包含符合条件的所有销售库存详情数据
     */
    public List<SaleInvDtlDTO> getList(Long masId) {

        // 初始化条件列表
        List<Predicate> predicates = new ArrayList<>();
        // 如果masId不为空，则添加到条件列表中
        if (null != masId) {
            predicates.add(qSaleInvDtlDO.masId.eq(masId));
        }
        // 添加删除标志为0的条件
        predicates.add(qSaleInvDtlDO.deleteFlag.eq(0));

        // 构造查询，根据条件获取数据，并映射成SaleInvDtlDTO对象列表
        List<SaleInvDtlDTO> res = jpaQueryFactory.select(Projections.bean(SaleInvDtlDTO.class,
                qSaleInvDtlDO.id,
                qSaleInvDtlDO.masId,
                qSaleInvDtlDO.taxName,
                qSaleInvDtlDO.taxCode,
                qSaleInvDtlDO.invNature,
                qSaleInvDtlDO.sourceNo,
                qSaleInvDtlDO.sourceId,
                qSaleInvDtlDO.sourceLine,
                qSaleInvDtlDO.sourceLineId,
                qSaleInvDtlDO.itemId,
                qSaleInvDtlDO.itemName,
                qSaleInvDtlDO.itemCode,
                qSaleInvDtlDO.itemType,
                qSaleInvDtlDO.uom,
                qSaleInvDtlDO.uomName,
                qSaleInvDtlDO.qty,
                qSaleInvDtlDO.price,
                qSaleInvDtlDO.totalAmt,
                qSaleInvDtlDO.totalCurAmt,
                qSaleInvDtlDO.taxRate,
                qSaleInvDtlDO.taxAmt,
                qSaleInvDtlDO.taxCurAmt,
                qSaleInvDtlDO.exclTaxAmt,
                qSaleInvDtlDO.exclTaxCurAmt,
                qSaleInvDtlDO.invType,
                qSaleInvDtlDO.invKind,
                qSaleInvDtlDO.examType

        )).from(qSaleInvDtlDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();

        return res;
    }


    public void delByMasId(List<Long> masIds) {
        if (CollUtil.isEmpty(masIds)) {
            return;
        }
        jpaQueryFactory.delete(qSaleInvDtlDO)
                .where(qSaleInvDtlDO.masId.in(masIds))
                .execute();
    }

    public PagingVO<SaleInvDtlDTO> dtlPage(SaleInvDtlPageParam saleInvDtlPageParam) {

        List<Predicate> predicates = new ArrayList<>();

        predicates.add(qSaleInvDtlDO.deleteFlag.eq(0));
        predicates.add(qSaleInvDtlDO.masId.eq(saleInvDtlPageParam.getMasId()));

        JPAQuery<SaleInvDtlDTO> query = select(SaleInvDtlDTO.class)
                .where(ExpressionUtils.allOf(predicates));
        saleInvDtlPageParam.setPaging(query);
        saleInvDtlPageParam.fillOrders(query, qSaleInvDtlDO);
        return PagingVO.<SaleInvDtlDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qSaleInvDtlDO.id,
                qSaleInvDtlDO.masId,
                qSaleInvDtlDO.taxName,
                qSaleInvDtlDO.taxCode,
                qSaleInvDtlDO.invNature,
                qSaleInvDtlDO.sourceNo,
                qSaleInvDtlDO.sourceId,
                qSaleInvDtlDO.sourceLine,
                qSaleInvDtlDO.sourceLineId,
                qSaleInvDtlDO.itemId,
                qSaleInvDtlDO.itemName,
                qSaleInvDtlDO.itemCode,
                qSaleInvDtlDO.itemType,
                qSaleInvDtlDO.uom,
                qSaleInvDtlDO.uomName,
                qSaleInvDtlDO.qty,
                qSaleInvDtlDO.price,
                qSaleInvDtlDO.totalAmt,
                qSaleInvDtlDO.totalCurAmt,
                qSaleInvDtlDO.taxRate,
                qSaleInvDtlDO.taxAmt,
                qSaleInvDtlDO.taxCurAmt,
                qSaleInvDtlDO.exclTaxAmt,
                qSaleInvDtlDO.exclTaxCurAmt,
                qSaleInvDtlDO.invType,
                qSaleInvDtlDO.invKind,
                qSaleInvDtlDO.examType
        )).from(qSaleInvDtlDO);
    }
}
