/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.test;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fin/test"})
@Api(value="\u6d4b\u8bd5", tags={"\u6d4b\u8bd5"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"redis/del"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664redis key")
    public ApiResult<PagingVO<PayOrderVO>> del(@RequestBody List<String> keyList) {
        if (CollectionUtils.isNotEmpty(keyList)) {
            keyList.stream().forEach(v -> {
                this.redisUtils.del(new String[]{v});
                log.info("-----------\u5220\u9664redis key:{}\u6210\u529f", v);
            });
        }
        return ApiResult.ok();
    }

    @PostMapping(value={"redis/get"})
    @ApiOperation(value="\u6279\u91cf\u83b7\u53d6redis key\u7684\u503c")
    public ApiResult<Map> get(@RequestBody List<String> keyList) {
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty(keyList)) {
            keyList.stream().forEach(v -> {
                map.put(v, this.redisUtils.get(v));
                log.info("-----------\u5220\u9664redis key:{}\u6210\u529f", v);
            });
        }
        log.info("-----------\u6279\u91cf\u83b7\u53d6redis\u6210\u529f\uff1a{}", (Object)JSON.toJSONString(map));
        return ApiResult.ok(map);
    }

    @PostMapping(value={"redis/sederializer"})
    @ApiOperation(value="\u5e8f\u5217\u5316/\u53cd\u5e8f\u5217\u5316redis key\u7684\u503c")
    public ApiResult sederializer() {
        String key = "fin:sederializer:student";
        ArrayList<User> users = new ArrayList<User>();
        users.add(new User(1, "\u5f20\u4e09", LocalDateTime.now().minusDays(500L)));
        users.add(new User(1, "\u674e\u56db", LocalDateTime.now().minusDays(1000L)));
        this.redisUtils.set(key, (Object)JSON.toJSONString(users));
        Object usersNew = this.redisUtils.get(key);
        log.info("-----------\u83b7\u53d6redis key:{}\u6210\u529f", usersNew);
        return ApiResult.ok();
    }

    class User {
        int id;
        String name;
        LocalDateTime birthDay;

        public User() {
        }

        public User(int id, String name, LocalDateTime birthDay) {
            this.id = id;
            this.name = name;
            this.birthDay = birthDay;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public LocalDateTime getBirthDay() {
            return this.birthDay;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setBirthDay(LocalDateTime birthDay) {
            this.birthDay = birthDay;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User other = (User)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            LocalDateTime this$birthDay = this.getBirthDay();
            LocalDateTime other$birthDay = other.getBirthDay();
            return !(this$birthDay == null ? other$birthDay != null : !((Object)this$birthDay).equals(other$birthDay));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            LocalDateTime $birthDay = this.getBirthDay();
            result = result * 59 + ($birthDay == null ? 43 : ((Object)$birthDay).hashCode());
            return result;
        }

        public String toString() {
            return "TestController.User(id=" + this.getId() + ", name=" + this.getName() + ", birthDay=" + this.getBirthDay() + ")";
        }
    }
}

