package com.elitesland.fin.application.facade.param.accountingengine;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计期间")
public class FinAccountPeriodParam extends BaseModelParam {

    @ApiModelProperty("会计期间编码")
    private String accountPeriodCode;

    @ApiModelProperty("会计期间名称")
    private String accountPeriodName;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("会计期间明细")
    private List<FinAccountPeriodLineParam> detailList;

    @ApiModelProperty("会计期间格式集合")
    private List<String> periodStyleList;

    @ApiModelProperty("会计期间编码集合")
    private List<String> accountPeriodCodeList;

    @ApiModelProperty("交易日期")
    private LocalDateTime transactionDate;

}
