package com.elitesland.fin.application.service.creditaccountflow;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.util.RedLockUtils;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.convert.creditaccountflow.CreditAccountFlowConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountIocDTO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountIocParam;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountIocService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountRuleConfigService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.redis.MyRedisService;
import com.elitesland.fin.application.service.saobei.SaobeiAccountService;
import com.elitesland.fin.application.service.unionpay.entity.constant.Constants;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinFlexFieldCodeConstant;
import com.elitesland.fin.common.FinRedisConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.config.SaoBeiConstant;
import com.elitesland.fin.domain.service.creditAccountFlow.CreditAccountFlowDomainService;
import com.elitesland.fin.entity.creditaccount.CreditAccountDO;
import com.elitesland.fin.entity.creditaccount.CreditAccountRuleConfigDO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.repo.account.AccountRuleConfigRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepo;
import com.elitesland.fin.repo.creditaccount.CreditAccountRepoProc;
import com.elitesland.fin.repo.creditaccount.CreditAccountRuleConfigRepo;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepo;
import com.elitesland.fin.repo.creditaccountflow.CreditAccountFlowRepoProc;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.sale.RmiSaleRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.fin.utils.SysUtils;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import com.elitesland.support.provider.org.dto.OrgOuBankAccRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import com.elitesland.support.provider.org.param.OrgBankAccQueryRpcParam;
import com.elitesland.support.provider.org.service.OrgAddrRpcService;
import com.saobei.open.sdk.model.requst.allocate.SaobeiDoTransRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.redisson.RedissonRedLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


/**
 * @Author gyj
 * @Date 2023/02/25
 */
@Service
@Slf4j
public class CreditAccountFlowServiceImpl implements CreditAccountFlowService {

    @Autowired
    private CreditAccountFlowRepo creditAccountFlowRepo;

    @Autowired
    private CreditAccountFlowRepoProc creditAccountFlowRepoProc;

    @Autowired
    private CreditAccountRepoProc creditAccountRepoProc;

    @Autowired
    private CreditAccountRepo creditAccountRepo;

    @Autowired
    private RedissonClient redissonClient;

    @Autowired
    private RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Autowired
    private AccountRuleConfigRepo accountRuleConfigRepo;

    @Autowired
    private RmiOrderRpcService rmiOrderRpcService;

    @Autowired
    private CreditAccountService creditAccountService;

    @Autowired
    private FinSalMqProcessor finSalMqProcessor;

    @Autowired
    private CreditAccountIocService creditAccountIocService;

    @Autowired
    private SeqNumProvider seqNumProvider;

    @Autowired
    private CreditAccountRuleConfigService creditAccountRuleConfigService;

    @Autowired
    private RmiSaleRpcService rmiSaleRpcService;

    @Autowired
    private CreditAccountRuleConfigRepo creditAccountRuleConfigRepo;
    @Autowired
    private RedLockUtils redLockUtils;
    @Autowired
    private FlexFieldUtilService flexFieldUtilService;
    @Autowired
    private  MyRedisService myRedisService;
    @Autowired
    private  CreditAccountFlowDomainService creditAccountFlowDomainService;
    @Autowired
    private SaobeiAccountService saobeiAccountService;
    @Autowired
    private OrgAddrRpcService orgAddrRpcService;
    private static final BigDecimal ONE_HUNDRED_BIGDECIMAL = new BigDecimal("100");


    @Override
    @SysCodeProc
    public PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowPageParam creditAccountFlowPageParam) {

        PagingVO<CreditAccountFlowDTO> pagingVO = creditAccountFlowRepoProc.page(creditAccountFlowPageParam);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<CreditAccountFlowVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        //根据公司编码、加盟商编码、规则编码获取名称
        List<CreditAccountFlowDTO> creditAccountFlowDTOList = pagingVO.getRecords();

        List<String> companyCodes = creditAccountFlowDTOList.stream().map(CreditAccountFlowDTO::getFromOuCode).filter(Objects::nonNull).collect(Collectors.toList());
        companyCodes.addAll(creditAccountFlowDTOList.stream().map(CreditAccountFlowDTO::getToOuCode).filter(Objects::nonNull).collect(Collectors.toList()));
        companyCodes.addAll(creditAccountFlowDTOList.stream().map(CreditAccountFlowDTO::getOuCode).filter(Objects::nonNull).collect(Collectors.toList()));
        Map<String, String> ouMap = rmiOrgOuRpcServiceService.findBaseOuByCodes(companyCodes).stream().collect(Collectors.toMap(OrgOuRpcSimpleDTO::getOuCode, OrgOuRpcSimpleDTO::getOuName));

        List<CreditAccountRuleConfigDO> creditAccountRuleConfigDOList = creditAccountRuleConfigRepo.findAll();

        creditAccountFlowDTOList.stream().forEach(item -> {

            if (StringUtils.isNotBlank(item.getFromOuCode())) {
                item.setFromOuName(ouMap.get(item.getFromOuCode()));
            }
            if (StringUtils.isNotBlank(item.getToOuCode())) {
                item.setToOuName(ouMap.get(item.getToOuCode()));
            }
            if (StringUtils.isNotBlank(item.getOuCode())) {
                item.setOuName(ouMap.get(item.getOuCode()));
            }

            CreditAccountRuleConfigDO creditAccountRuleConfigDO = creditAccountRuleConfigDOList.stream()
                    .filter(accountRuleConfigDO -> StringUtils.equals(item.getCreditAccountRuleCode(), accountRuleConfigDO.getRuleCode()))
                    .findFirst()
                    .orElse(null);
            if (creditAccountRuleConfigDO != null) {
                item.setCreditAccountRuleName(creditAccountRuleConfigDO.getRuleName());
            }
            item.setOptType(SysUtils.getOptType(item.getSourceDocStatus()));

        });
        return PagingVO.<CreditAccountFlowDTO>builder()
                .total(pagingVO.getTotal())
                .records(pagingVO.getRecords())
                .build();
    }


    @Override
    @SysCodeProc
    public PagingVO<CreditAccountFlowDTO> appPage(CreditAccountFlowPageParam creditAccountFlowPageParam) {

        PagingVO<CreditAccountFlowDTO> pagingVO = creditAccountFlowRepoProc.appPage(creditAccountFlowPageParam);
        List<CreditAccountFlowDTO> creditAccountFlowDTOList = pagingVO.getRecords();
        if (CollectionUtils.isEmpty(creditAccountFlowDTOList)) {
            return PagingVO.<CreditAccountFlowVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        return PagingVO.<CreditAccountFlowDTO>builder()
                .total(pagingVO.getTotal())
                .records(pagingVO.getRecords())
                .build();
    }

    @Override
    @SysCodeProc
    public List<CreditAccountFlowDTO> appList(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        return creditAccountFlowRepoProc.appList(creditAccountFlowPageParam);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void approve(CreditAccountFlowParam creditAccountFlowParam) {
        checkApproveParam(creditAccountFlowParam);
        approve(creditAccountFlowParam, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode(), true);
    }
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void updateBalanceAndGenerateCreditAccountFlow(List<CreditAccountFlowParam> creditAccountFlowParams) {
        //checkApproveParam(creditAccountFlowParam);
        creditAccountFlowParams.forEach(v->{
            CreditAccountFlowParam creditAccountFlowParam=v;
            CreditAccountDTO oldCreditAccountDTO = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals(oldCreditAccountDTO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");
            if(UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())){
                /*CreditAccountDTO creditAccountDTOOld = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
                Assert.equals(creditAccountDTOOld.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");*/
                int res= creditAccountRepo.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户占用流水生成，更新信用账户失败，可用金额不足");
                    throw new BusinessException("信用账户占用流水生成，更新信用账户失败，可用金额不足");
                }
               /* CreditAccountDTO creditAccountDTO = creditAccountRepoProc.get(oldCreditAccountDTO.getId());
                if(creditAccountDTO==null){
                    log.error("信用账户流水生成，查询信用账户失败");
                    throw new BusinessException("信用账户流水生成，查询信用账户失败");
                }*/
               /* BigDecimal creditAccountLimit = creditAccountDTO.getCreditAccountLimit();
                BigDecimal creditAccountUsedLimit = creditAccountDTO.getCreditAccountUsedLimit();
                BigDecimal creditAccountOccupancyLimit = creditAccountDTO.getCreditAccountOccupancyLimit();
                BigDecimal creditAccountAvailableLimit=creditAccountDTO.getCreditAccountAvailableLimit();*/
                //更新审批中的流水的状态
      /*          creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
                creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
                creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
                creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
                creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());*/
                creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
            }else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户扣减流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户扣减流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户扣减流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户占用释放流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户占用释放流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户占用释放流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用减少流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用减少流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用减少流水生成，更新信用账户失败!");
                }
            }else {
                throw new BusinessException("信用账户未匹配到交易类型!");
            }

            CreditAccountDTO newCreditAccountDTO = creditAccountRepoProc.get(oldCreditAccountDTO.getId());
            if(newCreditAccountDTO==null){
                log.error("信用账户流水生成，查询更新后信用账户失败");
                throw new BusinessException("信用账户流水生成，查询更新后信用账户失败");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit= newCreditAccountDTO.getCreditAccountAvailableLimit();

            //更新审批中的流水的状态
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            //creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            //更新流水单状态
            SysUserDTO user = getUser();

            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            creditAccountFlowParam.setAuditDate(LocalDateTime.now());
            creditAccountFlowParam.setAuditUserName(FinConstant.SYSTEM);

            if (user != null) {
                creditAccountFlowParam.setAuditUserId(user.getId());
                creditAccountFlowParam.setAuditUserName(user.getLastName());
            }
            //创建信用账户流水
            CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO(creditAccountFlowParam);
            flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.CREDIT_ACCOUNT_FLOW, creditAccountFlowDO);
            creditAccountFlowDO=creditAccountFlowRepo.save(creditAccountFlowDO);
            creditAccountFlowParam.setId(creditAccountFlowDO.getId());
        });
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void reject(CreditAccountFlowParam creditAccountFlowParam) {
        checkApproveParam(creditAccountFlowParam);
        approve(creditAccountFlowParam, UdcEnum.APPLY_STATUS_REJECTED.getValueCode(), false);
    }


    @Override
    public void accountFlowCallBack(String doc, CreditAccountFlowDO creditAccountFlowDO, boolean isApprove) {

        if (UdcEnum.DOC_CLS_SVO.getValueCode().equals(doc) || UdcEnum.DOC_CLS_AO.getValueCode().equals(doc)) {
            return;
        }
//        OrderAccountFlowRpcParam orderAccountFlowRpcParam = new OrderAccountFlowRpcParam();
//        //销售订单id
//        orderAccountFlowRpcParam.setSoId(creditAccountFlowDO.getSourceId());
//        //订单类别
//        orderAccountFlowRpcParam.setDocCls(creditAccountFlowDO.getSourceDoc());
//        //流水号
//        orderAccountFlowRpcParam.setReceiptSerial(creditAccountFlowDO.getFlowNo());
//        //交易类型
//        orderAccountFlowRpcParam.setTransType(creditAccountFlowDO.getTransactionType());
//        //发生金额
//        orderAccountFlowRpcParam.setReceiptAmt(creditAccountFlowDO.getAmount());
//        //交易日期
//        orderAccountFlowRpcParam.setReceiptDate(creditAccountFlowDO.getTransactionTime());
//        //账户编码
//        orderAccountFlowRpcParam.setPayAccNo(creditAccountFlowDO.getAccountCode());
//        //账户名称
//        orderAccountFlowRpcParam.setPayAccName(creditAccountFlowDO.getAccountName());
//        //账户名称
//        orderAccountFlowRpcParam.setIsApprove(isApprove);
//
//        rmiOrderRpcService.orderAccountFlow(orderAccountFlowRpcParam);
    }


    private void checkApproveParam(CreditAccountFlowParam param) {
        Assert.notNull(param, "参数不能为空");
        Assert.notNull(param.getId(), "id不能为空");
        Assert.notEmpty(param.getCreditAccountCode(), "账户编码不能为空");
        Assert.notEmpty(param.getTransactionType(), "交易类型不能为空");
        Assert.notNull(param.getAmount(), "发生金额不能为空");
    }

    private void approve(CreditAccountFlowParam creditAccountFlowParam, String state, boolean isApprove) {

        Optional<CreditAccountFlowDO> creditAccountFlowDOOptional = creditAccountFlowRepo.findById(creditAccountFlowParam.getId());
        Assert.isTrue(creditAccountFlowDOOptional.isPresent(), "查询不到单据");

        CreditAccountFlowDO creditAccountFlowDO = creditAccountFlowDOOptional.get();
        Assert.equals(UdcEnum.APPLY_STATUS_DOING.getValueCode(), creditAccountFlowDO.getOrderState(), "只有审批中状态单据才可审批");
       /* if(UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())){
            updateAccountAmountFor_CREDIT_IO_TYPE_T(creditAccountFlowParam, state);
        }else{
            //更新账户金额
            updateAccountAmountOther(creditAccountFlowParam, state);
        }*/
        updateAccountAmountAndApprove(creditAccountFlowParam,state);
        //更新流水单状态
      /*  SysUserDTO user = getUser();

        creditAccountFlowParam.setOrderState(state);
        creditAccountFlowParam.setAuditDate(LocalDateTime.now());
        creditAccountFlowParam.setAuditUserName(FinConstant.SYSTEM);

        if (user != null) {
            creditAccountFlowParam.setAuditUserId(user.getId());
            creditAccountFlowParam.setAuditUserName(user.getLastName());
        }

        creditAccountFlowRepoProc.approveAccountFlow(creditAccountFlowParam);*/

    }

    private void updateAccountAmount(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {

            CreditAccountDO creditAccountDO = creditAccountRepoProc.findByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());

            BigDecimal creditAccountLimit = creditAccountDO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = creditAccountDO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = creditAccountDO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit;

            Assert.equals(creditAccountDO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");

            if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountLimit = creditAccountLimit.add(creditAccountFlowParam.getAmount());
            }

            if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountLimit = creditAccountLimit.subtract(creditAccountFlowParam.getAmount());
            }

            if (UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountOccupancyLimit = creditAccountOccupancyLimit.add(creditAccountFlowParam.getAmount());
            }

            if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountOccupancyLimit = creditAccountOccupancyLimit.subtract(creditAccountFlowParam.getAmount());
            }

            if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountUsedLimit = creditAccountUsedLimit.add(creditAccountFlowParam.getAmount());
            }

            if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                creditAccountUsedLimit = creditAccountUsedLimit.subtract(creditAccountFlowParam.getAmount());
            }

            creditAccountAvailableLimit = creditAccountLimit.subtract(creditAccountUsedLimit).subtract(creditAccountOccupancyLimit);

            creditAccountDO.setCreditAccountLimit(creditAccountLimit);
            creditAccountDO.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountDO.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountDO.setCreditAccountAvailableLimit(creditAccountAvailableLimit);

            //更新审批中的流水的状态
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
        }
    }
    private void updateAccountAmountFor_CREDIT_IO_TYPE_T(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            CreditAccountDTO creditAccountDTOOld = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals(creditAccountDTOOld.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");
            int res= creditAccountRepo.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(creditAccountDTOOld.getId(), creditAccountFlowParam.getAmount());
            log.info("信用账户流水生成，更新记录数：{}",res);
            if(res<1){
                log.error("信用账户流水生成，更新信用账户失败，可用金额不足");
                throw new BusinessException("信用账户流水生成，更新信用账户失败，可用金额不足");
            }
            CreditAccountDTO creditAccountDTO = creditAccountRepoProc.get(creditAccountDTOOld.getId());
            if(creditAccountDTO==null){
                log.error("信用账户流水生成，查询信用账户失败");
                throw new BusinessException("信用账户流水生成，查询信用账户失败");
            }
            BigDecimal creditAccountLimit = creditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = creditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = creditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit=creditAccountDTO.getCreditAccountAvailableLimit();
            //更新审批中的流水的状态
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
        }
    }
    private void updateAccountAmountOther(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {

            CreditAccountDTO oldCreditAccountDTO = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals(oldCreditAccountDTO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");

            if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户扣减流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户扣减流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户扣减流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户占用释放流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户占用释放流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户占用释放流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用减少流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用减少流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用减少流水生成，更新信用账户失败!");
                }
            }else {
                throw new BusinessException("信用账户未匹配到交易类型!");
            }

            CreditAccountDTO newCreditAccountDTO = creditAccountRepoProc.get(oldCreditAccountDTO.getId());
            if(newCreditAccountDTO==null){
                log.error("信用账户流水生成，查询更新后信用账户失败");
                throw new BusinessException("信用账户流水生成，查询更新后信用账户失败");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit= newCreditAccountDTO.getCreditAccountAvailableLimit();

            //更新审批中的流水的状态
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
        }
    }
    private void updateAccountAmountAndApprove(CreditAccountFlowParam creditAccountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {

            CreditAccountDTO oldCreditAccountDTO = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
            Assert.equals(oldCreditAccountDTO.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");
            if(UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(creditAccountFlowParam.getTransactionType())){
                /*CreditAccountDTO creditAccountDTOOld = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
                Assert.equals(creditAccountDTOOld.getStatus(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), "信用账户已经被禁用");*/
                int res= creditAccountRepo.updateCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户占用流水生成，更新信用账户失败，可用金额不足");
                    throw new BusinessException("信用账户占用流水生成，更新信用账户失败，可用金额不足");
                }
               /* CreditAccountDTO creditAccountDTO = creditAccountRepoProc.get(oldCreditAccountDTO.getId());
                if(creditAccountDTO==null){
                    log.error("信用账户流水生成，查询信用账户失败");
                    throw new BusinessException("信用账户流水生成，查询信用账户失败");
                }*/
               /* BigDecimal creditAccountLimit = creditAccountDTO.getCreditAccountLimit();
                BigDecimal creditAccountUsedLimit = creditAccountDTO.getCreditAccountUsedLimit();
                BigDecimal creditAccountOccupancyLimit = creditAccountDTO.getCreditAccountOccupancyLimit();
                BigDecimal creditAccountAvailableLimit=creditAccountDTO.getCreditAccountAvailableLimit();*/
                //更新审批中的流水的状态
      /*          creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
                creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
                creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
                creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
                creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());*/
                creditAccountFlowRepoProc.updateCreditAccountFlowAmount(creditAccountFlowParam);
            }else if (UdcEnum.CREDIT_IO_TYPE_I.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateAddCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_O.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户扣减流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户扣减流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户扣减流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_R.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountOccupancyLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户占用释放流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户占用释放流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户占用释放流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_U.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateAddCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用增加流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用增加流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用增加流水生成，更新信用账户失败!");
                }
            }else if (UdcEnum.CREDIT_IO_TYPE_D.getValueCode().equals(creditAccountFlowParam.getTransactionType())) {
                int res= creditAccountRepo.updateSubtractCreditAccountUsedLimitAndCreditAccountAvailableLimitById(oldCreditAccountDTO.getId(), creditAccountFlowParam.getAmount());
                log.info("信用账户使用减少流水生成，更新记录数：{}",res);
                if(res<1){
                    log.error("信用账户使用减少流水生成，更新信用账户失败!");
                    throw new BusinessException("信用账户使用减少流水生成，更新信用账户失败!");
                }
            }else {
                throw new BusinessException("信用账户未匹配到交易类型!");
            }

            CreditAccountDTO newCreditAccountDTO = creditAccountRepoProc.get(oldCreditAccountDTO.getId());
            if(newCreditAccountDTO==null){
                log.error("信用账户流水生成，查询更新后信用账户失败");
                throw new BusinessException("信用账户流水生成，查询更新后信用账户失败");
            }
            BigDecimal creditAccountLimit = newCreditAccountDTO.getCreditAccountLimit();
            BigDecimal creditAccountUsedLimit = newCreditAccountDTO.getCreditAccountUsedLimit();
            BigDecimal creditAccountOccupancyLimit = newCreditAccountDTO.getCreditAccountOccupancyLimit();
            BigDecimal creditAccountAvailableLimit= newCreditAccountDTO.getCreditAccountAvailableLimit();

            //更新审批中的流水的状态
            creditAccountFlowParam.setCreditAccountLimit(creditAccountLimit);
            creditAccountFlowParam.setCreditAccountUsedLimit(creditAccountUsedLimit);
            creditAccountFlowParam.setCreditAccountOccupancyLimit(creditAccountOccupancyLimit);
            creditAccountFlowParam.setCreditAccountAvailableLimit(creditAccountAvailableLimit);
            //creditAccountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            //更新流水单状态
            SysUserDTO user = getUser();

            creditAccountFlowParam.setOrderState(state);
            creditAccountFlowParam.setAuditDate(LocalDateTime.now());
            creditAccountFlowParam.setAuditUserName(FinConstant.SYSTEM);

            if (user != null) {
                creditAccountFlowParam.setAuditUserId(user.getId());
                creditAccountFlowParam.setAuditUserName(user.getLastName());
            }
            creditAccountFlowRepoProc.updateCreditAccountFlowAmountById(creditAccountFlowParam);
        }
    }
    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }

    @Override
    public String generateCreditAccountFlow(CreditAccountFlowParam param) {
        log.info("生成信用账户流水，接收到参数{}", JSONUtil.toJsonStr(param));
        //参数检查
        checkGenerateCreditAccountFlowParam(param);

        CreditAccountFlowParam creditAccountFlowParam = CreditAccountFlowConvert.INSTANCE.copyParam(param);

        //组装财务域udc
        buildCreditAccountFlowParam(creditAccountFlowParam);

        //获取账户信息
        CreditAccountDO creditAccountDO = getCreditAccountMsg(creditAccountFlowParam);

        //幂等
        // 账户流水校验重复：增加是否启用工作流判断，如果单据已有工作流，就允许重复；如果单据没有工作流，就不允许重复
        if (StrUtil.isEmpty(param.getWorkflowProcInstId())) {
            checkIdempotent(creditAccountDO, creditAccountFlowParam);
        }
        //获取账户规则
        List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList = getCreditAccountRuleMsgWithRedis(creditAccountDO, creditAccountFlowParam);
        if (CollUtil.isEmpty(accountRuleConfigPageVOList)) {
            log.info("生成信用账户流水,未查询到信用账户规则");
            return "";
        }
        //获取账户事务码
        List<CreditAccountIocDTO> accountIocDTOList = getAccountIocMsgWithRedis(accountRuleConfigPageVOList);

        //根据优先级排序
        accountRuleConfigPageVOList = accountRuleConfigPageVOList.stream()
                .sorted(Comparator.comparing(CreditAccountRuleConfigPageVO::getPriorityNo))
                .collect(Collectors.toList());

        //校验账户余额
/*
        checkCreditAccountLimit(accountRuleConfigPageVOList, creditAccountDO, creditAccountFlowParam, accountIocDTOList);
*/

        //生成账户流水
/*        List<CreditAccountFlowParam> creditAccountFlowParamList = generateCreditAccountFlow(accountRuleConfigPageVOList,
                creditAccountFlowParam,
                creditAccountDO,
                accountIocDTOList);*/

        //流水审批
       /* creditAccountFlowReview(creditAccountFlowParamList);*/
        //加锁begin
        RedissonRedLock redLock=null;
        try {
            String lockKey="ACCOUNT_FLOW_GENERATE:"+creditAccountDO.getCreditAccountCode();
            log.info("信用账户流水生成，锁:{}",lockKey);
            redLock = redLockUtils.getRedLock(lockKey);
            boolean lockFlag = redLock.tryLock(3, 300, TimeUnit.SECONDS);
            if (!lockFlag) {
                log.error("信用账户流水生成，获取锁失败");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "信用账户流水生成并发过大,请稍后再试！");
            }
            log.info("信用账户流水生成，获取锁成功");
            //再次获取账户信息
            CreditAccountDTO creditAccountDTO = creditAccountRepoProc.getDTOByCreditAccountCode(creditAccountDO.getCreditAccountCode());
            CreditAccountDO creditAccountDO1= CreditAccountConvert.INSTANCE.ConvertDTO2DO(creditAccountDTO);
            //校验账户余额
            checkCreditAccountLimit(accountRuleConfigPageVOList, creditAccountDO1, creditAccountFlowParam, accountIocDTOList);
            //生成流水单
     /*       List<CreditAccountFlowParam> creditAccountFlowParamList = generateCreditAccountFlow(accountRuleConfigPageVOList,
                    creditAccountFlowParam,
                    creditAccountDO1,
                    accountIocDTOList);*/
            List<CreditAccountFlowParam> creditAccountFlowParamList = buildCreditAccountFlow(accountRuleConfigPageVOList,
                    creditAccountFlowParam,
                    creditAccountDO1,
                    accountIocDTOList);

            // 扫呗分账
            if (!"AO".equals(param.getSourceDoc())) {
                saoBeiTrans(param, creditAccountFlowParamList, accountIocDTOList);
            }
            // 归属公司
            creditAccountFlowParamList.forEach(flow -> flow.setOuCode(flow.getTOuCode()));

            List<CreditAccountFlowParam> autoApproveCreditAccountFlowParams = new ArrayList<>();
            List<CreditAccountFlowParam> notAutoApproveCreditAccountFlowParams = new ArrayList<>();
            creditAccountFlowParamList.forEach(v->{
                if (v.isAutomaticReview()) {
                    autoApproveCreditAccountFlowParams.add(v);
                }else{
                    notAutoApproveCreditAccountFlowParams.add(v);
                }
            });
            log.info("扫呗更新账户流水:{}", JSONObject.toJSONString(autoApproveCreditAccountFlowParams));
            if(!CollectionUtils.isEmpty(autoApproveCreditAccountFlowParams)){
                creditAccountFlowDomainService.updateBalanceAndGenerateCreditAccountFlow(autoApproveCreditAccountFlowParams);
            }
            log.info("扫呗保存账户流水:{}", JSONObject.toJSONString(notAutoApproveCreditAccountFlowParams));
            if(!CollectionUtils.isEmpty(notAutoApproveCreditAccountFlowParams)){
                creditAccountFlowDomainService.saveCreditAccountFlowList(notAutoApproveCreditAccountFlowParams);
            }

            return creditAccountFlowParamList.get(0).getFlowNo();
        } catch (InterruptedException e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "信用账户流水生成，获取redis锁异常,请稍后再试！");
        } finally {
            redLock.unlock();
            log.info("信用账户流水生成，释放锁成功");
        }
        //加锁end
    }

    private void saoBeiTrans(CreditAccountFlowParam param, List<CreditAccountFlowParam> creditAccountFlowParamList, List<CreditAccountIocDTO> accountIocDTOList) {
        log.info("扫呗账户分账流水,流水：{}，事务：{}", JSONObject.toJSON(creditAccountFlowParamList), JSONObject.toJSON(accountIocDTOList));
        boolean out_flag = FinConstant.FLOW_OPT_DOC_STATUS_OUT.contains(param.getSourceDocStatus());
        List<CreditAccountFlowParam> actualFlowParams;
        if (out_flag) {
            actualFlowParams = creditAccountFlowParamList.stream().filter(flow -> FinConstant.IO_TYPE_IN_LIST.contains(flow.getTransactionType())).collect(Collectors.toList());
        } else {
            actualFlowParams = creditAccountFlowParamList.stream().filter(flow -> FinConstant.IO_TYPE_OUT_LIST.contains(flow.getTransactionType())).collect(Collectors.toList());
        }

        List<String> ouCodes = new ArrayList<>();
        ouCodes.addAll(actualFlowParams.stream().map(CreditAccountFlowParam::getOuCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList()));
        ouCodes.addAll(actualFlowParams.stream().map(CreditAccountFlowParam::getTOuCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(ouCodes)) {
            OrgBankAccQueryRpcParam bankAccQueryParam = new OrgBankAccQueryRpcParam();
            bankAccQueryParam.setAccType(UdcEnum.ORG_BANK_TYPE_SAO_BEI.getValueCode());
            bankAccQueryParam.setStatus(UdcEnum.ORG_BANK_STATUS_ACTIVE.getValueCode());
            bankAccQueryParam.setOuCodes(ouCodes);
            List<OrgOuBankAccRpcDTO> bankList = orgAddrRpcService.findOuBankByParam(bankAccQueryParam);
            Map<String, String> ouAccountMap = bankList.stream().collect(Collectors.toMap(OrgOuBankAccRpcDTO::getOuCode, OrgOuBankAccRpcDTO::getBankAcc));

            // 校验公司是否绑定扫呗账号
            List<String> noAccountOuCodes = ouCodes.stream().filter(ouCode -> !ouAccountMap.containsKey(ouCode)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(noAccountOuCodes)) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "公司未绑定扫呗账户：" + String.join(",", noAccountOuCodes));
            }

            actualFlowParams.forEach(flow -> {
                SaobeiDoTransRequest request = new SaobeiDoTransRequest();
                if (out_flag) {
                    request.setAccount_out(ouAccountMap.get(flow.getTOuCode()));
                    request.setAccount_in(ouAccountMap.get(flow.getOuCode()));
                    flow.setFromOuCode(flow.getTOuCode());
                    flow.setToOuCode(flow.getOuCode());
                } else {
                    request.setAccount_out(ouAccountMap.get(flow.getOuCode()));
                    request.setAccount_in(ouAccountMap.get(flow.getTOuCode()));
                    flow.setFromOuCode(flow.getOuCode());
                    flow.setToOuCode(flow.getTOuCode());
                }

                flow.setFromAccountNo(request.getAccount_out());
                flow.setToAccountNo(request.getAccount_in());

                // 出入账公司不同时才调扫呗
                if (flow.getFromAccountNo().equals(flow.getToAccountNo())) {
                    flow.setSyncStatus(UdcEnum.FLOW_SYNC_STATUS_4.getValueCode());
                } else {
                    flow.setSyncStatus(UdcEnum.FLOW_SYNC_STATUS_0.getValueCode());
                    /*request.setAmt(flow.getAmount().multiply(ONE_HUNDRED_BIGDECIMAL).stripTrailingZeros().toPlainString());
                    request.setTrade_no(flow.getFlowNo());
                    request.setTrans_type("1");
                    request.setOrder_body("扫呗账户分账");
                    try {
                        var response = saobeiAccountService.doAlltrans(request);
                        if (SaoBeiConstant.SUCCESS_CODE.equals(response.getReturn_code()) && SaoBeiConstant.SUCCESS_CODE.equals(response.getResult_code())) {
                            flow.setRelateFlowNo(StringUtils.isBlank(response.getOut_trade_no()) ? response.getRev_trade_no() : response.getOut_trade_no() );
                            flow.setSyncStatus(response.getTrade_status());
                            if ("3".equals(response.getTrade_status())) {
                            } else if ("1".equals(response.getTrade_status())) {
                                // 分账成功
                            } else {
                                // 分账失败
                                String errorMsg = StrUtil.isNotBlank(response.getReturn_msg()) ? response.getReturn_msg() : "CBK余额分账交易失败";
                                flow.setSyncLog("CBK余额分账交易失败:" + errorMsg);
                                log.info("扫呗:{},CBK余额分账交易失败，原因：{}", request.getTrade_no(), errorMsg);
                                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, errorMsg);
                            }
                        } else {
                            // 分账接口调用失败
                            String errorMsg = response.getReturn_msg();
                            flow.setSyncLog("CBK余额分账调用失败:" + errorMsg);
                            flow.setSyncStatus(UdcEnum.FLOW_SYNC_STATUS_2.getValueCode());
                            log.info("扫呗:{},CBK余额分账调用失败，原因：{}", request.getTrade_no(), errorMsg);
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, errorMsg);
                        }
                    } catch (Exception e) {
                        log.info("扫呗分账失败，参数{}，原因：{}", JSONObject.toJSONString(request), e.getMessage());
                        flow.setSyncLog("CBK余额分账调用失败:" + e.getMessage());
                        flow.setSyncStatus(UdcEnum.FLOW_SYNC_STATUS_2.getValueCode());
                    }*/
                }
            });
        }
    }

    private void creditAccountFlowReview(List<CreditAccountFlowParam> creditAccountFlowParamList) {

        creditAccountFlowParamList.stream().forEach(item -> {
            if (item.isAutomaticReview()) {
                approve(item);
            }
        });
    }

//    private void sendCreditAccountFlowReviewMsg(List<CreditAccountFlowParam> creditAccountFlowParamList) {
//        creditAccountFlowParamList.stream().forEach(item -> {
//            if (item.isAutomaticReview()) {
//                //发送流水审批消息
//                try {
//                    boolean result = finSalMqProcessor.approveCreditAccountFlowOutput().send(MessageBuilder.withPayload(item).build());
//                    if (!result) {
//                        log.error("流水自动审批消息发送失败");
//                    }
//                } catch (Exception e) {
//                    log.error("流水自动审批消息发送失败，失败原因：" + e.getMessage(), e);
//                }
//            }
//        });
//    }

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void saveCreditAccountFlowList(List<CreditAccountFlowParam> creditAccountFlowParams) {
        creditAccountFlowParams.stream().forEach(v->{
            //创建信用账户流水
            CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO(v);
            flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.CREDIT_ACCOUNT_FLOW, creditAccountFlowDO);
            creditAccountFlowDO=creditAccountFlowRepo.save(creditAccountFlowDO);
            v.setId(creditAccountFlowDO.getId());
        });
    }
    private List<CreditAccountFlowParam> buildCreditAccountFlow(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList,
                                                                   CreditAccountFlowParam creditAccountFlowParam,
                                                                   CreditAccountDO creditAccountDO,
                                                                   List<CreditAccountIocDTO> accountIocDTOList) {
        List<CreditAccountRuleConfigPageVO> finalAccountRuleConfigPageVOList = accountRuleConfigPageVOList;
        List<CreditAccountFlowParam> creditAccountFlowParamList = new ArrayList<>();

        Integer amtRound = SysUtils.getAmtPlace();

        //生成流水单
        finalAccountRuleConfigPageVOList.stream().forEach(accountRuleConfigPageVO -> {

            CreditAccountFlowParam accountParam = buildCreditAccountFlowParam(creditAccountFlowParam,
                    creditAccountDO,
                    accountIocDTOList,
                    accountRuleConfigPageVO, amtRound);

            boolean addFlag = addAccountFlowParam(creditAccountFlowParamList, accountRuleConfigPageVO, creditAccountFlowParam, accountParam, amtRound);

            if (!addFlag) {
                creditAccountFlowParamList.add(accountParam);
                accountParam.setFlowNo(seqNumProvider.generateCode(Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
            }
            //创建信用账户流水
/*            CreditAccountFlowDO creditAccountFlowDO = CreditAccountFlowConvert.INSTANCE.param2DO(param);
            flexFieldUtilService.handFlexFieldValueFeference(FinFlexFieldCodeConstant.CREDIT_ACCOUNT_FLOW, creditAccountFlowDO);
            creditAccountFlowRepo.save(creditAccountFlowDO);*/

           /* param.setFlowNo(creditAccountFlowDO.getFlowNo());
            param.setId(creditAccountFlowDO.getId());*/
        });
        return creditAccountFlowParamList;
    }

    public boolean addAccountFlowParam(List<CreditAccountFlowParam> creditAccountFlowParamList,CreditAccountRuleConfigPageVO accountRuleConfigPageVO,CreditAccountFlowParam creditAccountFlowParam, CreditAccountFlowParam accountParam, Integer amtRound) {
        boolean addFlag = false;
        // 货款
        if (creditAccountFlowParam.getItemFee() != null && creditAccountFlowParam.getItemFee().compareTo(BigDecimal.ZERO) > 0) {
            CreditAccountFlowParam itemAccountFlow = CreditAccountFlowConvert.INSTANCE.copyParam(accountParam);
            //发生金额
            itemAccountFlow.setAmount(creditAccountFlowParam.getItemFee()
                    .multiply(accountRuleConfigPageVO.getCalculatePercent())
                    .divide(ONE_HUNDRED_BIGDECIMAL, amtRound, RoundingMode.HALF_UP));
            itemAccountFlow.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_ITEM.getValueCode());
            itemAccountFlow.setTOuCode(accountParam.getItemFeeOuCode());
            itemAccountFlow.setFlowNo(seqNumProvider.generateCode(Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
            creditAccountFlowParamList.add(itemAccountFlow);
            addFlag = true;
        }

        // 营销费
        if (creditAccountFlowParam.getMarketingFee() != null && creditAccountFlowParam.getMarketingFee().compareTo(BigDecimal.ZERO) > 0) {
            CreditAccountFlowParam itemAccountFlow = CreditAccountFlowConvert.INSTANCE.copyParam(accountParam);
            //发生金额
            itemAccountFlow.setAmount(creditAccountFlowParam.getMarketingFee()
                    .multiply(accountRuleConfigPageVO.getCalculatePercent())
                    .divide(ONE_HUNDRED_BIGDECIMAL, amtRound, RoundingMode.HALF_UP));
            itemAccountFlow.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_MARKETING.getValueCode());
            itemAccountFlow.setTOuCode(accountParam.getMarketingFeeOuCode());
            itemAccountFlow.setFlowNo(seqNumProvider.generateCode(Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
            creditAccountFlowParamList.add(itemAccountFlow);
            addFlag = true;
        }

        // 科技费
        if (creditAccountFlowParam.getTechFee() != null && creditAccountFlowParam.getTechFee().compareTo(BigDecimal.ZERO) > 0) {
            CreditAccountFlowParam itemAccountFlow = CreditAccountFlowConvert.INSTANCE.copyParam(accountParam);
            //发生金额
            itemAccountFlow.setAmount(creditAccountFlowParam.getTechFee()
                    .multiply(accountRuleConfigPageVO.getCalculatePercent())
                    .divide(ONE_HUNDRED_BIGDECIMAL, amtRound, RoundingMode.HALF_UP));
            itemAccountFlow.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_TECH.getValueCode());
            itemAccountFlow.setTOuCode(accountParam.getTechFeeOuCode());
            itemAccountFlow.setFlowNo(seqNumProvider.generateCode(Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
            creditAccountFlowParamList.add(itemAccountFlow);
            addFlag = true;
        }

        // 服务费
        if (creditAccountFlowParam.getOperationFee() != null && creditAccountFlowParam.getOperationFee().compareTo(BigDecimal.ZERO) > 0) {
            CreditAccountFlowParam itemAccountFlow = CreditAccountFlowConvert.INSTANCE.copyParam(accountParam);
            //发生金额
            itemAccountFlow.setAmount(creditAccountFlowParam.getOperationFee()
                    .multiply(accountRuleConfigPageVO.getCalculatePercent())
                    .divide(ONE_HUNDRED_BIGDECIMAL, amtRound, RoundingMode.HALF_UP));
            itemAccountFlow.setBusinessType(UdcEnum.ACCOUNT_FLOW_BUSINESS_TYPE_OPERATION.getValueCode());
            itemAccountFlow.setTOuCode(accountParam.getOperationFeeOuCode());
            itemAccountFlow.setFlowNo(seqNumProvider.generateCode(Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
            creditAccountFlowParamList.add(itemAccountFlow);
            addFlag = true;
        }
        return addFlag;
    }

    @Override
    public Boolean checkCreditAccountBalance(CreditAccountFlowParam param) {
        //参数检查
        checkGenerateCreditAccountFlowParam(param);

        CreditAccountFlowParam creditAccountFlowParam = CreditAccountFlowConvert.INSTANCE.copyParam(param);

        //组装财务域udc
        buildCreditAccountFlowParam(creditAccountFlowParam);

        //获取账户信息
        CreditAccountDO creditAccountDO = getCreditAccountMsg(creditAccountFlowParam);

        //幂等
        checkIdempotent(creditAccountDO,creditAccountFlowParam);

        //获取账户规则
        List<CreditAccountRuleConfigPageVO> creditAccountRuleConfigPageVOList = getCreditAccountRuleMsg(creditAccountDO, creditAccountFlowParam);

        //获取账户事务码
        List<CreditAccountIocDTO> creditAccountIocDTOList = getAccountIocMsg(creditAccountRuleConfigPageVOList);

        //根据优先级排序
        creditAccountRuleConfigPageVOList = creditAccountRuleConfigPageVOList.stream()
                .sorted(Comparator.comparing(CreditAccountRuleConfigPageVO::getPriorityNo))
                .collect(Collectors.toList());

        //校验账户余额
        checkCreditAccountLimit(creditAccountRuleConfigPageVOList, creditAccountDO, creditAccountFlowParam, creditAccountIocDTOList);

        return true;
    }

    private void buildCreditAccountFlowParam(CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowParam.setSourceDocType(creditAccountFlowParam.getSourceDoc()
                .concat(FinConstant.UNDERLINE)
                .concat(creditAccountFlowParam.getSourceDocType()));

        creditAccountFlowParam.setSourceDocStatus(creditAccountFlowParam.getSourceDoc()
                .concat(FinConstant.UNDERLINE)
                .concat(creditAccountFlowParam.getSourceDocStatus()));
    }

    private void checkCreditAccountLimit(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList,
                                         CreditAccountDO creditAccountDO,
                                         CreditAccountFlowParam creditAccountFlowParam,
                                         List<CreditAccountIocDTO> accountIocDTOList) {

        accountRuleConfigPageVOList.stream().forEach(item -> {
            //交易类型
            CreditAccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode()
                    .equals(item.getIoCode()))
                    .findFirst()
                    .orElse(null);

            Assert.notNull(accountIocDTO, "没有查询到启用的信用账户事务");

            if (UdcEnum.CREDIT_IO_TYPE_T.getValueCode().equals(accountIocDTO.getIoType())) {
                Assert.isTrue(creditAccountDO.getCreditAccountAvailableLimit().compareTo(creditAccountFlowParam.getSourceDocAmount()
                        .multiply(item.getCalculatePercent())
                        .divide(ONE_HUNDRED_BIGDECIMAL)) >= 0, "信用账户可用余额不足");
            }
        });
    }

    private void checkIdempotent(CreditAccountDO creditAccountDO,CreditAccountFlowParam creditAccountFlowParam) {
        creditAccountFlowParam.setCreditAccountType(creditAccountDO.getCreditAccountType());

        Assert.isTrue(CollectionUtils.isEmpty(creditAccountFlowRepoProc.queryCreditAccountFlowVO(creditAccountFlowParam)),
                "订单已经生成过流水");
    }

    private List<CreditAccountIocDTO> getAccountIocMsg(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        Set<String> ioCodeSet = new HashSet<>();
        accountRuleConfigPageVOList.stream().forEach(item -> ioCodeSet.add(item.getIoCode()));

        CreditAccountIocParam accountIocParam = new CreditAccountIocParam();
        accountIocParam.setIoCodeSet(ioCodeSet);
        accountIocParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountIocDTO> accountIocDTOList = creditAccountIocService.queryByAccountIocParam(accountIocParam);
        Assert.notEmpty(accountIocDTOList, "查询账户事务码失败");
        return accountIocDTOList;
    }
    private List<CreditAccountIocDTO> getAccountIocMsgWithRedis(List<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        Set<String> ioCodeSet = new HashSet<>();
        accountRuleConfigPageVOList.stream().forEach(item -> ioCodeSet.add(item.getIoCode()));
        CreditAccountIocParam accountIocParam = new CreditAccountIocParam();
        accountIocParam.setSize(Integer.MAX_VALUE);
        //accountIocParam.setIoCodeSet(ioCodeSet);
        accountIocParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<CreditAccountIocDTO> accountIocDTOList=myRedisService.getListDataFromRedis(FinRedisConstant.CREDIT_ACCOUNT_IOC,CreditAccountIocDTO.class,"信用事务码配置",()->{
            return creditAccountIocService.queryByAccountIocParam(accountIocParam);});
        if(!CollectionUtils.isEmpty(accountIocDTOList)){
            accountIocDTOList = accountIocDTOList.stream().filter(v->ioCodeSet.contains(v.getIoCode())).collect(Collectors.toList());
        }
        Assert.notEmpty(accountIocDTOList, "查询账户事务码失败");
        return accountIocDTOList;
    }

    public CreditAccountFlowParam buildCreditAccountFlowParam(CreditAccountFlowParam creditAccountFlowParam,
                                                              CreditAccountDO creditAccountDO,
                                                              List<CreditAccountIocDTO> accountIocDTOList,
                                                              CreditAccountRuleConfigPageVO accountRuleConfigPageVO, Integer amtRound) {

        CreditAccountFlowParam result = new CreditAccountFlowParam();
        //公司编码
        result.setOuCode(creditAccountFlowParam.getOuCode());
        result.setTOuCode(creditAccountFlowParam.getTOuCode());
        //公司名称
        result.setOuName(creditAccountDO.getOuName());
        //对象编码
        result.setObjectCode(creditAccountDO.getObjectCode());
        //对象名称
        result.setObjectName(creditAccountDO.getObjectName());
        //对象类型
        result.setObjectType(creditAccountDO.getObjectType());
        //流水号
//        result.setFlowNo(seqNumProvider.generateCode(Application.NAME, FinConstant.ACCOUNT_FLOW_NO, Collections.emptyList()));
        //交易类型
        CreditAccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode()
                .equals(accountRuleConfigPageVO.getIoCode()))
                .findFirst()
                .orElse(null);

        Assert.notNull(accountIocDTO, "没有查询到启用的账户事务");

        result.setTransactionType(accountIocDTO.getIoType());

        //发生金额
        result.setAmount(creditAccountFlowParam.getSourceDocAmount()
                .multiply(accountRuleConfigPageVO.getCalculatePercent())
                .divide(ONE_HUNDRED_BIGDECIMAL, amtRound, RoundingMode.HALF_UP));

        //交易日期
        result.setTransactionTime(LocalDateTime.now());
        //账户类型
        result.setCreditAccountType(creditAccountDO.getCreditAccountType());
        //账户编码
        result.setCreditAccountCode(creditAccountDO.getCreditAccountCode());
        //账户名称
        result.setCreditAccountName(creditAccountDO.getCreditAccountName());
        //来源单据
        result.setSourceDoc(creditAccountFlowParam.getSourceDoc());
        //来源单号
        result.setSourceNo(creditAccountFlowParam.getSourceNo());
        //来源单据id
        result.setSourceId(creditAccountFlowParam.getSourceId());

        //规则编码
        result.setCreditAccountRuleCode(accountRuleConfigPageVO.getRuleCode());
        //规则优先级
        result.setPriorityNo(accountRuleConfigPageVO.getPriorityNo());

        //单据状态
        result.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());

        //适用单据状态
        result.setSourceDocStatus(creditAccountFlowParam.getSourceDocStatus());

        result.setAutomaticReview(accountRuleConfigPageVO.isAutomaticReview());

        result.setCreditAccountLimit(creditAccountDO.getCreditAccountLimit());

        result.setCreditAccountUsedLimit(creditAccountDO.getCreditAccountUsedLimit());

        result.setCreditAccountOccupancyLimit(creditAccountDO.getCreditAccountOccupancyLimit());

        result.setCreditAccountAvailableLimit(creditAccountDO.getCreditAccountAvailableLimit());
        result.setExtensionInfo(creditAccountFlowParam.getExtensionInfo());
        result.setItemFeeOuCode(creditAccountFlowParam.getItemFeeOuCode());
        result.setMarketingFeeOuCode(creditAccountFlowParam.getMarketingFeeOuCode());
        result.setTechFeeOuCode(creditAccountFlowParam.getTechFeeOuCode());
        result.setOperationFeeOuCode(creditAccountFlowParam.getOperationFeeOuCode());
        result.setRootDoc(creditAccountFlowParam.getRootDoc());
        result.setRootDocNo(creditAccountFlowParam.getRootDocNo());

        return result;
    }

    private List<CreditAccountRuleConfigPageVO> getCreditAccountRuleMsg(CreditAccountDO creditAccountDO, CreditAccountFlowParam creditAccountFlowParam) {
        CreditAccountRuleConfigQueryParam accountRuleConfigQueryParam = new CreditAccountRuleConfigQueryParam();

        //适用单据
        accountRuleConfigQueryParam.setOptDoc(creditAccountFlowParam.getSourceDoc());
        //适用单据类型
        accountRuleConfigQueryParam.setOptDocType(creditAccountFlowParam.getSourceDocType());
        //适用单据状态
        accountRuleConfigQueryParam.setOptDocStatus(creditAccountFlowParam.getSourceDocStatus());
        //适用账户类型
        accountRuleConfigQueryParam.setOptAccountType(creditAccountDO.getCreditAccountType());
        //指定账户
        accountRuleConfigQueryParam.setSpecificAccount(creditAccountDO.getCreditAccountCode());
        accountRuleConfigQueryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());

        accountRuleConfigQueryParam.setSize(Constants.PAGE_SIZE);
        PagingVO<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = creditAccountRuleConfigService.searchPageWhihoutName(accountRuleConfigQueryParam);

        Assert.notEmpty(accountRuleConfigPageVOPagingVO.getRecords(), "没有匹配到信用账户规则");
        return accountRuleConfigPageVOPagingVO.getRecords();

    }
    private List<CreditAccountRuleConfigPageVO> getCreditAccountRuleMsgWithRedis(CreditAccountDO creditAccountDO, CreditAccountFlowParam creditAccountFlowParam) {
        CreditAccountRuleConfigQueryParam accountRuleConfigQueryParam = new CreditAccountRuleConfigQueryParam();
        //适用单据
      /*  accountRuleConfigQueryParam.setOptDoc(creditAccountFlowParam.getSourceDoc());
        //适用单据类型
        accountRuleConfigQueryParam.setOptDocType(creditAccountFlowParam.getSourceDocType());
        //适用单据状态
        accountRuleConfigQueryParam.setOptDocStatus(creditAccountFlowParam.getSourceDocStatus());
        //适用账户类型
        accountRuleConfigQueryParam.setOptAccountType(creditAccountDO.getCreditAccountType());
        //指定账户
        accountRuleConfigQueryParam.setSpecificAccount(creditAccountDO.getCreditAccountCode());*/
        accountRuleConfigQueryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        accountRuleConfigQueryParam.setSize(Constants.PAGE_SIZE);
        List<CreditAccountRuleConfigPageVO> creditAccountRuleConfigPageVOList = myRedisService.getListDataFromRedis(FinRedisConstant.CREDIT_ACCOUNT_RULE_CONFIG, CreditAccountRuleConfigPageVO.class, "信用账户规则配置", () -> {
            PagingVO<CreditAccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = creditAccountRuleConfigService.searchPageWhihoutName(accountRuleConfigQueryParam);

            if (accountRuleConfigPageVOPagingVO == null || CollectionUtils.isEmpty(accountRuleConfigPageVOPagingVO.getRecords())) {
                return null;
            }
            return accountRuleConfigPageVOPagingVO.getRecords();
        });
        if (!CollectionUtils.isEmpty(creditAccountRuleConfigPageVOList)) {
            creditAccountRuleConfigPageVOList = creditAccountRuleConfigPageVOList.stream().filter(
                    v -> {
                        if (StringUtils.isNotEmpty(creditAccountFlowParam.getSourceDoc())) {
                            if (!creditAccountFlowParam.getSourceDoc().equals(v.getOptDoc())) {
                                return false;
                            }
                        }
                        if (StringUtils.isNotEmpty(creditAccountFlowParam.getSourceDocType())) {
                            if (!creditAccountFlowParam.getSourceDocType().equals(v.getOptDocType())) {
                                return false;
                            }
                        }
                        if (StringUtils.isNotEmpty(creditAccountFlowParam.getSourceDocStatus())) {
                            if (!creditAccountFlowParam.getSourceDocStatus().equals(v.getOptDocStatus())) {
                                return false;
                            }
                        }
                        if (StringUtils.isNotEmpty(creditAccountDO.getCreditAccountType())) {
                            if (!creditAccountDO.getCreditAccountType().equals(v.getOptAccountType())) {
                                return false;
                            }
                        }
                        if (StringUtils.isNotEmpty(creditAccountDO.getCreditAccountCode())) {
                            if (v.getSpecificAccount() == null) {
                                return true;
                            }
                            if (!creditAccountDO.getCreditAccountCode().equals(v.getSpecificAccount())) {
                                return false;
                            }
                        }
                        return true;
                    }).collect(Collectors.toList());
        }
        if (creditAccountFlowParam.getSkipError() == null || !creditAccountFlowParam.getSkipError()) {
            Assert.notEmpty(creditAccountRuleConfigPageVOList, "没有匹配到信用账户规则");
        }
        return creditAccountRuleConfigPageVOList;
    }
    private CreditAccountDO getCreditAccountMsg(CreditAccountFlowParam creditAccountFlowParam) {
        return creditAccountRepoProc.findByCreditAccountCode(creditAccountFlowParam.getCreditAccountCode());
    }

    private void checkGenerateCreditAccountFlowParam(CreditAccountFlowParam creditAccountFlowParam) {
        Assert.notNull(creditAccountFlowParam, "参数不能为空");

        Assert.notEmpty(creditAccountFlowParam.getSourceDoc(), "来源单据不能为空");
        Assert.notEmpty(creditAccountFlowParam.getSourceDocType(), "来源单据类型不能为空");
        Assert.notEmpty(creditAccountFlowParam.getSourceDocStatus(), "来源单据状态不能为空");
        Assert.notNull(creditAccountFlowParam.getSourceDocAmount(), "来源单据金额不能为空");
        Assert.notNull(creditAccountFlowParam.getSourceId(), "来源单据id不能为空");
        Assert.notEmpty(creditAccountFlowParam.getSourceNo(), "来源单号不能为空");
        Assert.notEmpty(creditAccountFlowParam.getCreditAccountCode(), "信用账户编码不能为空");
    }

    @Override
    @SysCodeProc
    public List<CreditAccountFlowVO> selectListByQueryParam(CreditAccountFlowParam queryParam) {
        List<CreditAccountFlowVO> flowVOList = creditAccountFlowRepoProc.selectListByQueryParam(queryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountFlowVO> selectRepairAfterPage(CreditAccountFlowPageParam pageParam) {
        List<CreditAccountFlowVO> flowVOList = creditAccountFlowRepoProc.selectRepairAfterPage(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<CreditAccountFlowVO> selectRepairAfter(CreditAccountFlowParam pageParam) {
        List<CreditAccountFlowVO> flowVOList = creditAccountFlowRepoProc.selectRepairAfter(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagBatch(List<Long> ids){
        //发生金额为0的增加删除功能
        List<CreditAccountFlowDO> flowDOList = creditAccountFlowRepo.findAllById(ids);
        if (CollectionUtil.isNotEmpty(flowDOList)){
            List<CreditAccountFlowDO> flowFilterList = flowDOList.stream().filter(flowDO -> deleteCheckAmount(flowDO.getAmount())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(flowFilterList)){
                String checkResult = flowFilterList.stream().map(vo ->
                        "流水号:" + vo.getFlowNo() + ""
                ).collect(Collectors.joining(";", "只有发生金额为0的可删除,[", "], 请检查"));
                throw new com.elitescloud.boot.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
            }
        }
       /* flowDOList.forEach(flowDO -> {
            flowDO.setDeleteFlag(1);
        });
        creditAccountFlowRepo.saveAllAndFlush(flowDOList);*/

        creditAccountFlowRepoProc.updateDeleteFlagBatch(1,ids);
    }

    private Boolean deleteCheckAmount(BigDecimal amount){
        if (Objects.isNull(amount) || amount.compareTo(BigDecimal.ZERO) == 0){
            return false;
        }

        return true;
    }
}
