package com.elitesland.fin.application.web.invoice;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRuleConfigSaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRuleConfigVO;
import com.elitesland.fin.application.service.invoice.InvoiceRuleConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/11
 */
@RestController
@RequestMapping("/invoice/rule/config")
@Api(value = "开票规则配置", tags = {"开票规则配置"})
@AllArgsConstructor
public class InvoiceRuleConfigController {

    private final InvoiceRuleConfigService invoiceRuleConfigService;

    @PostMapping("/page")
    @ApiOperation("开票规则配置-分页")
    public ApiResult<PagingVO<InvoiceRuleConfigVO>> page(@RequestBody InvoiceRuleConfigQueryParam param) {
        PagingVO<InvoiceRuleConfigVO> page = invoiceRuleConfigService.page(param);
        return ApiResult.ok(page);
    }

    @PostMapping("/detail/{masId}")
    @ApiOperation("开票规则配置-详情")
    public ApiResult<InvoiceRuleConfigVO> detail(@PathVariable("masId") Long masId) {
        val result = invoiceRuleConfigService.detail(masId);
        return ApiResult.ok(result);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation("开票规则配置-保存/更新")
    public ApiResult<Long> save(@RequestBody InvoiceRuleConfigSaveParam param) {

        return ApiResult.ok(invoiceRuleConfigService.saveOrUpdate(param));
    }


    @GetMapping("/del/{masId}")
    @ApiOperation("开票规则配置-删除")
    public ApiResult<Void> del(@PathVariable("masId") Long masId) {
        invoiceRuleConfigService.delById(masId);
        return ApiResult.ok();
    }

}
