package com.elitesland.fin.application.facade.vo.invoice;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("开票主体")
public class InvoiceCustVO implements Serializable {

    @ApiModelProperty("开票主体ID")
    private Long id;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxNo;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty(value = "发票类型中文")
    private String invTypeName;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票银行名称")
    private String invBankName;

    @ApiModelProperty(value = "开票银行支行")
    private String invBankBranch;

    @ApiModelProperty(value = "开票银行账号")
    private String invBankAcc;

    @ApiModelProperty("联系人")
    private String invContact;

    @ApiModelProperty(name = "联系电话")
    private String invTel;

    @ApiModelProperty(name = "邮箱")
    private String invEmail;

    @ApiModelProperty(name = "启用状态：1启用；0禁用；")
    private String enabled;

    @ApiModelProperty(name = "客户编码")
    private String custCode;

    @ApiModelProperty(name = "客户名称")
    private String custName;

    @ApiModelProperty("合同开始时间")
    private String es1;

    @ApiModelProperty("是否是通用客商 1-是 0-不是")
    private String es3;

}
