package com.elitesland.fin.application.service.account;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountStorageFollowReq;
import com.elitesland.fin.application.facade.param.account.AccountStorageParam;
import com.elitesland.fin.application.facade.param.account.AccountStorageSaveParam;
import com.elitesland.fin.application.facade.vo.account.AccountStorageVO;

import java.util.List;

/**
 * @author sunxw
 * @description 账户储值service
 * @Date 2023/5/18
 */
public interface AccountStorageService {

    /**
     * 分页
     * @param params
     * @return
     */
    PagingVO<AccountStorageVO> page(AccountStorageParam params);

    /**
     * 获取当前加盟商的账户储值列表
     * @param param
     * @return
     */
    List<AccountStorageVO> list(AccountStorageParam param);

    /**
     * 储值订单新增
     * @param saveParams
     */
    AccountStorageVO save(AccountStorageSaveParam saveParams);

    /**
     * 后续类交易预留接口
     * @param followReq
     */
    void followPay(AccountStorageFollowReq followReq);

    /**
     * 根据id获取指定储值单
     * @param id
     * @return
     */
    AccountStorageVO single(Long id);
}
