package com.elitesland.fin.application.web.report;

import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.report.IpvRespVO;
import com.elitesland.fin.application.service.report.IpvCommonService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.domain.entity.report.IpvInvoiceDO;
import com.elitesland.fin.domain.param.report.IpvInvoiceComputeParam;
import com.elitesland.fin.domain.param.report.IpvInvoicePageParam;
import com.elitesland.fin.entity.account.AccountDO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@Api(tags = "报表接口")
@RestController
@RequestMapping(value = "/report", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_IPV_INVOICE, businessDoClass = IpvInvoiceDO.class)
public class ReportCommonController {

    private final IpvCommonService ipvCommonService;

    @ApiOperation(value = "IPV账单 - 分页查询")
    @PostMapping(value = "/ipv/page")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "IPV账单分页",
            businessObjectType = FinBusinessObjectConstant.FIN_IPV_INVOICE,operationCode = FinBusinessObjectConstant.FIN_IPV_INVOICE_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<IpvRespVO>> page(@RequestBody @Validated IpvInvoicePageParam paramVO) {
        log.info("[IPV] page  param ={}", JSONUtil.toJsonStr(paramVO));
        return ApiResult.ok(ipvCommonService.page(paramVO));
    }

    @ApiOperation(value = "IPV账单 - 计算")
    @PostMapping(value = "/ipv/compute")
    public ApiResult<Object> compute(@RequestBody IpvInvoiceComputeParam paramVO) {
        log.info("[IPV] compute param ={}", JSONUtil.toJsonStr(paramVO));
        ipvCommonService.compute(paramVO);
        return ApiResult.ok();
    }
}
