/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.account.AccountSnapshotVo;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.excel.entity.AccountSnapshotExportEntity;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountSnapshotExportServiceImpl
implements DataExport<AccountSnapshotExportEntity, AccountSnapshotParam> {
    private static final Logger log = LoggerFactory.getLogger(AccountSnapshotExportServiceImpl.class);
    private final AccountService accountService;

    public String getTmplCode() {
        return "fin_account_snapshot_export";
    }

    @BusinessObjectOperation(permissionRef="fin_account_snapshot_list", businessObjectType="Fin_Account:\u8d26\u6237", operationType=OperationTypeEnum.EXPORT, operationDescription="\u8d26\u6237\u5feb\u7167\u5bfc\u51fa", operationCode="fin_account_snapshot_export", dataPermissionEnabled=true, fieldPermissionAutoFilter=true)
    public PagingVO<AccountSnapshotExportEntity> executeExport(AccountSnapshotParam queryParam) {
        PagingVO<AccountSnapshotVo> pagingVO = this.accountService.querySnapshot(queryParam);
        return new PagingVO(pagingVO.getTotal(), ExcelConvertUtils.convertLoosely(pagingVO.getRecords(), AccountSnapshotExportEntity.class));
    }

    public AccountSnapshotExportServiceImpl(AccountService accountService) {
        this.accountService = accountService;
    }
}

