/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.payment;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.payment.PaymentRuleConfigConvert;
import com.elitesland.fin.application.convert.payment.PaymentRuleConfigDtlConvert;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDTO;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.facade.param.payment.PaymentRuleConfigParam;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigDtlVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.payment.PaymentRuleConfigQueryVO;
import com.elitesland.fin.application.service.payment.PaymentRuleConfigService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.payment.PaymentRuleConfigDomainService;
import com.elitesland.fin.domain.service.payment.PaymentRuleConfigDtlDomainService;
import com.elitesland.fin.entity.payment.PaymentRuleConfigDO;
import com.elitesland.fin.entity.payment.PaymentRuleConfigDtlDO;
import com.elitesland.fin.repo.payment.PaymentRuleConfigDtlRepo;
import com.elitesland.fin.repo.payment.PaymentRuleConfigRepo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
public class PaymentRuleConfigServiceImpl
implements PaymentRuleConfigService {
    private static final Logger log = LoggerFactory.getLogger(PaymentRuleConfigServiceImpl.class);
    private final PaymentRuleConfigDomainService paymentRuleConfigDomainService;
    private final PaymentRuleConfigDtlDomainService paymentRuleConfigDtlDomainService;
    private final RedissonClient redissonClient;
    private final PaymentRuleConfigRepo paymentRuleConfigRepo;
    private final PaymentRuleConfigDtlRepo paymentRuleConfigDtlRepo;
    private final UdcProvider udcProvider;
    private final RedisUtils redisUtils;

    @Override
    @SysCodeProc
    public PagingVO<PaymentRuleConfigPageVO> searchPage(PaymentRuleConfigParam param) {
        PagingVO<PaymentRuleConfigPageVO> paymentRuleConfigPageVOPagingVO = this.paymentRuleConfigDomainService.searchPage(param);
        this.pageCode2Name(paymentRuleConfigPageVOPagingVO.getRecords());
        return paymentRuleConfigPageVOPagingVO;
    }

    @Override
    public Optional<PaymentRuleConfigQueryVO> byRuleCode(String ruleCode) {
        List<PaymentRuleConfigQueryVO> paymentRuleConfigQueryVOList = this.paymentRuleConfigDomainService.findRuleConfigByRuleCode(ruleCode);
        if (CollUtil.isEmpty(paymentRuleConfigQueryVOList)) {
            return Optional.empty();
        }
        return Optional.of(paymentRuleConfigQueryVOList.get(0));
    }

    @Override
    public List<PaymentRuleConfigDtlDTO> dtlsByRuleCode(String ruleCode) {
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigQueryVOList = this.paymentRuleConfigDomainService.queryPaymentRuleConfigDtlByRuleCode(ruleCode);
        if (CollUtil.isEmpty(paymentRuleConfigQueryVOList)) {
            return new ArrayList<PaymentRuleConfigDtlDTO>();
        }
        return paymentRuleConfigQueryVOList;
    }

    @Override
    public void saveOrUpdate(PaymentRuleConfigParam param) {
        this.validateSaveOrUpdateParam(param);
        this.persistence(param);
        this.redisUtils.del(new String[]{"YST_FIN_PAYMENT_RULE_CONFIG"});
    }

    private void persistence(PaymentRuleConfigParam param) {
        this.checkRepeatData(param);
        this.checkExist(param);
        if (param.getId() == null) {
            this.saveConfigAndDtl(param);
            return;
        }
        this.updateConfigAndDtl(param);
    }

    private void checkExist(PaymentRuleConfigParam param) {
        List<PaymentRuleConfigDO> paymentRuleConfigDOList = this.paymentRuleConfigRepo.findAllByRuleCode(param.getRuleCode());
        if (CollectionUtils.isNotEmpty(paymentRuleConfigDOList)) {
            Assert.isTrue((paymentRuleConfigDOList.size() == 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u591a\u6761\u76f8\u540c\u7684\u89c4\u5219\u7f16\u7801", (Object[])new Object[0]);
            Assert.equals((Object)paymentRuleConfigDOList.get(0).getId(), (Object)param.getId(), (String)"\u89c4\u5219\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
        if (CollectionUtils.isNotEmpty(paymentRuleConfigDOList = this.paymentRuleConfigRepo.findAllByOptDoc(param.getOptDoc()))) {
            Assert.isTrue((paymentRuleConfigDOList.size() == 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u591a\u6761\u76f8\u540c\u7684\u9002\u7528\u5355\u636e", (Object[])new Object[0]);
            Assert.equals((Object)paymentRuleConfigDOList.get(0).getId(), (Object)param.getId(), (String)"\u9002\u7528\u5355\u636e\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    private void checkRepeatData(PaymentRuleConfigParam param) {
        HashMap seq = new HashMap();
        param.getPaymentRuleConfigDtlDTOList().stream().forEach(item -> {
            Assert.isNull(seq.get(item.getPriorityNo()), (String)"\u4f18\u5148\u7ea7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            seq.put(item.getPriorityNo(), "");
        });
        HashSet repeatSet = new HashSet();
        param.getPaymentRuleConfigDtlDTOList().stream().forEach(item -> Arrays.stream(item.getOptDocType().split("\\+")).forEach(optDocType -> {
            String uniqueKey = optDocType.concat(item.getOptDocStatus()).concat(item.getOptAccountType());
            Assert.isFalse((boolean)repeatSet.contains(uniqueKey), (String)"\u5b58\u5728\u91cd\u590d\u89c4\u5219,\u6263\u6b3e\u5355\u636e\u7c7b\u578b\u3001\u6263\u6b3e\u5355\u636e\u72b6\u6001\u3001\u8d26\u6237\u7c7b\u578b\u9700\u552f\u4e00", (Object[])new Object[0]);
            repeatSet.add(uniqueKey);
        }));
        repeatSet.stream().forEach(item -> repeatSet.stream().forEach(item1 -> {
            if (item.contains((CharSequence)item1) && !StringUtils.equals((CharSequence)item, (CharSequence)item1)) {
                Assert.isTrue((boolean)false, (String)"\u5b58\u5728\u91cd\u590d\u89c4\u5219,\u6263\u6b3e\u5355\u636e\u7c7b\u578b\u3001\u6263\u6b3e\u5355\u636e\u72b6\u6001\u3001\u8d26\u6237\u7c7b\u578b\u9700\u552f\u4e00", (Object[])new Object[0]);
            }
        }));
    }

    private void updateConfigAndDtl(PaymentRuleConfigParam param) {
        PaymentRuleConfigDO paymentRuleConfigDO = PaymentRuleConfigConvert.INSTANCE.param2DO(param);
        List<PaymentRuleConfigDtlDO> paymentRuleConfigDtlDOS = PaymentRuleConfigDtlConvert.INSTANCE.param2DOList(param.getPaymentRuleConfigDtlDTOList());
        paymentRuleConfigDtlDOS.stream().forEach(dtl -> dtl.setMasId(paymentRuleConfigDO.getId()));
        this.paymentRuleConfigDomainService.updateDynamically(paymentRuleConfigDO);
        this.paymentRuleConfigDtlDomainService.deleteByParam(this.getQueryBeanByMasId(paymentRuleConfigDO.getId()));
        this.paymentRuleConfigDtlDomainService.saveAll(paymentRuleConfigDtlDOS);
    }

    private Long saveConfigAndDtl(PaymentRuleConfigParam param) {
        PaymentRuleConfigDO paymentRuleConfigDO = PaymentRuleConfigConvert.INSTANCE.param2DO(param);
        List<PaymentRuleConfigDtlDO> paymentRuleConfigDtlDOS = PaymentRuleConfigDtlConvert.INSTANCE.param2DOList(param.getPaymentRuleConfigDtlDTOList());
        this.paymentRuleConfigRepo.save(paymentRuleConfigDO);
        paymentRuleConfigDtlDOS.forEach(dtl -> dtl.setMasId(paymentRuleConfigDO.getId()));
        this.paymentRuleConfigDtlRepo.saveAll(paymentRuleConfigDtlDOS);
        return paymentRuleConfigDO.getId();
    }

    private void validateSaveOrUpdateParam(PaymentRuleConfigParam param) {
        Assert.notEmpty((CharSequence)param.getRuleCode(), (String)"\u8d26\u6237\u89c4\u5219\u7f16\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getRuleName(), (String)"\u8d26\u6237\u89c4\u5219\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getOptDoc(), (String)"\u6263\u6b3e\u5355\u636e\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getStatus(), (String)"\u542f\u7528\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty(param.getPaymentRuleConfigDtlDTOList(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        param.getPaymentRuleConfigDtlDTOList().stream().forEach(item -> {
            Assert.notNull((Object)item.getPriorityNo(), (String)"\u4f18\u5148\u7ea7\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getOptDocType(), (String)"\u6263\u6b3e\u5355\u636e\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getOptDocStatus(), (String)"\u6263\u6b3e\u5355\u636e\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getOptAccountType(), (String)"\u6263\u6b3e\u8d26\u6237\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        });
    }

    @Override
    public void del(Long id) {
        Optional<PaymentRuleConfigDO> paymentRuleConfigDOOptional = this.paymentRuleConfigDomainService.findById(id);
        if (paymentRuleConfigDOOptional.isPresent()) {
            PaymentRuleConfigDO dbSceneConfig = paymentRuleConfigDOOptional.get();
            this.paymentRuleConfigDtlDomainService.deleteByCondition(this.getQueryBeanByMasId(id));
            this.paymentRuleConfigDomainService.deleteById(id);
            this.removeCache(dbSceneConfig.getRuleCode());
            this.redisUtils.del(new String[]{"YST_FIN_PAYMENT_RULE_CONFIG"});
        }
    }

    private PaymentRuleConfigDtlDO getQueryBeanByMasId(Long id) {
        PaymentRuleConfigDtlDO whereBean = new PaymentRuleConfigDtlDO();
        whereBean.setMasId(id);
        return whereBean;
    }

    @Override
    @SysCodeProc
    public PaymentRuleConfigQueryVO detail(Long masId) {
        Optional dbConfig = this.paymentRuleConfigRepo.findById(masId);
        if (!dbConfig.isPresent()) {
            return null;
        }
        PaymentRuleConfigQueryVO queryVO = PaymentRuleConfigConvert.INSTANCE.do2VO((PaymentRuleConfigDO)dbConfig.get());
        List<PaymentRuleConfigDtlDO> all = this.paymentRuleConfigDtlDomainService.findPaymentRuleConfigDtlByMasId(masId);
        List<PaymentRuleConfigDtlVO> paymentRuleConfigDtlVoList = PaymentRuleConfigDtlConvert.INSTANCE.do2VOList(all);
        this.detailCode2Name(paymentRuleConfigDtlVoList);
        queryVO.setPaymentRuleConfigDtlVoList(paymentRuleConfigDtlVoList);
        return queryVO;
    }

    public void detailCode2Name(List<PaymentRuleConfigDtlVO> paymentRuleConfigDtlVOList) {
        Map docClsUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_CLS_SO_C.getModel(), UdcEnum.DOC_CLS_SO_C.getCode());
        Map docStatusUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_STATUS_RSO_CL.getModel(), UdcEnum.DOC_STATUS_RSO_CL.getCode());
        Map accountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Map creditAccountTypeUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());
        ArrayList optDocTypeList = new ArrayList();
        paymentRuleConfigDtlVOList.stream().forEach(item -> {
            optDocTypeList.clear();
            String[] optDocTypeArray = item.getOptDocType().split("\\+");
            Arrays.stream(optDocTypeArray).forEach(optDocType -> optDocTypeList.add((String)docClsUdc.get(optDocType)));
            item.setOptDocTypeName(this.joinedWithPlus(optDocTypeList));
            item.setOptDocStatusName((String)docStatusUdc.get(item.getOptDocStatus()));
            String type = item.getOptAccountType();
            if (accountTypeUdc.get(type) != null) {
                item.setOptAccountTypeName((String)accountTypeUdc.get(type));
                return;
            }
            item.setOptAccountTypeName((String)creditAccountTypeUdc.get(type));
        });
    }

    public void pageCode2Name(List<PaymentRuleConfigPageVO> paymentRuleConfigPageVOList) {
        Map docClsUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_CLS_SO_C.getModel(), UdcEnum.DOC_CLS_SO_C.getCode());
        Map docStatusUdc = this.udcProvider.getValueMapByUdcCode(UdcEnum.DOC_STATUS_RSO_CL.getModel(), UdcEnum.DOC_STATUS_RSO_CL.getCode());
        ArrayList optDocTypeList = new ArrayList();
        paymentRuleConfigPageVOList.stream().forEach(item -> {
            optDocTypeList.clear();
            String[] optDocTypeArray = item.getOptDocType().split("\\+");
            Arrays.stream(optDocTypeArray).forEach(optDocType -> optDocTypeList.add((String)docClsUdc.get(optDocType)));
            item.setOptDocTypeName(this.joinedWithPlus(optDocTypeList));
            item.setOptDocStatusName((String)docStatusUdc.get(item.getOptDocStatus()));
        });
    }

    private String joinedWithPlus(List<String> param) {
        return StringUtils.join(param, (String)"+");
    }

    private void removeCache(String ruleCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_RULE_CONFIG_KEY_" + ruleCode);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public PaymentRuleConfigDTO getByRuleCode(String ruleCode) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_RULE_CONFIG_KEY_" + ruleCode);
        if (bucket.isExists()) {
            return (PaymentRuleConfigDTO)bucket.get();
        }
        PaymentRuleConfigDTO dbConfig = this.paymentRuleConfigDomainService.findByRuleCode(ruleCode);
        if (dbConfig != null) {
            Example dtlExample = Example.of((Object)this.getQueryBeanByMasId(dbConfig.getId()));
            List<PaymentRuleConfigDtlDO> all = this.paymentRuleConfigDtlDomainService.findAll(dtlExample);
            List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtls = PaymentRuleConfigDtlConvert.INSTANCE.do2DTOList(all);
            dbConfig.setPaymentRuleConfigDtlDTOList(paymentRuleConfigDtls);
            bucket.set((Object)dbConfig);
            return dbConfig;
        }
        return null;
    }

    @Override
    public List<PaymentRuleConfigDtlDTO> queryAccountAmount(PaymentRuleConfigParam param) {
        return this.paymentRuleConfigDomainService.queryAccountAmount(param);
    }

    @Override
    public List<PaymentRuleConfigDtlDTO> pay(PaymentRuleConfigParam param) {
        return this.paymentRuleConfigDomainService.pay(param);
    }

    public PaymentRuleConfigServiceImpl(PaymentRuleConfigDomainService paymentRuleConfigDomainService, PaymentRuleConfigDtlDomainService paymentRuleConfigDtlDomainService, RedissonClient redissonClient, PaymentRuleConfigRepo paymentRuleConfigRepo, PaymentRuleConfigDtlRepo paymentRuleConfigDtlRepo, UdcProvider udcProvider, RedisUtils redisUtils) {
        this.paymentRuleConfigDomainService = paymentRuleConfigDomainService;
        this.paymentRuleConfigDtlDomainService = paymentRuleConfigDtlDomainService;
        this.redissonClient = redissonClient;
        this.paymentRuleConfigRepo = paymentRuleConfigRepo;
        this.paymentRuleConfigDtlRepo = paymentRuleConfigDtlRepo;
        this.udcProvider = udcProvider;
        this.redisUtils = redisUtils;
    }
}

