/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.AccountFlow;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.service.AccountFlow.AccountFlowDomainService;
import com.elitesland.fin.domain.service.account.AccountDomainService;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.flow.AccountFlowRepo;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class AccountFlowDomainServiceImpl
implements AccountFlowDomainService {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowDomainServiceImpl.class);
    private FlexFieldUtilService flexFieldUtilService;
    private AccountFlowRepo accountFlowRepo;
    private AccountRepoProc accountRepoProc;
    private AccountDomainService accountDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AccountFlowDO saveAccountFlow(AccountFlowParam accountFlowParam) {
        this.checkMandatoryField(accountFlowParam);
        AccountFlowDO accountFlowDO = AccountFlowConvert.INSTANCE.paramToDo(accountFlowParam);
        this.flexFieldUtilService.handFlexFieldValueFeference("ACCOUNT_FLOW", (Object)accountFlowDO);
        return (AccountFlowDO)((Object)this.accountFlowRepo.save((Object)accountFlowDO));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAccountBalanceAndGenerateAccountFlow(List<AccountFlowParam> accountFlowParamList) {
        accountFlowParamList.stream().forEach(item -> {
            AccountVO newAccountVO;
            AccountFlowParam accountFlowParam = item;
            AccountVO oldAccountVO = this.accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals((Object)oldAccountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                    throw new BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                }
            } else if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateAddAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new BusinessException("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateSubtractAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new BusinessException("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountDomainService.updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new BusinessException("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else {
                throw new BusinessException("\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            if ((newAccountVO = this.accountRepoProc.get(oldAccountVO.getId())) == null) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
                throw new BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
            }
            accountFlowParam.setAccountAmount(newAccountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(newAccountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(newAccountVO.getAccountAvailableAmount());
            SysUserDTO user = this.getUser();
            accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            accountFlowParam.setAuditDate(LocalDateTime.now());
            accountFlowParam.setAuditUserName("SYSTEM");
            if (user != null) {
                accountFlowParam.setAuditUserId(user.getId());
                accountFlowParam.setAuditUserName(user.getLastName());
            }
            TransactionStatus transactionStatus1 = TransactionAspectSupport.currentTransactionStatus();
            AccountFlowDO accountFlowDO = this.saveAccountFlow(accountFlowParam);
            TransactionStatus transactionStatus2 = TransactionAspectSupport.currentTransactionStatus();
            accountFlowParam.setId(accountFlowDO.getId());
        });
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }

    private void checkMandatoryField(AccountFlowParam param) {
        if (StringUtils.isBlank((CharSequence)param.getAccountType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceDoc())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u636e\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceNo())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getTransactionType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getAmount())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u53d1\u751f\u91d1\u989d\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getTransactionTime())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccountCode())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccountName())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a!");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAccountFlowList(List<AccountFlowParam> accountFlowParams) {
        accountFlowParams.stream().forEach(v -> {
            AccountFlowDO accountFlowDO = this.saveAccountFlow((AccountFlowParam)((Object)v));
            v.setId(accountFlowDO.getId());
        });
    }

    public AccountFlowDomainServiceImpl(FlexFieldUtilService flexFieldUtilService, AccountFlowRepo accountFlowRepo, AccountRepoProc accountRepoProc, AccountDomainService accountDomainService) {
        this.flexFieldUtilService = flexFieldUtilService;
        this.accountFlowRepo = accountFlowRepo;
        this.accountRepoProc = accountRepoProc;
        this.accountDomainService = accountDomainService;
    }
}

