/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.aporder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementVO;
import com.elitesland.fin.domain.entity.aporder.ApOrderDtlDO;
import com.elitesland.fin.domain.param.aporder.ApOrderDtlPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDtlDomainService;
import com.elitesland.fin.domain.service.paymentperiod.ReceiptPaymentAgreementDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDtlDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepo;
import com.elitesland.fin.infr.repo.aporder.ApOrderDtlRepoProc;
import com.elitesland.fin.utils.BigDecimalUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApOrderDtlDomainServiceImpl
implements ApOrderDtlDomainService {
    private static final Logger log = LoggerFactory.getLogger(ApOrderDtlDomainServiceImpl.class);
    private final ApOrderDtlRepoProc apOrderDtlRepoProc;
    private final ApOrderDtlRepo apOrderDtlRepo;
    private final ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService;

    @Override
    public PagingVO<ApOrderDtlDTO> page(ApOrderDtlPageParam apOrderDtlPageParam) {
        PagingVO<ApOrderDtlDTO> pagingVO = this.apOrderDtlRepoProc.page(apOrderDtlPageParam);
        List apOrderDtlDTOList = pagingVO.getRecords();
        if (CollectionUtil.isEmpty((Collection)apOrderDtlDTOList)) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<String> dtlProtocolCodeList = apOrderDtlDTOList.stream().map(ApOrderDtlDTO::getProtocolCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, ReceiptPaymentAgreementVO> agreementMap = this.receiptPaymentAgreementDomainService.selectPaymentAgreementByCodes(dtlProtocolCodeList);
        this.handleApOrderDtlDTO(apOrderDtlDTOList, agreementMap);
        return PagingVO.builder().total(pagingVO.getTotal()).records(apOrderDtlDTOList).build();
    }

    private void handleApOrderDtlDTO(List<ApOrderDtlDTO> apOrderDtlDOS, Map<String, ReceiptPaymentAgreementVO> agreementMap) {
        if (CollectionUtil.isNotEmpty(apOrderDtlDOS)) {
            apOrderDtlDOS.forEach(apOrderDtlDTO -> {
                ReceiptPaymentAgreementVO agreementVO;
                if (MapUtil.isNotEmpty((Map)agreementMap) && agreementMap.containsKey(apOrderDtlDTO.getProtocolCode()) && Objects.nonNull(agreementVO = (ReceiptPaymentAgreementVO)agreementMap.get(apOrderDtlDTO.getProtocolCode()))) {
                    apOrderDtlDTO.setProtocolName(agreementVO.getProtocolName());
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        Long res = this.apOrderDtlRepoProc.del(ids);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Map<Long, BigDecimal> apDIdVerAmtMap, List<Long> apDIds) {
        List<ApOrderDtlDO> allByIdsIn = this.apOrderDtlRepoProc.findAllByIdsIn(apDIds);
        allByIdsIn.forEach(k -> {
            Long orderDtlId = k.getId();
            if (apDIdVerAmtMap.containsKey(orderDtlId)) {
                BigDecimal thisAmt = (BigDecimal)apDIdVerAmtMap.get(orderDtlId);
                k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).add(BigDecimalUtil.getUnify(thisAmt)));
                k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
            }
        });
        this.apOrderDtlRepo.saveAll(allByIdsIn);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resortVerAmt(Map<Long, BigDecimal> apDIdVerAmtMap, List<Long> apDIds) {
        List<ApOrderDtlDO> allByIdsIn = this.apOrderDtlRepoProc.findAllByIdsIn(apDIds);
        log.info("ap\u5f85\u56de\u5199\u6570\u636e1:{}", (Object)JSONUtil.toJsonStr(allByIdsIn));
        allByIdsIn.forEach(k -> {
            Long orderDtlId = k.getId();
            if (apDIdVerAmtMap.containsKey(orderDtlId)) {
                BigDecimal thisAmt = (BigDecimal)apDIdVerAmtMap.get(orderDtlId);
                k.setApplyVerAmTing(BigDecimalUtil.getUnify(k.getApplyVerAmTing()).subtract(BigDecimalUtil.getUnify(thisAmt)));
                k.setUnVerAmt(BigDecimalUtil.getUnify(k.getTotalAmt()).subtract(BigDecimalUtil.getUnify(k.getVerAmt())).subtract(BigDecimalUtil.getUnify(k.getApplyVerAmTing())));
            }
        });
        log.info("ap\u5f85\u56de\u5199\u6570\u636e2:{}", (Object)JSONUtil.toJsonStr(allByIdsIn));
        this.apOrderDtlRepo.saveAll(allByIdsIn);
    }

    public ApOrderDtlDomainServiceImpl(ApOrderDtlRepoProc apOrderDtlRepoProc, ApOrderDtlRepo apOrderDtlRepo, ReceiptPaymentAgreementDomainService receiptPaymentAgreementDomainService) {
        this.apOrderDtlRepoProc = apOrderDtlRepoProc;
        this.apOrderDtlRepo = apOrderDtlRepo;
        this.receiptPaymentAgreementDomainService = receiptPaymentAgreementDomainService;
    }
}

