/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.factory.saleinv;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvDtlDO;
import com.elitesland.fin.domain.entity.saleinv.QSaleInvdDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.param.saleinv.SaleInvAppPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvAppDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvSumDTO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SaleInvFactory {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSaleInvDO qSaleInvDO = QSaleInvDO.saleInvDO;
    private final QSaleInvDtlDO qSaleInvDtlDO = QSaleInvDtlDO.saleInvDtlDO;
    private final QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;

    public PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam) {
        Predicate customFieldPredicate;
        Boolean filter = this.filterDetails(saleInvPageParam);
        if (filter.booleanValue()) {
            return PagingVO.builder().total(0L).records(List.of()).build();
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.buildPredicates(saleInvPageParam, predicates);
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getIds())) {
            predicates.add((Predicate)this.qSaleInvDO.id.in(saleInvPageParam.getIds()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)saleInvPageParam.getConditions(), SaleInvDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleInvDTO.class, (Expression[])new Expression[]{this.qSaleInvDO.id, this.qSaleInvDO.createTime, this.qSaleInvDO.updater, this.qSaleInvDO.modifyTime, this.qSaleInvDO.creator, this.qSaleInvDO.remark, this.qSaleInvDO.sourceSysNo, this.qSaleInvDO.applyNo, this.qSaleInvDO.ouCode, this.qSaleInvDO.ouId, this.qSaleInvDO.ouName, this.qSaleInvDO.taxRate, this.qSaleInvDO.invRegNo, this.qSaleInvDO.currCode, this.qSaleInvDO.currName, this.qSaleInvDO.localCurrCode, this.qSaleInvDO.localCurrName, this.qSaleInvDO.totalAmt, this.qSaleInvDO.totalCurAmt, this.qSaleInvDO.saleInvTitle, this.qSaleInvDO.saleTaxNo, this.qSaleInvDO.saleTel, this.qSaleInvDO.saleAdd, this.qSaleInvDO.saleBank, this.qSaleInvDO.saleBankAcc, this.qSaleInvDO.saleRemark, this.qSaleInvDO.saleId, this.qSaleInvDO.saleName, this.qSaleInvDO.saleCode, this.qSaleInvDO.custInvTitle, this.qSaleInvDO.custTaxNo, this.qSaleInvDO.custAdd, this.qSaleInvDO.custTel, this.qSaleInvDO.custBank, this.qSaleInvDO.custBankAcc, this.qSaleInvDO.custRemark, this.qSaleInvDO.custId, this.qSaleInvDO.custName, this.qSaleInvDO.custCode, this.qSaleInvDO.invUser, this.qSaleInvDO.recUser, this.qSaleInvDO.revUser, this.qSaleInvDO.auditUserId, this.qSaleInvDO.pushMethod, this.qSaleInvDO.phone, this.qSaleInvDO.email, this.qSaleInvDO.infoNo, this.qSaleInvDO.expressNo, this.qSaleInvDO.invState, this.qSaleInvDO.auditUser, this.qSaleInvDO.auditDate, this.qSaleInvDO.orderState, this.qSaleInvDO.exchangeRate, this.qSaleInvDO.auditRejection, this.qSaleInvDO.createMode, this.qSaleInvDO.invType, this.qSaleInvDO.invMerge, this.qSaleInvDO.invEmail, this.qSaleInvDO.invPicName, this.qSaleInvDO.invPicPhone, this.qSaleInvDO.mainCustCode, this.qSaleInvDO.mainCustId, this.qSaleInvDO.mainCustName, this.qSaleInvDO.settlementType, this.qSaleInvDO.pkGroup, this.qSaleInvDO.openInvType, this.qSaleInvDO.invCustCode, this.qSaleInvDO.invCustId, this.qSaleInvDO.invCustName, this.qSaleInvDO.drawDate, this.qSaleInvDO.redPunchDate, this.qSaleInvDO.docType3, this.qSaleInvDO.recvContactName, this.qSaleInvDO.recvContactTel, this.qSaleInvDO.extensionInfo})).from((EntityPath)this.qSaleInvDO)).where(ExpressionUtils.allOf(predicates));
        BusinessSecurityUtil.where(query, SaleInvDO.class);
        saleInvPageParam.setPaging(query);
        saleInvPageParam.fillOrders(query, this.qSaleInvDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public SaleInvSumDTO selectListSum(SaleInvPageParam saleInvPageParam) {
        Boolean filter = this.filterDetails(saleInvPageParam);
        if (filter.booleanValue()) {
            return new SaleInvSumDTO();
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.buildPredicates(saleInvPageParam, predicates);
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getIds())) {
            predicates.add((Predicate)this.qSaleInvDO.id.in(saleInvPageParam.getIds()));
        }
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleInvSumDTO.class, (Expression[])new Expression[]{this.qSaleInvDO.totalAmt.sum().as("totalSumAmt")})).from((EntityPath)this.qSaleInvDO)).where(ExpressionUtils.allOf(predicates));
        return (SaleInvSumDTO)query.fetchOne();
    }

    private void buildPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {
        if (StrUtil.isNotBlank((CharSequence)saleInvPageParam.getMainCustCode())) {
            predicates.add((Predicate)this.qSaleInvDO.mainCustCode.eq((Object)saleInvPageParam.getMainCustCode()));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getMainCustCodeList())) {
            predicates.add((Predicate)this.qSaleInvDO.mainCustCode.in(saleInvPageParam.getMainCustCodeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)saleInvPageParam.getMainCustName())) {
            predicates.add((Predicate)this.qSaleInvDO.mainCustName.like("%" + saleInvPageParam.getMainCustName() + "%"));
        }
        if (ObjectUtil.isNotNull((Object)saleInvPageParam.getMainCustId())) {
            predicates.add((Predicate)this.qSaleInvDO.mainCustId.eq((Object)saleInvPageParam.getMainCustId()));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getMainCustIdList())) {
            predicates.add((Predicate)this.qSaleInvDO.mainCustId.in(saleInvPageParam.getMainCustIdList()));
        }
        if (null != saleInvPageParam.getOuId()) {
            predicates.add((Predicate)this.qSaleInvDO.ouId.eq((Object)saleInvPageParam.getOuId()));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getCreateMode())) {
            predicates.add((Predicate)this.qSaleInvDO.createMode.eq((Object)saleInvPageParam.getCreateMode()));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getCreateModeList())) {
            predicates.add((Predicate)this.qSaleInvDO.createMode.in(saleInvPageParam.getCreateModeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getApplyNo())) {
            predicates.add((Predicate)this.qSaleInvDO.applyNo.like("%" + saleInvPageParam.getApplyNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getSourceSysNo())) {
            predicates.add((Predicate)this.qSaleInvDO.sourceSysNo.eq((Object)saleInvPageParam.getSourceSysNo()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getCustName())) {
            predicates.add((Predicate)this.qSaleInvDO.custName.like("%" + saleInvPageParam.getCustName() + "%"));
        }
        if (null != saleInvPageParam.getCustId()) {
            predicates.add((Predicate)this.qSaleInvDO.custId.eq((Object)saleInvPageParam.getCustId()));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getCustIdList())) {
            predicates.add((Predicate)this.qSaleInvDO.custId.in(saleInvPageParam.getCustIdList()));
        }
        if (null != saleInvPageParam.getCustCode()) {
            predicates.add((Predicate)this.qSaleInvDO.custCode.eq((Object)saleInvPageParam.getCustCode()));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getCustCodeList())) {
            predicates.add((Predicate)this.qSaleInvDO.custCode.in(saleInvPageParam.getCustCodeList()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInvType())) {
            predicates.add((Predicate)this.qSaleInvDO.invType.eq((Object)saleInvPageParam.getInvType()));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getInvTypeList())) {
            predicates.add((Predicate)this.qSaleInvDO.invType.in(saleInvPageParam.getInvTypeList()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getInfoNo())) {
            predicates.add((Predicate)this.qSaleInvDO.infoNo.like("%" + saleInvPageParam.getInfoNo() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getExpressNo())) {
            predicates.add((Predicate)this.qSaleInvDO.expressNo.like("%" + saleInvPageParam.getExpressNo() + "%"));
        }
        if (null != saleInvPageParam.getTotalAmtStart()) {
            predicates.add((Predicate)this.qSaleInvDO.totalAmt.goe((Number)saleInvPageParam.getTotalAmtStart()));
        }
        if (null != saleInvPageParam.getTotalAmtEnd()) {
            predicates.add((Predicate)this.qSaleInvDO.totalAmt.loe((Number)saleInvPageParam.getTotalAmtEnd()));
        }
        if (StringUtils.isNotEmpty((CharSequence)saleInvPageParam.getCustCode())) {
            predicates.add((Predicate)this.qSaleInvDO.custCode.eq((Object)saleInvPageParam.getCustCode()));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getCustCodeList())) {
            predicates.add((Predicate)this.qSaleInvDO.custCode.in(saleInvPageParam.getCustCodeList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)saleInvPageParam.getDocType3())) {
            predicates.add((Predicate)this.qSaleInvDO.docType3.eq((Object)saleInvPageParam.getDocType3()));
        }
        if (StringUtils.isNotEmpty((CharSequence)saleInvPageParam.getInvState())) {
            String orderState = StrUtil.equals((CharSequence)saleInvPageParam.getInvState(), (CharSequence)UdcEnum.INV_STATE_SUCCESS.getValueCode()) ? UdcEnum.APPLY_STATUS_INV_SUCCESS.getValueCode() : (StrUtil.equals((CharSequence)saleInvPageParam.getInvState(), (CharSequence)UdcEnum.INV_STATE_FAIL.getValueCode()) ? UdcEnum.APPLY_STATUS_INV_FAIL.getValueCode() : saleInvPageParam.getInvState());
            predicates.add((Predicate)this.qSaleInvDO.orderState.eq((Object)orderState));
        }
        if (CollectionUtils.isNotEmpty(saleInvPageParam.getInvStateList())) {
            predicates.add((Predicate)this.qSaleInvDO.orderState.in(saleInvPageParam.getInvStateList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)saleInvPageParam.getOrderState())) {
            predicates.add((Predicate)this.qSaleInvDO.orderState.eq((Object)saleInvPageParam.getOrderState()));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getRecvContactName())) {
            predicates.add((Predicate)this.qSaleInvDO.recvContactName.like("%" + saleInvPageParam.getRecvContactName() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getRecvContactTel())) {
            predicates.add((Predicate)this.qSaleInvDO.recvContactTel.like("%" + saleInvPageParam.getRecvContactTel() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)saleInvPageParam.getCreator())) {
            predicates.add((Predicate)this.qSaleInvDO.creator.like("%" + saleInvPageParam.getCreator() + "%"));
        }
        predicates.add((Predicate)this.qSaleInvDO.deleteFlag.eq((Object)0));
    }

    public Boolean filterDetails(SaleInvPageParam saleInvPageParam) {
        List masIds;
        ArrayList<Predicate> ddtlPredicates = new ArrayList<Predicate>();
        ArrayList<Predicate> dtlPredicates = new ArrayList<Predicate>();
        List ids = new ArrayList();
        this.buildDDtlPredicates(saleInvPageParam, ddtlPredicates);
        if (CollectionUtils.isNotEmpty(ddtlPredicates)) {
            masIds = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.qSaleInvdDtlDO.masId).from((EntityPath)this.qSaleInvdDtlDO)).where(ExpressionUtils.allOf(ddtlPredicates))).fetch();
            if (CollectionUtils.isEmpty((Collection)masIds)) {
                return Boolean.TRUE;
            }
            ids = masIds;
        }
        this.buildDtlPredicates(saleInvPageParam, dtlPredicates);
        if (CollectionUtils.isNotEmpty(ids)) {
            dtlPredicates.add((Predicate)this.qSaleInvDtlDO.masId.in(ids));
        }
        if (CollectionUtils.isNotEmpty(dtlPredicates)) {
            masIds = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct(this.qSaleInvDtlDO.masId).from((EntityPath)this.qSaleInvDtlDO)).where(ExpressionUtils.allOf(dtlPredicates))).fetch();
            if (CollectionUtils.isEmpty((Collection)masIds)) {
                return Boolean.TRUE;
            }
            ids = masIds;
        }
        masIds = ids.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
        saleInvPageParam.setIds(masIds);
        return Boolean.FALSE;
    }

    private void buildDtlPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {
        if (CharSequenceUtil.isNotBlank((CharSequence)saleInvPageParam.getSourceNo())) {
            predicates.add((Predicate)this.qSaleInvDtlDO.sourceNo.like("%" + saleInvPageParam.getSourceNo() + "%"));
        }
    }

    private void buildDDtlPredicates(SaleInvPageParam saleInvPageParam, List<Predicate> predicates) {
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getInvNo())) {
            predicates.add((Predicate)this.qSaleInvdDtlDO.invNo.like("%" + saleInvPageParam.getInvNo() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)saleInvPageParam.getBlueInvNo())) {
            predicates.add((Predicate)this.qSaleInvdDtlDO.blueInvNo.like("%" + saleInvPageParam.getBlueInvNo() + "%"));
        }
        if (null != saleInvPageParam.getInvDateStart() && null != saleInvPageParam.getInvDateEnd()) {
            predicates.add((Predicate)this.qSaleInvdDtlDO.invDate.between((Comparable)saleInvPageParam.getInvDateStart(), (Comparable)saleInvPageParam.getInvDateEnd()));
        }
    }

    public PagingVO<SaleInvAppDTO> appPage(SaleInvAppPageParam param) {
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(SaleInvAppDTO.class, (Expression[])new Expression[]{this.qSaleInvDO.id, this.qSaleInvDO.applyNo, this.qSaleInvDO.invType, this.qSaleInvDO.recApplyTime, this.qSaleInvDO.totalAmt, this.qSaleInvDO.orderState, this.qSaleInvDO.createTime})).from((EntityPath)this.qSaleInvDO)).leftJoin((EntityPath)this.qSaleInvDtlDO)).on((Predicate)this.qSaleInvDtlDO.masId.eq(this.qSaleInvDO.id))).where(ExpressionUtils.allOf(this.appWhere(param)))).orderBy(this.qSaleInvDO.modifyTime.desc());
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private List<Predicate> appWhere(SaleInvAppPageParam param) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StrUtil.isNotBlank((CharSequence)param.getRootDocNo())) {
            predicates.add((Predicate)this.qSaleInvDtlDO.rootDocNo.eq((Object)param.getRootDocNo()));
        }
        if (param.getRootDocTimeFrom() != null) {
            predicates.add((Predicate)this.qSaleInvDtlDO.rootDocTime.goe((Comparable)param.getRootDocTimeFrom()));
        }
        if (param.getRootDocTimeTo() != null) {
            predicates.add((Predicate)this.qSaleInvDtlDO.rootDocTime.loe((Comparable)param.getRootDocTimeTo()));
        }
        if (CollectionUtils.isNotEmpty(param.getRootDocTypeList())) {
            predicates.add((Predicate)this.qSaleInvDtlDO.rootDocType.in(param.getRootDocTypeList()));
        }
        if (param.getRecApplyTimeFrom() != null) {
            predicates.add((Predicate)this.qSaleInvDO.recApplyTime.goe((Comparable)param.getRecApplyTimeFrom()));
        }
        if (param.getRecApplyTimeTo() != null) {
            predicates.add((Predicate)this.qSaleInvDO.recApplyTime.loe((Comparable)param.getRecApplyTimeTo()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getStoreCode())) {
            predicates.add((Predicate)this.qSaleInvDO.mainCustCode.eq((Object)param.getStoreCode()));
        }
        if (CollectionUtils.isNotEmpty(param.getOrderStateList())) {
            List<String> distinctOrderStates = SaleInvFactory.appStatsTrans(param);
            predicates.add((Predicate)this.qSaleInvDO.orderState.in(distinctOrderStates));
        }
        predicates.add((Predicate)this.qSaleInvDO.deleteFlag.eq((Object)0));
        return predicates;
    }

    @NotNull
    private static List<String> appStatsTrans(SaleInvAppPageParam param) {
        ArrayList<String> resultOrderStates = new ArrayList<String>();
        String appStatusComplete = UdcEnum.APP_INV_STATUS_COMPLETE.getValueCode();
        String appStatusInvoicing = UdcEnum.APP_INV_STATUS_INVOICING.getValueCode();
        String appStatusFail = UdcEnum.APP_INV_STATUS_FAIL.getValueCode();
        String stateSuccess = UdcEnum.INV_STATE_SUCCESS.getValueCode();
        String stateWait = UdcEnum.INV_STATE_WAIT.getValueCode();
        String stateIng = UdcEnum.INV_STATE_ING.getValueCode();
        for (String orderState : param.getOrderStateList()) {
            if (appStatusComplete.equals(orderState)) {
                resultOrderStates.add(UdcEnum.INVOICE_STATUS_SUCCESS.getValueCode());
                continue;
            }
            if (appStatusInvoicing.equals(orderState)) {
                resultOrderStates.add(UdcEnum.INVOICE_STATUS_DRAFT.getValueCode());
                resultOrderStates.add(UdcEnum.INVOICE_STATUS_INVOICING.getValueCode());
                continue;
            }
            if (appStatusFail.equals(orderState)) {
                resultOrderStates.add(UdcEnum.INVOICE_STATUS_APPLY_FAIL.getValueCode());
                resultOrderStates.add(UdcEnum.INVOICE_STATUS_FAIL.getValueCode());
                continue;
            }
            resultOrderStates.add(orderState);
        }
        return resultOrderStates.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public SaleInvAppDTO appFindById(Long id) {
        QSaleInvdDtlDO qSaleInvdDtlDO = QSaleInvdDtlDO.saleInvdDtlDO;
        return (SaleInvAppDTO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleInvAppDTO.class, (Expression[])new Expression[]{this.qSaleInvDO.id, this.qSaleInvDO.applyNo, this.qSaleInvDO.invType, this.qSaleInvDO.createTime, this.qSaleInvDO.recApplyTime, this.qSaleInvDO.totalAmt, this.qSaleInvDO.orderState, this.qSaleInvDO.invTitleType, this.qSaleInvDO.invType, this.qSaleInvDO.invPicPhone, this.qSaleInvDO.invPicName, this.qSaleInvDO.invEmail, this.qSaleInvDO.custTaxNo, this.qSaleInvDO.custBank, this.qSaleInvDO.custBankAcc, this.qSaleInvDO.custAdd, this.qSaleInvDO.custInvTitle, this.qSaleInvDO.ouId, this.qSaleInvDO.ouCode, this.qSaleInvDO.ouName, qSaleInvdDtlDO.invPdfUrl, qSaleInvdDtlDO.invNo, qSaleInvdDtlDO.invCode, qSaleInvdDtlDO.invDate, qSaleInvdDtlDO.masId, qSaleInvdDtlDO.flowNo, qSaleInvdDtlDO.checkCode, qSaleInvdDtlDO.blueInvCode, qSaleInvdDtlDO.blueInvNo, qSaleInvdDtlDO.redState, qSaleInvdDtlDO.invState, qSaleInvdDtlDO.invFailCause, qSaleInvdDtlDO.invoiceRedraftState, qSaleInvdDtlDO.totalAmt})).from((EntityPath)this.qSaleInvDO)).leftJoin((EntityPath)qSaleInvdDtlDO)).on((Predicate)this.qSaleInvDO.id.eq(qSaleInvdDtlDO.masId))).where((Predicate)this.qSaleInvDO.id.eq((Object)id))).where((Predicate)this.qSaleInvDO.deleteFlag.eq((Object)0).or((Predicate)this.qSaleInvDO.deleteFlag.isNull()))).fetchOne();
    }

    public SaleInvFactory(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

