/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.creditaccountflow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowPageParam;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.saobei.param.SaoBeiTransParam;
import com.elitesland.fin.application.facade.vo.creditaccountflow.CreditAccountFlowVO;
import com.elitesland.fin.application.facade.vo.saobei.SaoBeiTransVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import com.elitesland.fin.entity.creditaccountflow.QCreditAccountFlowDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.fin.utils.PartitionJpaUtil;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class CreditAccountFlowRepoProc
extends BaseRepoProc<CreditAccountFlowDO> {
    private static final QCreditAccountFlowDO qCreditAccountFlowDO = QCreditAccountFlowDO.creditAccountFlowDO;

    public CreditAccountFlowRepoProc() {
        super((EntityPathBase)qCreditAccountFlowDO);
    }

    public PagingVO<CreditAccountFlowDTO> page(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.where(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowDTO.class).where(ExpressionUtils.allOf(where));
        BusinessSecurityUtil.where(query, CreditAccountFlowDO.class);
        PartitionJpaUtil.appendYmConditionToPredicate(query, CreditAccountFlowDO.class, creditAccountFlowPageParam);
        creditAccountFlowPageParam.setPaging(query);
        creditAccountFlowPageParam.fillOrders(query, qCreditAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public CreditAccountFlowVO selectByAccCode(String accCode) {
        return (CreditAccountFlowVO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.select(CreditAccountFlowVO.class).where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.eq((Object)accCode))).where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.deleteFlag.eq((Object)0).or((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.deleteFlag.isNull()))).orderBy(CreditAccountFlowRepoProc.qCreditAccountFlowDO.createTime.desc())).fetchFirst());
    }

    public List<CreditAccountFlowVO> selectListByParam(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.where(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowPageParam.getObjectName())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.objectName.like(StringUtil.buildLikeString(creditAccountFlowPageParam.getObjectName())));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getObjectNameList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.objectName.in(creditAccountFlowPageParam.getObjectNameList()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getObjectCodeList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.objectCode.in(creditAccountFlowPageParam.getObjectCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getCreditAccountName())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountName.like(StringUtil.buildLikeString(creditAccountFlowPageParam.getCreditAccountName())));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountNameList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountName.in(creditAccountFlowPageParam.getCreditAccountNameList()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountCodeList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.in(creditAccountFlowPageParam.getCreditAccountCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getCreditAccountCode())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.eq((Object)creditAccountFlowPageParam.getCreditAccountCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getTransactionType())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionType.eq((Object)creditAccountFlowPageParam.getTransactionType()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getTransactionTypeList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionType.in(creditAccountFlowPageParam.getTransactionTypeList()));
        }
        if (creditAccountFlowPageParam.getTransactionTimeS() != null) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionTime.goe((Comparable)creditAccountFlowPageParam.getTransactionTimeS()));
        }
        if (creditAccountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionTime.loe((Comparable)creditAccountFlowPageParam.getTransactionTimeE()));
        }
        if (creditAccountFlowPageParam.getAuditDateS() != null) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.goe((Comparable)creditAccountFlowPageParam.getAuditDateS()));
        }
        if (creditAccountFlowPageParam.getAuditDateE() != null) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.loe((Comparable)creditAccountFlowPageParam.getAuditDateE()));
        }
        if (creditAccountFlowPageParam.getAmountFrom() != null) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount.goe((Number)creditAccountFlowPageParam.getAmountFrom()));
        }
        if (creditAccountFlowPageParam.getAmountTo() != null) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount.loe((Number)creditAccountFlowPageParam.getAmountTo()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowPageParam.getCreditAccountType())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountType.eq((Object)creditAccountFlowPageParam.getCreditAccountType()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getCreditAccountTypeList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountType.in(creditAccountFlowPageParam.getCreditAccountTypeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowPageParam.getSourceNo())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo.like("%" + creditAccountFlowPageParam.getSourceNo() + "%"));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getSourceNoList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo.in(creditAccountFlowPageParam.getSourceNoList()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowPageParam.getFlowNo())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo.like("%" + creditAccountFlowPageParam.getFlowNo() + "%"));
        }
        if (CollectionUtil.isNotEmpty(creditAccountFlowPageParam.getSourceDocList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDoc.in(creditAccountFlowPageParam.getSourceDocList()));
        }
        if (CollectionUtils.isNotEmpty(creditAccountFlowPageParam.getIds())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.in(creditAccountFlowPageParam.getIds()));
        }
        if (StrUtil.isNotBlank((CharSequence)creditAccountFlowPageParam.getBusinessType())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.businessType.eq((Object)creditAccountFlowPageParam.getBusinessType()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getRelateFlowNo())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.relateFlowNo.eq((Object)creditAccountFlowPageParam.getRelateFlowNo()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getSyncStatus())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncStatus.eq((Object)creditAccountFlowPageParam.getSyncStatus()));
        }
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getSyncStatusList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncStatus.in(creditAccountFlowPageParam.getSyncStatusList()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getFromAccountNo())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.fromAccountNo.eq((Object)creditAccountFlowPageParam.getFromAccountNo()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getToAccountNo())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.toAccountNo.eq((Object)creditAccountFlowPageParam.getToAccountNo()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getFromOuCode())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.fromOuCode.eq((Object)creditAccountFlowPageParam.getFromOuCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getToOuCode())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.toOuCode.eq((Object)creditAccountFlowPageParam.getToOuCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getRootDoc())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.rootDoc.eq((Object)creditAccountFlowPageParam.getRootDoc()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getRootDocNo())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.rootDocNo.eq((Object)creditAccountFlowPageParam.getRootDocNo()));
        }
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getOptTypeList())) {
            ArrayList<String> sourceDocStatusList = new ArrayList<String>();
            if (creditAccountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_PAY.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_PAY);
            }
            if (creditAccountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_CLOSE.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_CLOSE);
            }
            if (creditAccountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_RETURN.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_RETURN);
            }
            if (creditAccountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_REFUND.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_REFUND);
            }
            if (creditAccountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_AO.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_AO_ALL);
            }
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDocStatus.in(sourceDocStatusList));
        }
        predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.fromAccountNo.isNotNull().and((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.toAccountNo.isNotNull()));
        Predicate customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)creditAccountFlowPageParam.getConditions(), CreditAccountFlowDO.class);
        if (customFieldPredicate != null) {
            predicates.add(customFieldPredicate);
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id, CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionType, CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount, CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionTime, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountName, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountType, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDoc, CreditAccountFlowRepoProc.qCreditAccountFlowDO.remark, CreditAccountFlowRepoProc.qCreditAccountFlowDO.createTime, CreditAccountFlowRepoProc.qCreditAccountFlowDO.createUserId, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creator, CreditAccountFlowRepoProc.qCreditAccountFlowDO.modifyTime, CreditAccountFlowRepoProc.qCreditAccountFlowDO.modifyUserId, CreditAccountFlowRepoProc.qCreditAccountFlowDO.updater, CreditAccountFlowRepoProc.qCreditAccountFlowDO.deleteFlag, CreditAccountFlowRepoProc.qCreditAccountFlowDO.ouCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountLimit, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountUsedLimit, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountOccupancyLimit, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditUserId, CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditUserName, CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate, CreditAccountFlowRepoProc.qCreditAccountFlowDO.orderState, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountRuleCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.priorityNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.ouName, CreditAccountFlowRepoProc.qCreditAccountFlowDO.objectCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.objectName, CreditAccountFlowRepoProc.qCreditAccountFlowDO.objectType, CreditAccountFlowRepoProc.qCreditAccountFlowDO.buCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.buName, CreditAccountFlowRepoProc.qCreditAccountFlowDO.saleUser, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceId, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDocStatus, CreditAccountFlowRepoProc.qCreditAccountFlowDO.extensionInfo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.businessType, CreditAccountFlowRepoProc.qCreditAccountFlowDO.tOuCode.as("touCode"), CreditAccountFlowRepoProc.qCreditAccountFlowDO.relateFlowNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncStatus, CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncLog, CreditAccountFlowRepoProc.qCreditAccountFlowDO.fromAccountNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.toAccountNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.fromOuCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.toOuCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.rootDoc, CreditAccountFlowRepoProc.qCreditAccountFlowDO.rootDocNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDocStatus})).from((EntityPath)qCreditAccountFlowDO);
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id, CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionType, CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount, CreditAccountFlowRepoProc.qCreditAccountFlowDO.transactionTime, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountName, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDoc})).from((EntityPath)qCreditAccountFlowDO);
    }

    public void approveAccountFlow(CreditAccountFlowParam creditAccountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set((Path)CreditAccountFlowRepoProc.qCreditAccountFlowDO.orderState, (Object)creditAccountFlowParam.getOrderState()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditUserId, (Object)creditAccountFlowParam.getAuditUserId()).set((Path)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditUserName, (Object)creditAccountFlowParam.getAuditUserName()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate, (Object)creditAccountFlowParam.getAuditDate()).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)creditAccountFlowParam.getId())}).execute();
    }

    public List<CreditAccountFlowVO> queryCreditAccountFlowVO(CreditAccountFlowParam creditAccountFlowParam) {
        JPAQuery<CreditAccountFlowVO> query = this.select(CreditAccountFlowVO.class);
        if (creditAccountFlowParam.getSourceId() != null) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceId.eq((Object)creditAccountFlowParam.getSourceId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDoc())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDoc.eq((Object)creditAccountFlowParam.getSourceDoc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceDocStatus())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDocStatus.eq((Object)creditAccountFlowParam.getSourceDocStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getCreditAccountType())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountType.eq((Object)creditAccountFlowParam.getCreditAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)creditAccountFlowParam.getSourceNo())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo.eq((Object)creditAccountFlowParam.getSourceNo()));
        }
        return query.fetch();
    }

    public void updateCreditAccountFlowAmount(CreditAccountFlowParam creditAccountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountFlowParam.getCreditAccountLimit()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountFlowParam.getCreditAccountUsedLimit()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountFlowParam.getCreditAccountOccupancyLimit()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountFlowParam.getCreditAccountAvailableLimit()).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.eq((Object)creditAccountFlowParam.getCreditAccountCode()).and((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.orderState.eq((Object)creditAccountFlowParam.getOrderState()))}).execute();
    }

    public void updateCreditAccountFlowAmountById(CreditAccountFlowParam creditAccountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountFlowParam.getCreditAccountLimit()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountFlowParam.getCreditAccountUsedLimit()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountFlowParam.getCreditAccountOccupancyLimit()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountFlowParam.getCreditAccountAvailableLimit()).set((Path)CreditAccountFlowRepoProc.qCreditAccountFlowDO.orderState, (Object)creditAccountFlowParam.getOrderState()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditUserId, (Object)creditAccountFlowParam.getAuditUserId()).set((Path)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditUserName, (Object)creditAccountFlowParam.getAuditUserName()).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate, (Object)creditAccountFlowParam.getAuditDate()).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)creditAccountFlowParam.getId()).and((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.orderState.eq((Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()))}).execute();
    }

    public List<CreditAccountFlowVO> selectListByQueryParam(CreditAccountFlowParam queryParam) {
        JPAQuery<CreditAccountFlowVO> query = this.select(CreditAccountFlowVO.class);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getSourceNo())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo.eq((Object)queryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getCreditAccountType())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountType.eq((Object)queryParam.getCreditAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getFlowNo())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo.eq((Object)queryParam.getFlowNo()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getFlowNoList())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo.in(queryParam.getFlowNoList()));
        }
        return query.fetch();
    }

    public CreditAccountFlowVO selectPreviousRepairAmtByParam(CreditAccountFlowParam flowQueryParam) {
        JPAQuery<CreditAccountFlowVO> query = this.select(CreditAccountFlowVO.class);
        if (!StringUtils.isEmpty((CharSequence)flowQueryParam.getCreditAccountCode())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.eq((Object)flowQueryParam.getCreditAccountCode()));
        }
        query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.isNotNull());
        return (CreditAccountFlowVO)((Object)((JPAQuery)query.orderBy(CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.desc())).fetchFirst());
    }

    public List<CreditAccountFlowVO> selectRepairAfterPage(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.selectRepairAfterPageWhere(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.desc());
        creditAccountFlowPageParam.setPaging(query);
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterPageWhere(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getFlowNoList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo.in(creditAccountFlowPageParam.getFlowNoList()));
        }
        if (Objects.nonNull(creditAccountFlowPageParam.getRepairTime())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.gt((Comparable)creditAccountFlowPageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)creditAccountFlowPageParam.getCreditAccountCode())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.eq((Object)creditAccountFlowPageParam.getCreditAccountCode()));
        }
        if (!CollectionUtils.isEmpty(creditAccountFlowPageParam.getCreditAccountCodeList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.in(creditAccountFlowPageParam.getCreditAccountCodeList()));
        }
        return predicates;
    }

    public List<CreditAccountFlowVO> selectRepairAfter(CreditAccountFlowParam flowPageParam) {
        List<Predicate> where = this.selectRepairAfterWhere(flowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.desc());
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterWhere(CreditAccountFlowParam pageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.auditDate.goe((Comparable)pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)pageParam.getCreditAccountCode())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.eq((Object)pageParam.getCreditAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getCreditAccountCodeList())) {
            predicates.add((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode.in(pageParam.getCreditAccountCodeList()));
        }
        return predicates;
    }

    public void updateOccupancyAndAvailableAndAmountById(BigDecimal creditAccountOccupancyLimit, BigDecimal creditAccountAvailableLimit, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountOccupancyLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount, (Object)amount).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableAndAmountById(BigDecimal creditAccountLimit, BigDecimal creditAccountAvailableLimit, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount, (Object)amount).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateUsedAndAvailableAndAmountById(BigDecimal creditAccountUsedLimit, BigDecimal creditAccountAvailableLimit, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountUsedLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount, (Object)amount).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateOccupancyAndAvailableById(BigDecimal creditAccountOccupancyLimit, BigDecimal creditAccountAvailableLimit, Long id) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountOccupancyLimit, (Object)creditAccountOccupancyLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableById(BigDecimal creditAccountLimit, BigDecimal creditAccountAvailableLimit, Long id) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountLimit, (Object)creditAccountLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateUsedAndAvailableById(BigDecimal creditAccountUsedLimit, BigDecimal creditAccountAvailableLimit, Long id) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountUsedLimit, (Object)creditAccountUsedLimit).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountAvailableLimit, (Object)creditAccountAvailableLimit).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public PagingVO<CreditAccountFlowDTO> appPage(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.where(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowDTO.class).where(ExpressionUtils.allOf(where));
        creditAccountFlowPageParam.setPaging(query);
        creditAccountFlowPageParam.fillOrders(query, qCreditAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<CreditAccountFlowDTO> appList(CreditAccountFlowPageParam creditAccountFlowPageParam) {
        List<Predicate> where = this.where(creditAccountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(CreditAccountFlowDTO.class).where(ExpressionUtils.allOf(where));
        creditAccountFlowPageParam.fillOrders(query, qCreditAccountFlowDO);
        return query.fetch();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set(CreditAccountFlowRepoProc.qCreditAccountFlowDO.deleteFlag, (Object)deleteFlag).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.in(ids)}).execute();
    }

    public List<CreditAccountFlowVO> findBySourceIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CreditAccountFlowVO.class, (Expression[])new Expression[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceId, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo})).from((EntityPath)qCreditAccountFlowDO)).where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceId.in(ids))).fetch();
    }

    private <T> JPAQuery<T> selectSaoBei(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id, CreditAccountFlowRepoProc.qCreditAccountFlowDO.flowNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.amount, CreditAccountFlowRepoProc.qCreditAccountFlowDO.creditAccountType.as("accountType"), CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDocStatus, CreditAccountFlowRepoProc.qCreditAccountFlowDO.relateFlowNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncStatus, CreditAccountFlowRepoProc.qCreditAccountFlowDO.fromAccountNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.toAccountNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.fromOuCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.toOuCode, CreditAccountFlowRepoProc.qCreditAccountFlowDO.rootDoc, CreditAccountFlowRepoProc.qCreditAccountFlowDO.rootDocNo, CreditAccountFlowRepoProc.qCreditAccountFlowDO.businessType, CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceNo})).from((EntityPath)qCreditAccountFlowDO);
    }

    public List<SaoBeiTransVO> selectSaoBeiTrans(SaoBeiTransParam param) {
        JPAQuery<SaoBeiTransVO> query = this.selectSaoBei(SaoBeiTransVO.class);
        if (CollectionUtils.isNotEmpty(param.getIds())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.in(param.getIds()));
        }
        if (CollectionUtils.isNotEmpty(param.getSourceDocStatusList())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.sourceDocStatus.in(param.getSourceDocStatusList()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSyncStatus())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncStatus.eq((Object)param.getSyncStatus()));
        }
        if (CollectionUtils.isNotEmpty(param.getSyncStatusList())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncStatus.in(param.getSyncStatusList()));
        }
        if (param.getCreateTimeFrom() != null) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.createTime.goe((Comparable)param.getCreateTimeFrom()));
        }
        if (param.getCreateTimeTo() != null) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.createTime.loe((Comparable)param.getCreateTimeTo()));
        }
        if (CollectionUtils.isNotEmpty(param.getRootDocNoList())) {
            query.where((Predicate)CreditAccountFlowRepoProc.qCreditAccountFlowDO.rootDocNo.in(param.getRootDocNoList()));
        }
        return query.fetch();
    }

    public void updateSaoBeiTransInfo(Long id, String relateFlowNo, String syncStatus, String syncLog) {
        this.jpaQueryFactory.update((EntityPath)qCreditAccountFlowDO).set((Path)CreditAccountFlowRepoProc.qCreditAccountFlowDO.relateFlowNo, (Object)relateFlowNo).set((Path)CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncStatus, (Object)syncStatus).set((Path)CreditAccountFlowRepoProc.qCreditAccountFlowDO.syncLog, (Object)syncLog).where(new Predicate[]{CreditAccountFlowRepoProc.qCreditAccountFlowDO.id.eq((Object)id)}).execute();
    }
}

