package com.elitesland.fin.application.convert.paymentperiod;

import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.domain.entity.paymentperiod.ReceiptPaymentAgreementDtlDO;
import com.elitesland.fin.infr.dto.paymentperiod.ReceiptPaymentAgreementDtlDTO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ReceiptPaymentAgreementDtlConvert {
    ReceiptPaymentAgreementDtlConvert INSTANCE = Mappers.getMapper(ReceiptPaymentAgreementDtlConvert.class);


    /**
     * saveVO转换DO
     *
     * @param saveVO 入参
     * @return DO
     */
    ReceiptPaymentAgreementDtlDO saveVoToDo(ReceiptPaymentAgreementDtlSaveParam saveVO);

    /**
     * DO转换RespVO
     *
     * @param dtlDO 入参
     * @return RespVO
     */
    ReceiptPaymentAgreementDtlVO doToRespVo(ReceiptPaymentAgreementDtlDO dtlDO);

    /**
     * DO转换DTO
     *
     * @param dtlDO 入参
     * @return DTO
     */
    ReceiptPaymentAgreementDtlDTO doToDto(ReceiptPaymentAgreementDtlDO dtlDO);

    /**
     * DTO转换RespVO
     *
     * @param dtlDTO 入参
     * @return RespVO
     */
    ReceiptPaymentAgreementDtlVO dtoToRespVo(ReceiptPaymentAgreementDtlDTO dtlDTO);
}
