/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.account;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountDTO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.param.account.AccountParam;
import com.elitesland.fin.application.facade.vo.account.AccountAmtSumVO;
import com.elitesland.fin.application.facade.vo.account.AccountOuVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.QAccountDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AccountRepoProc
extends BaseRepoProc<AccountDO> {
    private static final QAccountDO qAccountDO = QAccountDO.accountDO;
    @Autowired
    private AccountRepo accountRepo;

    public AccountRepoProc() {
        super((EntityPathBase)qAccountDO);
    }

    public PagingVO<AccountVO> page(AccountPageParam accountPageParam) {
        JPAQuery<AccountVO> query = this.buildJPAQuery(accountPageParam);
        BusinessSecurityUtil.where(query, AccountDO.class);
        accountPageParam.setPaging(query);
        accountPageParam.fillOrders(query, qAccountDO);
        List fetch = query.fetch();
        return PagingVO.builder().total(query.fetchCount()).records(fetch).build();
    }

    public List<AccountVO> queryList(AccountPageParam accountPageParam) {
        JPAQuery<AccountVO> query = this.buildJPAQuery(accountPageParam);
        return query.fetch();
    }

    public JPAQuery<AccountVO> buildJPAQuery(AccountPageParam accountPageParam) {
        Predicate customFieldPredicate;
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderName())) {
            predicates.add(AccountRepoProc.qAccountDO.accountHolderName.like("%" + accountPageParam.getAccountHolderName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountHolderNameList())) {
            predicates.add(AccountRepoProc.qAccountDO.accountHolderName.in(accountPageParam.getAccountHolderNameList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderCode())) {
            predicates.add(AccountRepoProc.qAccountDO.accountHolderCode.eq((Object)accountPageParam.getAccountHolderCode()));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountHolderCodeList())) {
            predicates.add(AccountRepoProc.qAccountDO.accountHolderCode.in(accountPageParam.getAccountHolderCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountName())) {
            predicates.add(AccountRepoProc.qAccountDO.accountName.like("%" + accountPageParam.getAccountName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountNameList())) {
            predicates.add(AccountRepoProc.qAccountDO.accountName.in(accountPageParam.getAccountNameList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountType())) {
            predicates.add(AccountRepoProc.qAccountDO.accountType.eq((Object)accountPageParam.getAccountType()));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountTypeList())) {
            predicates.add(AccountRepoProc.qAccountDO.accountType.in(accountPageParam.getAccountTypeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getState())) {
            predicates.add(AccountRepoProc.qAccountDO.state.eq((Object)accountPageParam.getState()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountCode())) {
            predicates.add(AccountRepoProc.qAccountDO.accountCode.like(StringUtil.buildLikeString(accountPageParam.getAccountCode())));
        }
        if (CollectionUtils.isNotEmpty(accountPageParam.getAccountCodeList())) {
            predicates.add(AccountRepoProc.qAccountDO.accountCode.in(accountPageParam.getAccountCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getSecOuCode())) {
            predicates.add(AccountRepoProc.qAccountDO.secOuCode.eq((Object)accountPageParam.getSecOuCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)accountPageParam.getAccountHolderNameCode())) {
            predicates.add(AccountRepoProc.qAccountDO.accountHolderName.like(StringUtil.buildLikeString(accountPageParam.getAccountHolderNameCode())).or((Predicate)AccountRepoProc.qAccountDO.accountHolderCode.like(StringUtil.buildLikeString(accountPageParam.getAccountHolderNameCode()))));
        }
        if (CollectionUtil.isNotEmpty(accountPageParam.getIds())) {
            predicates.add(AccountRepoProc.qAccountDO.id.in(accountPageParam.getIds()));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)accountPageParam.getConditions(), AccountDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        JPAQuery query = (JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates));
        return query;
    }

    public List<AccountVO> queryByAccounts(List<String> accounts, String type, String state) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)type)) {
            predicates.add(AccountRepoProc.qAccountDO.accountType.eq((Object)type));
        }
        if (!CollectionUtils.isEmpty(accounts)) {
            predicates.add(AccountRepoProc.qAccountDO.accountCode.in(accounts));
        }
        if (!StringUtils.isEmpty((CharSequence)state)) {
            predicates.add(AccountRepoProc.qAccountDO.state.eq((Object)state));
        }
        return ((JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public Boolean updateAmtByCode(AccountParam accountParam) {
        Long res = this.jpaQueryFactory.update((EntityPath)qAccountDO).set(AccountRepoProc.qAccountDO.accountAmount, (Object)accountParam.getAccAmt()).set(AccountRepoProc.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{AccountRepoProc.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AccountRepoProc.qAccountDO.id, AccountRepoProc.qAccountDO.accountName, AccountRepoProc.qAccountDO.accountCode, AccountRepoProc.qAccountDO.accountType, AccountRepoProc.qAccountDO.state, AccountRepoProc.qAccountDO.createTime, AccountRepoProc.qAccountDO.creator, AccountRepoProc.qAccountDO.accountOccupancyAmount, AccountRepoProc.qAccountDO.accountAmount.subtract(AccountRepoProc.qAccountDO.accountOccupancyAmount).as("accAvaAmt"), AccountRepoProc.qAccountDO.accountAmount, AccountRepoProc.qAccountDO.accountAvailableAmount, AccountRepoProc.qAccountDO.secOuCode, AccountRepoProc.qAccountDO.secOuName, AccountRepoProc.qAccountDO.secFranchiseeCode, AccountRepoProc.qAccountDO.accountHolderType, AccountRepoProc.qAccountDO.accountHolderName, AccountRepoProc.qAccountDO.accountHolderCode, AccountRepoProc.qAccountDO.remark, AccountRepoProc.qAccountDO.extensionInfo})).from((EntityPath)qAccountDO);
    }

    public Long updateState(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)qAccountDO).set((Path)AccountRepoProc.qAccountDO.state, (Object)accountParam.getState()).where(new Predicate[]{AccountRepoProc.qAccountDO.id.in(accountParam.getIds())}).execute();
        return res;
    }

    public AccountVO get(Long id) {
        AccountVO accountVO = (AccountVO)((Object)((JPAQuery)this.select(AccountVO.class).where((Predicate)AccountRepoProc.qAccountDO.id.eq((Object)id))).fetchOne());
        return accountVO;
    }

    public AccountVO getByCode(String accCode) {
        AccountVO res = (AccountVO)((Object)((JPAQuery)this.select(AccountVO.class).where((Predicate)AccountRepoProc.qAccountDO.accountCode.eq((Object)accCode))).fetchOne());
        return res;
    }

    public Boolean updateOccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)qAccountDO).set(AccountRepoProc.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccOccAmt()).where(new Predicate[]{AccountRepoProc.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public Boolean updateAccAmtByCode(AccountParam accountParam) {
        long res = this.jpaQueryFactory.update((EntityPath)qAccountDO).set(AccountRepoProc.qAccountDO.accountAmount, (Object)accountParam.getAccAmt()).where(new Predicate[]{AccountRepoProc.qAccountDO.accountCode.eq((Object)accountParam.getAccCode())}).execute();
        return res > 0L;
    }

    public void updateAccountAmountByAccountCode(AccountParam accountParam) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qAccountDO);
        if (accountParam.getAccountAmount() != null) {
            jpaUpdateClause.set(AccountRepoProc.qAccountDO.accountAmount, (Object)accountParam.getAccountAmount());
        }
        if (accountParam.getAccountOccupancyAmount() != null) {
            jpaUpdateClause.set(AccountRepoProc.qAccountDO.accountOccupancyAmount, (Object)accountParam.getAccountOccupancyAmount());
        }
        if (accountParam.getAccountAvailableAmount() != null) {
            jpaUpdateClause.set(AccountRepoProc.qAccountDO.accountAvailableAmount, (Object)accountParam.getAccountAvailableAmount());
        }
        jpaUpdateClause.where(new Predicate[]{AccountRepoProc.qAccountDO.accountCode.eq((Object)accountParam.getAccountCode())}).execute();
    }

    public List<AccountDTO> getAccountByAccountParam(AccountParam param) {
        JPAQuery<AccountDTO> accountVOJPAQuery = this.select(AccountDTO.class);
        if (CollectionUtils.isNotEmpty(param.getAccountCodes())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountCode.in(param.getAccountCodes()));
        }
        if (CollectionUtils.isNotEmpty(param.getAccountHolderNames())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountHolderName.in(param.getAccountHolderNames()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountCode())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountCode.eq((Object)param.getAccountCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountName())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountName.eq((Object)param.getAccountName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountHolderName())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountHolderName.eq((Object)param.getAccountHolderName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountHolderType())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountHolderType.eq((Object)param.getAccountHolderType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountHolderCode())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountHolderCode.eq((Object)param.getAccountHolderCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSecOuCode())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.secOuCode.eq((Object)param.getSecOuCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getAccountType())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.accountType.eq((Object)param.getAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getState())) {
            accountVOJPAQuery.where((Predicate)AccountRepoProc.qAccountDO.state.eq((Object)param.getState()));
        }
        return accountVOJPAQuery.fetch();
    }

    public AccountDO findByAccountCode(String accountCode) {
        List<AccountDO> accountDOList = this.accountRepo.findAllByAccountCode(accountCode);
        Assert.notEmpty(accountDOList, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountDOList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountDO accountDO = accountDOList.get(0);
        Assert.equals((Object)accountDO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountDOList.get(0);
    }

    public AccountVO getVOByCode(String accCode) {
        List accountVoList = ((JPAQuery)this.select(AccountVO.class).where((Predicate)AccountRepoProc.qAccountDO.accountCode.eq((Object)accCode))).fetch();
        Assert.notEmpty((Iterable)accountVoList, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountVoList.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountVO accountVO = (AccountVO)((Object)accountVoList.get(0));
        Assert.equals((Object)accountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountVO;
    }

    public AccountDTO getDTOByCode(String accCode) {
        List accountDTOS = ((JPAQuery)this.select(AccountDTO.class).where((Predicate)AccountRepoProc.qAccountDO.accountCode.eq((Object)accCode))).fetch();
        Assert.notEmpty((Iterable)accountDTOS, (String)"\u8d26\u6237\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Assert.isTrue((accountDTOS.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u6237", (Object[])new Object[0]);
        AccountDTO accountDTO = (AccountDTO)accountDTOS.get(0);
        Assert.equals((Object)accountDTO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
        return accountDTO;
    }

    public List<String> selectSecOuCodeByAccountHolderCode(String accountHolderCode) {
        if (StringUtils.isBlank((CharSequence)accountHolderCode)) {
            return Collections.EMPTY_LIST;
        }
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)AccountRepoProc.qAccountDO.secOuCode).distinct()).from((EntityPath)qAccountDO)).where((Predicate)AccountRepoProc.qAccountDO.accountHolderCode.eq((Object)accountHolderCode));
        return query.fetch();
    }

    public List<AccountOuVO> selectAccountOuByAccountHolderCode(String accountHolderCode) {
        if (StringUtils.isBlank((CharSequence)accountHolderCode)) {
            return Collections.EMPTY_LIST;
        }
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountOuVO.class, (Expression[])new Expression[]{AccountRepoProc.qAccountDO.secOuCode.as("ouCode"), AccountRepoProc.qAccountDO.secOuName.as("ouName"), AccountRepoProc.qAccountDO.createTime})).from((EntityPath)qAccountDO)).where((Predicate)AccountRepoProc.qAccountDO.accountHolderCode.eq((Object)accountHolderCode));
        return query.fetch();
    }

    public AccountAmtSumVO selectAmtSumByParam(String secOuCode, String accountHolderCode) {
        AccountAmtSumVO res = (AccountAmtSumVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountAmtSumVO.class, (Expression[])new Expression[]{AccountRepoProc.qAccountDO.accountAmount.sum().as("accountAmountSum"), AccountRepoProc.qAccountDO.accountAvailableAmount.sum().as("accountAvailableAmountSum"), AccountRepoProc.qAccountDO.accountOccupancyAmount.sum().as("accountOccupancyAmountSum")})).from((EntityPath)qAccountDO)).where((Predicate)AccountRepoProc.qAccountDO.secOuCode.eq((Object)secOuCode))).where((Predicate)AccountRepoProc.qAccountDO.accountHolderCode.eq((Object)accountHolderCode))).fetchOne();
        return res;
    }

    public List<AccountVO> selectAccountAmtByParam(String secOuCode, String accountHolderCode, String accountType) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)secOuCode)) {
            predicates.add(AccountRepoProc.qAccountDO.secOuCode.eq((Object)secOuCode));
        }
        if (!StringUtils.isEmpty((CharSequence)accountHolderCode)) {
            predicates.add(AccountRepoProc.qAccountDO.accountHolderCode.eq((Object)accountHolderCode));
        }
        if (!StringUtils.isEmpty((CharSequence)accountType)) {
            predicates.add(AccountRepoProc.qAccountDO.accountType.eq((Object)accountType));
        }
        return ((JPAQuery)this.select(AccountVO.class).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public String getSecOuCodeByAccountCode(@NotBlank String accountCode) {
        return (String)super.getValueByValue((Path)AccountRepoProc.qAccountDO.secOuCode, (Path)AccountRepoProc.qAccountDO.accountCode, (Object)accountCode);
    }

    public String getAccountHolderCodeByAccountCode(@NotBlank String accountCode) {
        return (String)super.getValueByValue((Path)AccountRepoProc.qAccountDO.accountHolderCode, (Path)AccountRepoProc.qAccountDO.accountCode, (Object)accountCode);
    }
}

