package com.elitesland.fin.application.service.excel.exp;


import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountSnapshotVo;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.excel.entity.CreditAccountSnapshotExportEntity;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 品牌导出
 *
 * @author : Scott.zhang(zhang hang)
 * @Date : 2022/2/2210:10
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class CreditAccountSnapshotExportServiceImpl implements DataExport<CreditAccountSnapshotExportEntity, CreditAccountSnapshotParam> {

    private final CreditAccountService creditAccountService;

    @Override
    public String getTmplCode() {
        return "credit_account_snapshot_export";
    }


    @Override
    @BusinessObjectOperation(permissionRef = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT_SNAPSHOT_LIST, businessObjectType = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT,
            operationType = OperationTypeEnum.EXPORT, operationDescription = "信用账户快照导出",operationCode = FinBusinessObjectConstant.FIN_CREDIT_ACCOUNT_SNAPSHOT_EXPORT,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public PagingVO<CreditAccountSnapshotExportEntity> executeExport(CreditAccountSnapshotParam queryParam) {
        PagingVO<CreditAccountSnapshotVo> pagingVO = creditAccountService.querySnapshot(queryParam);
        return new PagingVO<>(
            pagingVO.getTotal(),
            ExcelConvertUtils.convertLoosely(pagingVO.getRecords(), CreditAccountSnapshotExportEntity.class)
        );
    }
}
