package com.elitesland.fin.domain.param.recorder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Data
public class RecOrderDetailSaveParam implements Serializable {
    private static final long serialVersionUID = 4262584752428329568L;
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("主表id")
    private Long masId;
    @ApiModelProperty("收款方式")
    @SysCode(sys = "yst-fin",mod = "PAY_METHOD")
    private String recType;
    private String recTypeName;
    @ApiModelProperty("收款类型")
    private String recKind;
    @ApiModelProperty("收款银行名称")
    private String recBank;
    @ApiModelProperty("收款银行账户")
    private String recAccount;
    @ApiModelProperty("收款流水")
    private String recFlow;
    @ApiModelProperty("来源单号")
    private String sourceNo;
    @ApiModelProperty("来源单号ID")
    private Long sourceId;
    @ApiModelProperty("来源行号")
    private Integer sourceLine;
    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;
    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;
    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxRate;
    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;
    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;
    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;
    @ApiModelProperty("费用类型")
    private String expensesType;
    @ApiModelProperty("备注")
    private String remark;

    public void checkMoney(BigDecimal exchangeRate) {
        //总金额=实际支付金额
        if (totalAmt.compareTo(realRecAmt) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额与实际支付金额不等!");
        }
        //总金额本位币=总金额*汇率；
        if (totalCurAmt.compareTo(totalAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行总金额(本位币)与总金额*汇率不等!");
        }
        //实际收款金额本位币=实际收款金额*汇率；
        if (realRecCurAmt.compareTo(realRecAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行实际收款金额(本位币)与实际收款金额*汇率不等!");
        }
        //税额=总金额*税率；
        if (taxAmt.compareTo(totalAmt.multiply(taxRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额与总金额*税率不等!");
        }
        //税额本位币=税额*汇率；
        if (taxCurAmt.compareTo(taxAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "明细行税额(本位币)与税额*汇率不等!");
        }

    }
}
