package com.elitesland.fin.domain.service.account;



import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.vo.account.AccountIocParamVO;
import com.elitesland.fin.application.facade.vo.account.AccountIocRespVO;
import com.elitesland.fin.entity.account.AccountIoc;

import java.util.List;
import java.util.Optional;
import java.util.Set;


/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
public interface AccountIocDomainService {

    PagingVO<AccountIocDTO> search(AccountIocParamVO param);

    Long saveAccountIoc(AccountIoc AccountIoc, Optional<AccountIocDTO> optional);

    Optional<AccountIocDTO> findById(Long id);

    Optional<AccountIocDTO> findByCode(String code);

    List<AccountIocDTO> findByIdBatch(List<Long> idList);

    List<AccountIocDTO> findByCodeBatch(List<String> codeList);

    List<AccountIocDTO> selectByParam(AccountIocParamVO param);

    void updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList);

    List<AccountIocDTO> queryByAccountIocParam(AccountIocParam accountIocParam);
}
