/**
 * 项目名称(中文)
 * 项目名称(英文)
 * Copyright (c) 2016 ChinaPay Ltd. All Rights Reserved.
 */
package com.elitesland.fin.application.service.unionpay.entity.constant;

/**
 * @author hrtc .
 */
public class Constants {

    /**
     * 默认编码.
     */
    public static final String ENCODING = "UTF-8";

    /**
     * 文件分隔符.
     */
    public static final String FILE_SPLIT_STR = "/";
    /**
     * 业务类型
     */
    public static final String BUSINESS_TYPE = "0001";
    /**
     * 成功状态码
     */
    public static final String ORDER_SUCCESS_CODE = "0000";
    /**
     * 请求版本号
     */
    public static final String REQUEST_VERSION = "20140728";
    /**
     * 支付交易类型
     */
    public static final String PAY_TRAN_TYPE = "0002";
    /**
     * 退款交易类型
     */
    public static final String REFUND_TRAN_TYPE = "0401";
    /**
     * 查询交易类型
     */
    public static final String QUERY_TRAN_TYPE = "0502";
    /**
     * 原始订单交易字段
     */
    public static final String ORI_ORDER_NO = "OriOrderNo";
    /**
     * 订单交易号字段
     */
    public static final String MER_ORDER_NO = "MerOrderNo";
    /**
     * 订单状态字段
     */
    public static final String ORDER_STATUS = "OrderStatus";
    /**
     * 交易日期字段
     */
    public static final String TRAN_DATE = "TranDate";
    /**
     * 原始交易日期字段
     */
    public static final String ORI_TRAN_DATE = "OriTranDate";
    /**
     * 版本号字段
     */
    public static final String VERSION = "Version";
    /**
     * 交易时间字段
     */
    public static final String TRAN_TIME = "TranTime";
    /**
     * 交易类型字段
     */
    public static final String TRAN_TYPE = "TranType";
    /**
     * 支付机构号字段
     */
    public static final String BANK_INST_NO = "BankInstNo";
    /**
     * 交易类型字段
     */
    public static final String BUSI_TYPE = "BusiType";
    /**
     * 订单金额字段
     */
    public static final String ORDER_AMT = "OrderAmt";
    /**
     * 退款金额字段
     */
    public static final String REFUND_AMT = "RefundAmt";
    /**
     * 异步后台回调地址
     */
    public static final String MER_BG_URL = "MerBgUrl";
    /**
     * 防钓鱼地址
     */
    public static final String REMOTE_ADDR = "RemoteAddr";
    /**
     * 默认错误码.
     */
    public static final String DEFAULT_ERROR_CODE = "9999";

    /******** 报文字段 ********/
    /**
     * 卡信息字段.
     */
    public static final String CARD_TRAN_DATA = "CardTranData";
    /**
     * 交易保留域.
     */
    public static final String TRAN_RESERVED = "TranReserved";
    /**
     * 风控保留域.
     */
    public static final String RISK_DATA = "RiskData";

    /**
     * 响应信息.
     */
    public static final String RESP_MSG = "respMsg";
    /**
     * 响应码.
     */
    public static final String RESP_CODE = "respCode";

    /**
     * 签名.
     */
    public static final String SIGNATURE = "Signature";

    /**
     * .
     */
    public static final String MER_ID = "MerId";
    /**
     * .
     */
    public static final String INSTU_ID = "InstuId";
    /******** demo特殊字段 ********/
    /**
     * 特殊字段前缀.
     */
    public static final String SPEC_PRIFEX = "__";
    /**
     * 请求参数-定制接口类型.
     */
    public static final String SPEC_INTERFACE_TYPE = "__interfaceType";
    /**
     * 请求参数-交易类型.
     */
    public static final String SPEC_TRAN_TYPE = "__tranType";
    /**
     * 请求参数-交易子类型.
     */
    public static final String SPEC_SUB_TRAN_TYPE = "__subTransType";
    /**
     * 请求参数-调用方法.
     */
    public static final String SPEC_METHOD = "__method";
    /**
     * 请求参数-通知类型 0前台 1后台 默认是后台.
     */
    public static final String SPEC_NOTIFY_TYPE = "__notifyType";

    /**
     * 请求参数-请求地址.
     */
    public static final String SPEC_REQUEST_URL = "__requestUrl";
    /**
     * 响应参数-发送map.
     */
    public static final String SEND_MAP = "sendMap";
    /**
     * 响应参数-响应map.
     */
    public static final String RESULT_MAP = "resultMap";
    /**
     * 响应参数-接口缓存.
     */
    public static final String INTERFACE_CACHE = "interfaceCache";
    /**
     * 响应参数-报文.
     */
    public static final String PACKET = "packet";

    /**
     * 响应参数-请求地址.
     */
    public static final String REQUEST_URL = "requestUrl";
    /**
     * 方法-生成请求页面.
     */
    public static final String METHOD_GEN_REQUEST_PAGE = "genRequestPage";
    /**
     * 方法-组报文页面.
     */
    public static final String METHOD_PACK = "pack";
    /**
     * 方法-解包.
     */
    public static final String METHOD_UNPACK = "unpack";
    /**
     * 方法-发送.
     */
    public static final String METHOD_SEND = "send";
    
    /**
     * 通知类型-前台.
     */
    public static final String NOTIFY_TYPE_FRONT = "0";
    /**
     * 通知类型-后台.
     */
    public static final String NOTIFY_TYPE_BACK = "1";

    /**
     * 分页查询数量
     */
    public static final Integer PAGE_SIZE = 999;
}
