package com.elitesland.fin.application.web.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountPeriodParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountPeriodVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleVO;
import com.elitesland.fin.application.service.accountingengine.FinAccountPeriodService;
import com.elitesland.fin.application.service.accountingengine.FinFlexibleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author gyj
 * @date 2023/10/10
 */
@RestController
@RequestMapping("/account/period")
@RequiredArgsConstructor
@Api(value = "会计期间", tags = {"会计期间"})
public class FinAccountPeriodController {

    private final FinAccountPeriodService finAccountPeriodService;

    @PostMapping("/saveOrUpdate")
    @ApiOperation("新增/修改")
    public ApiResult<Long> saveOrUpdate(@RequestBody FinAccountPeriodParam finAccountPeriodParam) {
        return ApiResult.ok(finAccountPeriodService.saveOrUpdate(finAccountPeriodParam));
    }

    @PostMapping("/page")
    @ApiOperation("分页查询")
    public ApiResult<PagingVO<FinAccountPeriodVO>> page(@RequestBody FinAccountPeriodParam finAccountPeriodParam) {
        return ApiResult.ok(finAccountPeriodService.page(finAccountPeriodParam));
    }

    @PostMapping("enableOrDisable")
    @ApiOperation("启用/禁用")
    public ApiResult<Void> enableOrDisable(@RequestBody FinAccountPeriodParam finAccountPeriodParam) {
        finAccountPeriodService.enableOrDisable(finAccountPeriodParam);
        return ApiResult.ok();
    }


}
