package com.elitesland.fin.application.web.invoice;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.ApplyInvoiceParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitDetailPageParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitDVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceCustVO;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.constant.FinBusinessObjectConstant;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Slf4j
@Api(tags = "待开发票列表")
@RestController
@RequestMapping(value = "/invoice/await", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
@BusinessObject(businessType = FinBusinessObjectConstant.FIN_INVOICE_AWAIT, businessDoClass = InvoiceAwaitDO.class)
public class InvoiceAwaitController {

    private final InvoiceAwaitService invoiceAwaitService;

    @ApiOperation(value = "待开发票列表分页查询")
    @PostMapping(value = "/page")
    @BusinessObjectOperation(operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "待开发票列表分页",
            businessObjectType = FinBusinessObjectConstant.FIN_INVOICE_AWAIT,operationCode = FinBusinessObjectConstant.FIN_INVOICE_AWAIT_LIST,
            dataPermissionEnabled = true, fieldPermissionAutoFilter = true)
    public ApiResult<PagingVO<InvoiceAwaitVO>> queryInvoiceAwait(@RequestBody InvoiceAwaitQueryParam param) {
        log.info("[fin-invoice-await] queryInvoiceAwait  param ={}", param);
        return ApiResult.ok(invoiceAwaitService.queryInvoiceAwait(param));
    }

    @ApiOperation(value = "待开发票列表明细")
    @GetMapping(value = "/detail/list/{masId}")
    public ApiResult<List<InvoiceAwaitDVO>> queryInvoiceAwaitDetail(@PathVariable("masId") Long masId) {
        log.info("[fin-invoice-await] queryInvoiceAwaitDetail param={}", masId);
        return ApiResult.ok(invoiceAwaitService.queryInvoiceAwaitDetail(masId));
    }

    @ApiOperation(value = "待开发票明细分页")
    @PostMapping(value = "/detail/page/{masId}")
    public ApiResult<PagingVO<InvoiceAwaitDVO>> queryInvoiceAwaitDetailPage(@RequestBody InvoiceAwaitDetailPageParam param) {
        log.info("[fin-invoice-await] queryInvoiceAwaitDetailPage param={}", JSON.toJSONString(param));
        return ApiResult.ok(invoiceAwaitService.queryInvoiceAwaitDetailPage(param));
    }

    @ApiOperation(value = "申请开票")
    @PostMapping(value = "/invoice/apply")
    public ApiResult<?> invoiceApply(@RequestBody InvoiceApplyParam param) {
        log.info("[YST-FIN] invoiceApply param={}", param);
        return ApiResult.ok(invoiceAwaitService.invoiceApply(param));
    }

    @ApiOperation("开票抬头查询")
    @PostMapping("/query")
    public ApiResult<List<InvoiceCustVO>> invQuery(@RequestBody List<ApplyInvoiceParam> applyInvoiceParam) {
        log.info("[YST-INV] invQuery, applyInvoiceParam={}", applyInvoiceParam);
        return ApiResult.ok(invoiceAwaitService.invQuery(applyInvoiceParam));
    }

    @ApiOperation("对接对账单")
    @GetMapping("/rec")
    public ApiResult<List<InvoiceAwaitDTO>> invQuery() {
        return ApiResult.ok(invoiceAwaitService.generateAwaitOrderAndInvoice(""));
    }

    @ApiOperation("测试已签收发货单生成代开发票数据")
    @GetMapping("/createInvoiceBySalDo")
    public void createInvoiceBySalDo(String docNo) {
        invoiceAwaitService.invoiceAwaitOrderBySalDo(docNo);
    }
}
