package com.elitesland.fin.domain.service.expense;


import com.elitesland.fin.domain.base.BaseRepo;
import com.elitesland.fin.entity.expense.ExpRuleConfigDtlDO;
import com.elitesland.fin.repo.expense.ExpRuleConfigDtlRepo;
import com.elitesland.fin.repo.expense.ExpRuleConfigDtlRepoProc;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Mark
 * @date 2024/08/13 18:23
 */
@Service
@AllArgsConstructor
public class ExpRuleConfigDtlDomainServiceImpl implements ExpRuleConfigDtlDomainService {
    private final ExpRuleConfigDtlRepo expRuleConfigDtlRepo;

    private final ExpRuleConfigDtlRepoProc expRuleConfigDtlRepoProc;

    @Override
    public BaseRepo<ExpRuleConfigDtlDO, Long> getDao() {
        return expRuleConfigDtlRepo;
    }

    @Override
    public void updateDynamically(List<ExpRuleConfigDtlDO> invSceneConfigDtlDOS) {
        expRuleConfigDtlRepoProc.updateDynamically(invSceneConfigDtlDOS);
    }

    @Override
    public List<ExpRuleConfigDtlDO> findExpRuleConfigDtlByMasId(Long masId) {
        return expRuleConfigDtlRepo.findByMasId(masId);
    }

    @Override
    public List<ExpRuleConfigDtlDO> findExpRuleConfigDtlByMasIdsIn(List<Long> masIdList) {
        return expRuleConfigDtlRepoProc.findByMasIdsIn(masIdList);
    }

    @Override
    public void deleteByParam(ExpRuleConfigDtlDO expRuleConfigDtlDO) {
        expRuleConfigDtlRepoProc.deleteByParam(expRuleConfigDtlDO);
    }
}