package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.fin.application.convert.paymentperiod.ReceiptPaymentAgreementDtlConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.ReceiptPaymentAgreementDtlSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.domain.entity.paymentperiod.ReceiptPaymentAgreementDtlDO;
import com.elitesland.fin.infr.repo.paymentperiod.ReceiptPaymentAgreementDtlRepo;
import com.elitesland.fin.infr.repo.paymentperiod.ReceiptPaymentAgreementDtlRepoProc;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@Service
@RequiredArgsConstructor
public class ReceiptPaymentAgreementDtlDomainServiceImpl implements ReceiptPaymentAgreementDtlDomainService {

    private final ReceiptPaymentAgreementDtlRepo receiptPaymentAgreementDtlRepo;
    private final ReceiptPaymentAgreementDtlRepoProc receiptPaymentAgreementDtlRepoProc;



    /**
     * 收付款协议明细保存
     *
     * @param saveParamList 入参
     * @return 收付款协议明细明细ID
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public List<Long> saveDtl(List<ReceiptPaymentAgreementDtlSaveParam> saveParamList) {
        List<ReceiptPaymentAgreementDtlDO> dtlDOList = saveParamList.stream().map(ReceiptPaymentAgreementDtlConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());

        return receiptPaymentAgreementDtlRepo.saveAll(dtlDOList).stream().map(ReceiptPaymentAgreementDtlDO::getId).collect(Collectors.toList());
    }

    /**
     * 根据主表ID删除收付款协议明细
     *
     * @param masId 主表ID
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMasId(Long masId) {
        receiptPaymentAgreementDtlRepo.deleteByMasId(masId);
    }

    /**
     * 根据主表ID查询收付款协议明细
     *
     * @param masId 主表ID
     * @return 收付款协议明细
     */
    @Override
    @SysCodeProc
    public List<ReceiptPaymentAgreementDtlVO> selectByMasId(Long masId) {
        if (Objects.isNull(masId)) {
            return Collections.EMPTY_LIST;
        }
        ReceiptPaymentAgreementDtlPageParam queryVO = new ReceiptPaymentAgreementDtlPageParam();
        queryVO.setMasId(masId);
        List<ReceiptPaymentAgreementDtlVO> dtlVOList = receiptPaymentAgreementDtlRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }

        return dtlVOList;
    }

    /**
     * 根据入参查询收付款协议明细
     *
     * @param queryVO 入参
     * @return 收付款协议明细数据
     */
    @Override
    @SysCodeProc
    public List<ReceiptPaymentAgreementDtlVO> selectByParam(ReceiptPaymentAgreementDtlPageParam queryVO) {
        List<ReceiptPaymentAgreementDtlVO> dtlVOList = receiptPaymentAgreementDtlRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlVOList;
    }

    /**
     * 根据主表ID批量更新deleteFlag
     *
     * @param deleteFlag 删除标记
     * @param masIds     主表ID
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        receiptPaymentAgreementDtlRepoProc.updateDeleteFlagBatch(deleteFlag, masIds);
    }

}
