/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.paymentperiod;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.paymentperiod.AgingRangeOuConvert;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuPageParam;
import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeOuSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeOuVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeOuDO;
import com.elitesland.fin.domain.service.paymentperiod.AgingRangeOuDomainService;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeOuDTO;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeOuRepo;
import com.elitesland.fin.infr.repo.paymentperiod.AgingRangeOuRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgingRangeOuDomainServiceImpl
implements AgingRangeOuDomainService {
    private final AgingRangeOuRepo agingRangeOuRepo;
    private final AgingRangeOuRepoProc agingRangeOuRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<AgingRangeOuDTO> ouPage(AgingRangeOuPageParam pageParam) {
        PagingVO<AgingRangeOuDTO> res = this.agingRangeOuRepoProc.page(pageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOu(AgingRangeOuSaveParam saveParam) {
        AgingRangeOuDO agingRangeOuDO = AgingRangeOuConvert.INSTANCE.saveVoToDo(saveParam);
        Boolean isExist = this.agingRangeOuRepoProc.existByApTypeIdOuId(agingRangeOuDO);
        if (!isExist.booleanValue()) {
            AgingRangeOuDO save = (AgingRangeOuDO)this.agingRangeOuRepo.save(agingRangeOuDO);
            return save.getId();
        }
        return saveParam.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOu(List<Long> ids) {
        this.agingRangeOuRepo.deleteByIdIn(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> save(List<AgingRangeOuSaveParam> saveParamList) {
        List dtlDOList = saveParamList.stream().map(AgingRangeOuConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
        return this.agingRangeOuRepo.saveAll(dtlDOList).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByMasId(Long masId) {
        this.agingRangeOuRepo.deleteByMasId(masId);
    }

    @Override
    @SysCodeProc
    public List<AgingRangeOuVO> selectByMasId(Long masId) {
        if (Objects.isNull(masId)) {
            return Collections.EMPTY_LIST;
        }
        AgingRangeOuPageParam queryVO = new AgingRangeOuPageParam();
        queryVO.setMasId(masId);
        List<AgingRangeOuVO> dtlVOList = this.agingRangeOuRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlVOList;
    }

    @Override
    @SysCodeProc
    public List<AgingRangeOuVO> selectByParam(AgingRangeOuPageParam queryVO) {
        List<AgingRangeOuVO> dtlVOList = this.agingRangeOuRepoProc.selectListByParam(queryVO);
        if (CollectionUtils.isEmpty(dtlVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatchByMasId(Integer deleteFlag, List<Long> masIds) {
        this.agingRangeOuRepoProc.updateDeleteFlagBatchByMasId(deleteFlag, masIds);
    }

    public AgingRangeOuDomainServiceImpl(AgingRangeOuRepo agingRangeOuRepo, AgingRangeOuRepoProc agingRangeOuRepoProc) {
        this.agingRangeOuRepo = agingRangeOuRepo;
        this.agingRangeOuRepoProc = agingRangeOuRepoProc;
    }
}

