package com.elitesland.fin.repo.expense;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.entity.expense.ExpRuleConfigDO;
import com.elitesland.fin.entity.expense.QExpLedgerDO;
import com.elitesland.fin.entity.expense.QExpRuleConfigDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @Auther: Mark
 * @Date: 2024/8/13 13:23
 * @Description:
 */
@Slf4j
@Component
@AllArgsConstructor
public class ExpRuleConfigRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QExpRuleConfigDO qExpRuleConfigDO = QExpRuleConfigDO.expRuleConfigDO;


    public void updateEnableFlag(List<Long> ids, boolean enable) {
        val jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        jpaQueryFactory.update(jpaQDO)
                .set(jpaQDO.enableFlag, enable)
                .where(jpaQDO.id.in(ids))
                .execute();
    }

    public void updateDynamically(ExpRuleConfigDO param) {
        val jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        JPAUpdateClause updateClause = jpaQueryFactory.update(jpaQDO);

        //编码
        if (StringUtils.isNotBlank(param.getRuleCode())) {
            updateClause.set(jpaQDO.ruleCode, param.getRuleCode());
        }

        //名称
        if (StringUtils.isNotBlank(param.getRuleName())) {
            updateClause.set(jpaQDO.ruleName, param.getRuleName());
        }

        //适用单据
        if (StringUtils.isNotBlank(param.getExpTypeCode())) {
            updateClause.set(jpaQDO.calculateType, param.getExpTypeCode());
        }

        //启用状态
        if (param.getEnableFlag() != null) {
            updateClause.set(jpaQDO.enableFlag, param.getEnableFlag());
        }

        updateClause.set(jpaQDO.modifyTime, LocalDateTime.now());
        updateClause.where(jpaQDO.id.eq(param.getId())).execute();
    }

    /**
     * 获取所有启用禁用状态的数据
     *
     * @param expTypeCode
     * @return
     */
    public List<ExpRuleConfigDO> getAllExpRuleConfig(String expTypeCode) {
        val jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return jpaQueryFactory.selectFrom(jpaQDO).where(jpaQDO.expTypeCode.eq(expTypeCode)).fetch();
    }

    public List<ExpRuleConfigDO> getAllExpRuleConfigByParam(ExpRuleConfigQueryParam param) {
        //val jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        JPAQuery<ExpRuleConfigDO> jpaQuery = jpaQueryFactory.selectFrom(qExpRuleConfigDO);
        List<Predicate> where = selectListWhere(param);
        jpaQuery.where(ExpressionUtils.allOf(where));

        return jpaQuery.fetch();
    }

    private List<Predicate> selectListWhere(ExpRuleConfigQueryParam param){
        List<Predicate> predicates = new ArrayList<>();
        if(StringUtils.isNotBlank(param.getExpTypeCode())){
            predicates.add(qExpRuleConfigDO.expTypeCode.eq(param.getExpTypeCode()));
        }
       /* if(StringUtils.isNotBlank(param.getEnableStatus())){
            predicates.add(qExpRuleConfigDO.enableStatus.eq(param.getEnableStatus()));
        }*/
        if (param.getEnableStatus() != null) {
            predicates.add(qExpRuleConfigDO.enableFlag.eq(param.getEnableStatus()));
        }

        return predicates;
    }

    /**
     * 根据编码，查询启用状态的数据
     *
     * @param expTypeCode
     * @return
     */
    public List<ExpRuleConfigDO> getAllEnableExpRuleConfig(String expTypeCode) {
        val jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return jpaQueryFactory.selectFrom(jpaQDO).where(jpaQDO.enableFlag.eq(true).and(jpaQDO.expTypeCode.eq(expTypeCode))).fetch();
    }

    /**
     * 查询所有启用状态的数据
     *
     * @return
     */
    public List<ExpRuleConfigDO> getAllEnableExpRuleConfig() {
        val jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return jpaQueryFactory.selectFrom(jpaQDO).where(jpaQDO.enableFlag.eq(true)).fetch();
    }

    public List<ExpRuleConfigDO> findExpRuleConfigByExpTypeAndElement(String expTypeCode, String expElement) {
        val jpaQDO = QExpRuleConfigDO.expRuleConfigDO;
        return jpaQueryFactory.selectFrom(jpaQDO).where(jpaQDO.expTypeCode.eq(expTypeCode).and(jpaQDO.expElement.eq(expElement))).fetch();
    }

    public PagingVO<ExpRuleConfigPageVO> searchPage(ExpRuleConfigQueryParam param) {
        val jpaQDo = QExpRuleConfigDO.expRuleConfigDO;
        //val jpaDQDo = QExpRuleConfigDtlDO.expRuleConfigDtlDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        ExpRuleConfigPageVO.class,
                        jpaQDo.id,
                        jpaQDo.ruleCode,
                        jpaQDo.ruleName,
                        jpaQDo.expTypeCode,
                        jpaQDo.enableFlag,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion,
                        jpaQDo.remark,
                        jpaQDo.priorityNo,
                        jpaQDo.calculatePercent,
                        jpaQDo.uomAmt,
                        jpaQDo.calculateType,
                        jpaQDo.automaticReview
                )
        ).from(jpaQDo);  //.leftJoin(jpaQDo).on(jpaQDo.id.eq(jpaDQDo.masId));
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<ExpRuleConfigPageVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private Predicate where(ExpRuleConfigQueryParam param) {
        val jpaQDo = QExpRuleConfigDO.expRuleConfigDO;
        //  val jpaDQDo = QExpRuleConfigDtlDO.expRuleConfigDtlDO;
        Predicate predicate = jpaQDo.isNotNull();

        //账户编码/名称
        if (StringUtils.isNotBlank(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                    jpaQDo.ruleCode.like("%" + param.getMultiKeywords() + "%"),
                    jpaQDo.ruleName.like("%" + param.getMultiKeywords() + "%")
            ));
        }
        if (StrUtil.isNotBlank(param.getExpTypeCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expTypeCode.eq(param.getExpTypeCode()));
        }
        if (StrUtil.isNotBlank(param.getRuleName())) {
            predicate = ExpressionUtils.and(predicate,
                    jpaQDo.ruleName.like("%" + param.getRuleName() + "%"));
        }
        if (StrUtil.isNotBlank(param.getCalculateType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.calculateType.eq(param.getCalculateType()));
        }
        if (param.getEnableStatus() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.enableFlag.eq(param.getEnableStatus()));
        }

        //适用单据
       /* if (StringUtils.isNotEmpty(param.getOptDoc())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.expTypeCode.eq(param.getOptDoc()));
        }*/

        //适用单据类型
     /*   if (StringUtils.isNotEmpty(param.getOptDocType())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.optDocType.contains(param.getOptDocType()));
        }*/

        //适用单据状态
       /* if (StringUtils.isNotEmpty(param.getOptDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.optDocStatus.eq(param.getOptDocStatus()));
        }*/

        //适用账户类型
       /* if (StringUtils.isNotEmpty(param.getOptAccountType())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.optAccountType.eq(param.getOptAccountType()));
        }*/

        //指定账户
        /*if (StringUtils.isNotEmpty(param.getSpecificAccount())) {
            predicate = ExpressionUtils.and(predicate, jpaDQDo.specificAccount.contains(param.getSpecificAccount())
                    .or(jpaDQDo.specificAccount.isNull()));
        }*/

        return predicate;
    }

}
