package com.elitesland.fin.rpc.inv;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.dto.invIo.InvIoParamRpcDTO;
import com.elitesland.inv.dto.invIo.InvIoRpcDTO;
import com.elitesland.inv.provider.InvIoProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
@RequiredArgsConstructor
public class RmiInvRpcService {

    private final InvIoProvider invIoProvider;

    public InvIoRpcDTO findInvIoById(Long id) {
        ApiResult<InvIoRpcDTO> result = invIoProvider.findInvIoById(id);
        if (!result.isSuccess()) {
            throw new BusinessException("查询库存流水接口出错");
        }
        return result.getData();
    }

    public List<InvIoRpcDTO> findSaleOutByParam(InvIoParamRpcDTO param) {
        ApiResult<List<InvIoRpcDTO>> result = invIoProvider.findSaleOutByParam(param);
        if (!result.isSuccess()) {
            throw new BusinessException("查询销售出库接口出错");
        }
        log.info("查询销售出库出参：" + JSON.toJSONString(result));
        return result.getData();
    }

    public List<InvIoRpcDTO> findWhBySourceNos(List<String> sourceNos) {
        ApiResult<List<InvIoRpcDTO>> result = invIoProvider.findWhBySourceNos(sourceNos);
        if (!result.isSuccess()) {
            throw new BusinessException("查询库存流水接口出错");
        }
        return result.getData();
    }

    public List<InvIoRpcDTO> findInvIoByIds(List<Long> ids) {
        ApiResult<List<InvIoRpcDTO>> result = invIoProvider.findInvIoByIds(ids);
        if (!result.isSuccess()) {
            throw new BusinessException("批量查询库存流水接口出错");
        }
        return result.getData();
    }
}
