package com.elitesland.fin.application.facade.dto.writeoff;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 保存参数.
 *
 * @author shihao.ma
 * @since 2023/9/5
 */
@Getter
@Setter
@ApiModel(description = "保存参数")
public class FinApPayVerApplyApSaveDTO implements Serializable {

    private static final long serialVersionUID = -1309568306896831751L;

    /**
     * 应收单ID
     */
    @ApiModelProperty(value = "应收单ID")
    private Long apId;

    /**
     * 应收单号
     */
    @ApiModelProperty(value = "应收单号")
    private String apDocNo;

    /**
     * 第三方应收单号
     */
    @ApiModelProperty(value = "第三方应收单号")
    private String outApDocNo;

    /**
     * 订单号
     */
    @ApiModelProperty("订单号")
    private String orderNo;
    /**
     * 发货单号
     */
    @ApiModelProperty("发货单号")
    private String sendOrder;

    /**
     * 应收单明细ID
     */
    @ApiModelProperty(value = "应收单明细ID")
    @NotNull(message = "应收单明细ID不能为空")
    private Long apDId;

    /**
     * 外部应收单明细ID
     */
    @ApiModelProperty(value = "外部应收单明细ID")
    private String outApDId;

    /**
     * 应收单类型ID
     */
    @ApiModelProperty(value = "应收单类型ID")
    private Long apTypeId;

    /**
     * 应收单类型编码
     */
    @ApiModelProperty(value = "应收单类型编码")
    private String apTypeCode;

    /**
     * 应收单类型名称
     */
    @ApiModelProperty(value = "应收单类型名称")
    private String apTypeName;

    /**
     * 公司ID
     */
    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 部门ID
     */
    @ApiModelProperty(value = "部门ID")
    private Long buId;

    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码")
    private String buCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String buName;

    /**
     * 业务员ID
     */
    @ApiModelProperty(value = "业务员ID")
    private Long salesmanId;

    /**
     * 业务员编码
     */
    @ApiModelProperty(value = "业务员编码")
    private String salesmanCode;

    /**
     * 业务员名称
     */
    @ApiModelProperty(value = "业务员名称")
    private String salesmanName;

    /**
     * 发票号
     */
    @ApiModelProperty(value = "发票号")
    private String invoiceNumber;

    /**
     * 开票日期
     */
    @ApiModelProperty(value = "开票日期")
    private LocalDateTime invDate;

    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invType;

    /**
     * 来源单号
     */
    @ApiModelProperty(value = "来源单号")
    private String sourceNo;

    /**
     * 订货日期
     */
    @ApiModelProperty(value = "订货日期")
    private String ordererDate;

    /**
     * 订货人
     */
    @ApiModelProperty(value = "订货人")
    private String ordererName;

    /**
     * 订货人电话
     */
    @ApiModelProperty(value = "订货人电话")
    private String ordererPhone;

    /**
     * 订货人地址
     */
    @ApiModelProperty(value = "订货人地址")
    private String ordererAddr;

    /**
     * 渠道类型
     */
    @ApiModelProperty(value = "渠道类型")
    private String chanType;

    /**
     * 打款方式
     */
    @ApiModelProperty(value = "打款方式")
    private String payoutsType;

    /**
     * 客户ID
     */
    @ApiModelProperty(value = "客户ID")
    private Long custId;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String custName;

    /**
     * 子客户ID
     */
    @ApiModelProperty(value = "子客户ID")
    private Long subCustId;

    /**
     * 子客户编码
     */
    @ApiModelProperty(value = "子客户编码")
    private String subCustCode;

    /**
     * 子客户名称
     */
    @ApiModelProperty(value = "子客户名称")
    private String subCustName;

    /**
     * 商品ID
     */
    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    /**
     * 商品编码
     */
    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String itemName;

    /**
     * 规格型号
     */
    @ApiModelProperty(value = "规格型号")
    private String itemType;

    /**
     * 数量
     */
    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    /**
     * 含税单价
     */
    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    /**
     * 含税总金额
     */
    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    /**
     * 应收单单据日期
     */
    @ApiModelProperty(value = "应收单单据日期")
    private LocalDateTime arDate;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 未核销金额
     */
    @ApiModelProperty(value = "未核销金额")
    private BigDecimal notVerAmt;

    /**
     * 本次核销金额
     */
    @ApiModelProperty(value = "本次核销金额")
    @NotNull(message = "核销金额不能为空")
    private BigDecimal verAmt;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    /**
     * 本次核销原始金额
     */
    private BigDecimal origVerAmt;

    @ApiModelProperty(value = "来源行号")
    private Integer sourceLine;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "计量单位名称")
    private String uomName;

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;
}
